/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools.io;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSON;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSONParser;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONArray;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONObject;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.ParseException;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.Serializable;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.SpigotDataMask;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigMask
implements SpigotDataMask {
    private String prefix;
    private final ConfigFile file;

    public ConfigMask(ConfigFile file) {
        this(file, null);
    }

    public ConfigMask(ConfigFile file, String prefix) {
        this.file = file;
        this.prefix = prefix == null ? "" : prefix;
    }

    private FileConfiguration c() {
        return this.file.getConfig();
    }

    private String k(String key) {
        return (this.prefix.isEmpty() ? "" : this.prefix + ".") + key;
    }

    public ConfigFile getFile() {
        return this.file;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Set<String> keySet(boolean depth) {
        Set o = this.c().getKeys(true);
        HashSet<String> data = new HashSet<String>();
        if (depth) {
            for (String s : o) {
                if (this.prefix.isEmpty()) {
                    data.add(s);
                    continue;
                }
                if (!s.startsWith(this.prefix + ".")) continue;
                data.add(s.replace(this.prefix + ".", ""));
            }
        } else {
            for (String s : o) {
                if (this.prefix.isEmpty()) {
                    data.add(s.split("\\.")[0]);
                    continue;
                }
                if (!s.startsWith(this.prefix + ".")) continue;
                data.add(s.replace(this.prefix + ".", "").split("\\.")[0]);
            }
        }
        return data;
    }

    public void write(Serializable s, String key) {
        String oldPrefix = this.prefix;
        this.prefix = this.k(key);
        s.write(this);
        this.prefix = oldPrefix;
    }

    public void read(Serializable s, String key) throws Exception {
        String oldPrefix = this.prefix;
        this.prefix = this.k(key);
        s.read(this);
        this.prefix = oldPrefix;
    }

    @Override
    public Object finalCommit(String key, Object value) {
        Object prev;
        if (value instanceof Serializable) {
            this.write((Serializable)value, key);
            prev = null;
        } else {
            prev = this.c().get(this.k(key));
            this.c().set(this.k(key), value);
        }
        return prev;
    }

    @Override
    public Object remove(String key) {
        Object prev = this.c().get(this.k(key));
        this.c().set(this.k(key), null);
        return prev;
    }

    @Override
    public <T extends Serializable> T getSerializable(String key, Serializable serializable) {
        try {
            this.read(serializable, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)serializable;
    }

    @Override
    public Boolean getBoolean(String key, Boolean def) {
        return this.c().getBoolean(this.k(key), def.booleanValue());
    }

    @Override
    public Integer getInteger(String key, Integer def) {
        return this.c().getInt(this.k(key), def.intValue());
    }

    @Override
    public JSONArray getList(String key) {
        JSONArray array = new JSONArray();
        List l = this.c().getList(this.k(key));
        if (l == null) {
            return array;
        }
        array.addAll(l);
        return array;
    }

    @Override
    public Long getLong(String key, Long def) {
        return this.c().getLong(this.k(key), def.longValue());
    }

    @Override
    public Double getDouble(String key, Double def) {
        return this.c().getDouble(this.k(key), def.doubleValue());
    }

    @Override
    public Float getFloat(String key, Float def) {
        Double d = this.getDouble(key);
        return Float.valueOf(d == null ? def.floatValue() : d.floatValue());
    }

    @Override
    public <T> T get(String key, T def, boolean raw) {
        Object o = this.c().get(this.k(key));
        if (!raw) {
            long l;
            if (o instanceof Long && (l = ((Long)o).longValue()) <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (T)Integer.valueOf(Math.toIntExact(l));
            }
            if (o instanceof String) {
                try {
                    Object result = new JSONParser().parse((String)o);
                    if (result != null) {
                        o = result;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (o instanceof JSONObject) {
                return (T)new JSON((Map)((JSONObject)o));
            }
        }
        return (T)(o == null ? def : o);
    }
}

