/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools;

import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSON;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSONParser;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.DataMask;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.Serializable;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class Location
extends org.bukkit.Location
implements Serializable {
    private String worldName;

    public Location(String worldName, double x, double y, double z, float yaw, float pitch) {
        super(worldName == null ? null : Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
        this.worldName = worldName;
    }

    public Location(String worldName, double x, double y, double z) {
        super(worldName == null ? null : Bukkit.getWorld((String)worldName), x, y, z, 0.0f, 0.0f);
        this.worldName = worldName;
    }

    public Location(World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, yaw, pitch);
        this.worldName = world == null ? null : world.getName();
    }

    public Location(World world, double x, double y, double z) {
        super(world, x, y, z, 0.0f, 0.0f);
        this.worldName = world == null ? null : world.getName();
    }

    public Location(Location location) {
        this();
        this.apply(location);
    }

    public Location(org.bukkit.Location location) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.worldName = location instanceof Location ? ((Location)location).getWorldName() : (location.getWorld() == null ? null : location.getWorld().getName());
    }

    public Location(JSON json) {
        super(json.get("World") == null ? null : Bukkit.getWorld((String)((String)json.get("World"))), json.getDouble("X").doubleValue(), json.getDouble("Y").doubleValue(), json.getDouble("Z").doubleValue(), json.getFloat("Yaw").floatValue(), json.getFloat("Pitch").floatValue());
        this.worldName = json.getString("World");
    }

    public Location() {
        super(null, 0.0, 0.0, 0.0);
    }

    public boolean hasOnlyCoords() {
        return this.getYaw() == 0.0f && this.getPitch() == 0.0f;
    }

    public String toJSONString() {
        return this.toJSON(2).toJSONString();
    }

    public JSON toJSON(int decimalPlaces) {
        JSON json = new JSON();
        json.put("world", this.worldName);
        json.put("x", this.trim(this.getX(), decimalPlaces));
        json.put("y", this.trim(this.getY(), decimalPlaces));
        json.put("z", this.trim(this.getZ(), decimalPlaces));
        json.put("yaw", Float.valueOf(this.trim(this.getYaw(), decimalPlaces)));
        json.put("pitch", Float.valueOf(this.trim(this.getPitch(), decimalPlaces)));
        return json;
    }

    @Override
    public boolean read(DataMask d) throws Exception {
        this.worldName = d.getString("World");
        this.setWorld(this.worldName == null ? null : Bukkit.getWorld((String)this.worldName));
        this.setX(d.getDouble("X"));
        this.setY(d.getDouble("Y"));
        this.setZ(d.getDouble("Z"));
        this.setYaw(d.getFloat("Yaw").floatValue());
        this.setPitch(d.getFloat("Pitch").floatValue());
        if (this.worldName == null && this.getX() == 0.0 && this.getY() == 0.0 && this.getZ() == 0.0 && this.getYaw() == 0.0f && this.getPitch() == 0.0f) {
            this.worldName = d.getString("world");
            this.setWorld(this.worldName == null ? null : Bukkit.getWorld((String)this.worldName));
            this.setX(d.getDouble("x"));
            this.setY(d.getDouble("y"));
            this.setZ(d.getDouble("z"));
            this.setYaw(d.getFloat("yaw").floatValue());
            this.setPitch(d.getFloat("pitch").floatValue());
        }
        return true;
    }

    @Override
    public void write(DataMask json) {
        try {
            json.put("World", this.getWorld() == null ? this.worldName : this.getWorld().getName());
        }
        catch (Throwable t) {
            json.put("World", this.worldName);
        }
        json.put("X", this.trim(this.getX(), 4));
        json.put("Y", this.trim(this.getY(), 4));
        json.put("Z", this.trim(this.getZ(), 4));
        json.put("Yaw", Float.valueOf(this.trim(this.getYaw(), 4)));
        json.put("Pitch", Float.valueOf(this.trim(this.getPitch(), 4)));
    }

    @Override
    public void destroy() {
    }

    public Location add(org.bukkit.Location vec) {
        return (Location)super.add(vec);
    }

    public Location add(Vector vec) {
        return (Location)super.add(vec);
    }

    public Location add(double x, double y, double z) {
        return (Location)super.add(x, y, z);
    }

    public Location subtract(org.bukkit.Location vec) {
        return (Location)super.subtract(vec);
    }

    public Location subtract(Vector vec) {
        return (Location)super.subtract(vec);
    }

    public Location subtract(double x, double y, double z) {
        return (Location)super.subtract(x, y, z);
    }

    public Location trim(int decimalPlaces) {
        this.setX(this.trim(this.getX(), decimalPlaces));
        this.setY(this.trim(this.getY(), decimalPlaces));
        this.setZ(this.trim(this.getZ(), decimalPlaces));
        this.setYaw(this.trim(this.getYaw(), decimalPlaces));
        this.setPitch(this.trim(this.getPitch(), decimalPlaces));
        return this;
    }

    public void apply(org.bukkit.Location l) {
        this.setWorld(l.getWorld());
        if (l instanceof Location) {
            this.setWorldName(((Location)l).getWorldName());
        }
        this.setX(l.getX());
        this.setY(l.getY());
        this.setZ(l.getZ());
        this.setYaw(l.getYaw());
        this.setPitch(l.getPitch());
    }

    private double trim(double d, int decimalPlaces) {
        return (double)((long)d) + this.round((float)(d % 1.0), decimalPlaces);
    }

    private float trim(float f, int decimalPlaces) {
        return (float)((double)((long)f) + this.round(f % 1.0f, decimalPlaces));
    }

    private double round(double decimal, int decimalPlaces) {
        double factor = Math.pow(10.0, decimalPlaces);
        return (double)((long)(decimal * factor)) / factor;
    }

    public String toJSONString(int decimalPlaces) {
        return this.toJSON(decimalPlaces).toJSONString();
    }

    public void setWorld(World world) {
        super.setWorld(world);
        if (world != null) {
            this.worldName = world.getName();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof org.bukkit.Location)) {
            return false;
        }
        org.bukkit.Location other = (org.bukkit.Location)obj;
        if (!(this.getWorld() == other.getWorld() || this.getWorld() != null && this.getWorld().equals(other.getWorld()))) {
            return false;
        }
        if (Double.doubleToLongBits(this.getX()) != Double.doubleToLongBits(other.getX())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getY()) != Double.doubleToLongBits(other.getY())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getZ()) != Double.doubleToLongBits(other.getZ())) {
            return false;
        }
        if (Float.floatToIntBits(this.getPitch()) != Float.floatToIntBits(other.getPitch())) {
            return false;
        }
        return Float.floatToIntBits(this.getYaw()) == Float.floatToIntBits(other.getYaw());
    }

    public World getWorld() {
        try {
            if (super.getWorld() == null) {
                if (this.worldName != null) {
                    this.setWorld(Bukkit.getWorld((String)this.worldName));
                }
            } else if (Bukkit.getWorld((String)this.worldName) == null) {
                this.setWorld(null);
            }
        }
        catch (IllegalArgumentException ex) {
            this.setWorld(Bukkit.getWorld((String)this.worldName));
        }
        return super.getWorld();
    }

    public boolean isEmpty() {
        return this.worldName == null && this.getWorld() == null && this.getX() == 0.0 && this.getY() == 0.0 && this.getZ() == 0.0 && this.getYaw() == 0.0f && this.getPitch() == 0.0f;
    }

    public Location clone() {
        return new Location(this);
    }

    public static Location getByJSONString(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            return new Location((JSON)new JSONParser().parse(jsonString));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Location getByLocation(org.bukkit.Location location) {
        if (location == null) {
            return null;
        }
        return new Location(location);
    }

    public String getWorldName() {
        if (this.worldName == null && this.getWorld() != null) {
            this.worldName = this.getWorld().getName();
        }
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
        if (worldName != null) {
            this.setWorld(Bukkit.getWorld((String)worldName));
        }
    }
}

