/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.tools;

import org.bukkit.Location;
import org.bukkit.entity.Player;

public class HitBox {
    private double lX;
    private double lY;
    private double lZ;
    private double hX;
    private double hY;
    private double hZ;

    public HitBox() {
    }

    public HitBox(HitBox box) {
        this.lX = box.lX;
        this.lY = box.lY;
        this.lZ = box.lZ;
        this.hX = box.hX;
        this.hY = box.hY;
        this.hZ = box.hZ;
    }

    public HitBox(Player player) {
        this(player.getLocation(), 0.0, player.getEyeHeight());
    }

    public HitBox(Location l, double width, double height) {
        this(l.getX() - width, l.getY(), l.getZ() - width, l.getX() + width, l.getY() + height, l.getZ() + width);
    }

    public HitBox(double x, double y, double z) {
        this(x, y, z, x, y, z);
    }

    public HitBox(double lX, double lY, double lZ, double hX, double hY, double hZ) {
        this.lX = lX;
        this.lY = lY;
        this.lZ = lZ;
        this.hX = hX;
        this.hY = hY;
        this.hZ = hZ;
    }

    public void addProperty(HitBox box) {
        this.lX = Math.min(this.lX, box.lX);
        this.lY = Math.min(this.lY, box.lY);
        this.lZ = Math.min(this.lZ, box.lZ);
        this.hX = Math.max(this.hX, box.hX);
        this.hY = Math.max(this.hY, box.hY);
        this.hZ = Math.max(this.hZ, box.hZ);
    }

    public void addProperty(double x, double y, double z) {
        this.lX = Math.min(this.lX, x);
        this.lY = Math.min(this.lY, y);
        this.lZ = Math.min(this.lZ, z);
        this.hX = Math.max(this.hX, x);
        this.hY = Math.max(this.hY, y);
        this.hZ = Math.max(this.hZ, z);
    }

    public boolean collides(HitBox box) {
        HitBox lower;
        HitBox higher;
        if (this.hX - this.lX >= box.hX - box.lX) {
            higher = this;
            lower = box;
        } else {
            higher = box;
            lower = this;
        }
        if (higher.lX <= lower.lX && higher.hX >= lower.lX || higher.lX <= lower.hX && higher.hX >= lower.hX || higher.lX > lower.lX && higher.hX < lower.hX) {
            if (this.hY - this.lY >= box.hY - box.lY) {
                higher = this;
                lower = box;
            } else {
                higher = box;
                lower = this;
            }
            if (higher.lY <= lower.lY && higher.hY >= lower.lY || higher.lY <= lower.hY && higher.hY >= lower.hY || higher.lY > lower.lY && higher.hY < lower.hY) {
                if (this.hZ - this.lZ >= box.hZ - box.lZ) {
                    higher = this;
                    lower = box;
                } else {
                    higher = box;
                    lower = this;
                }
                return higher.lZ <= lower.lZ && higher.hZ >= lower.lZ || higher.lZ <= lower.hZ && higher.hZ >= lower.hZ || higher.lZ > lower.lZ && higher.hZ < lower.hZ;
            }
        }
        return false;
    }

    public double getlX() {
        return this.lX;
    }

    public void setlX(double lX) {
        this.lX = lX;
    }

    public double getlY() {
        return this.lY;
    }

    public void setlY(double lY) {
        this.lY = lY;
    }

    public double getlZ() {
        return this.lZ;
    }

    public void setlZ(double lZ) {
        this.lZ = lZ;
    }

    public double gethX() {
        return this.hX;
    }

    public void sethX(double hX) {
        this.hX = hX;
    }

    public double gethY() {
        return this.hY;
    }

    public void sethY(double hY) {
        this.hY = hY;
    }

    public double gethZ() {
        return this.hZ;
    }

    public void sethZ(double hZ) {
        this.hZ = hZ;
    }
}

