/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.specification;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.specification.Type;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public enum Version {
    UNKNOWN(0.0),
    v1_7(7.0),
    v1_8(8.0),
    v1_9(9.0),
    v1_10(10.0),
    v1_11(11.0),
    v1_12(12.0),
    v1_13(13.0),
    v1_14(14.0),
    v1_15(15.0),
    v1_16(16.0),
    v1_17(17.0),
    v1_17_1(17.1),
    v1_18(18.0, 18.1),
    v1_18_2(18.2),
    v1_19(19.0),
    v1_19_1(19.1),
    v1_19_2(19.2),
    v1_19_3(19.3),
    v1_19_4(19.4),
    v1_20(20.0, 20.1),
    v1_20_2(20.2),
    v1_20_4(20.4),
    v1_20_6(20.5, 20.6),
    v1_21(21.0);

    private static boolean supportWarning;
    private static Version VERSION;
    private static String NAME;
    private static String SPECIFICATION;
    private static Type TYPE;
    private final double[] id;

    private Version(double ... id) {
        this.id = id;
    }

    private static void load() {
        if (VERSION == null) {
            if (ServerBuildInfo.isAvailable()) {
                TYPE = Type.PAPER;
                NAME = "Paper";
                SPECIFICATION = ServerBuildInfo.minecraftVersionName();
                double version = Double.parseDouble(ServerBuildInfo.minecraftVersionId().substring(2));
                VERSION = Version.byId(version);
            } else {
                String bukkitVersion = Bukkit.getVersion();
                Pattern p = Pattern.compile("\\(MC: \\d\\.\\d\\d?\\.\\d\\d?");
                Matcher match = p.matcher(bukkitVersion);
                if (match.find()) {
                    double version = Double.parseDouble(match.group().substring(7));
                    VERSION = Version.byId(version);
                }
                SPECIFICATION = Bukkit.getVersion();
                try {
                    int to;
                    int from = bukkitVersion.indexOf(45);
                    if (from >= 0 && (to = bukkitVersion.indexOf("-", ++from)) >= 0) {
                        NAME = bukkitVersion.substring(from, to);
                        TYPE = Type.getByName(NAME);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public static Version get() {
        return VERSION;
    }

    public static Type type() {
        return TYPE;
    }

    public static boolean atLeast(double version) {
        return Version.get().id[Version.get().id.length - 1] >= version;
    }

    public static boolean atMost(double version) {
        return Version.get().id[0] <= version;
    }

    public static boolean later(double version) {
        return Version.get().id[0] < version;
    }

    public static boolean before(double version) {
        return Version.get().id[0] < version;
    }

    @Deprecated
    public static boolean less(double version) {
        return Version.before(version);
    }

    public static boolean between(double min, double max) {
        return Version.atLeast(min) && Version.atMost(max);
    }

    @NotNull
    private static Version byId(double version) {
        Version highest = null;
        for (Version value : Version.values()) {
            for (double id : value.id) {
                if (id != version) continue;
                return value;
            }
            highest = value;
        }
        int casted = (int)version;
        if (highest != null && (int)highest.id[highest.id.length - 1] == casted) {
            return highest;
        }
        for (Version value : Version.values()) {
            for (double id : value.id) {
                if (id != (double)casted) continue;
                return value;
            }
        }
        if (highest != null && version > highest.getId()) {
            if (supportWarning) {
                API.getInstance().getMainPlugin().getLogger().warning("Detected version " + version + " which is not yet fully supported (highest: " + highest.getId() + ")! Use with caution!");
                supportWarning = false;
            }
            return highest;
        }
        throw new IllegalArgumentException("Version not found: " + version);
    }

    public static <T> T choose(T def, double version1, T value1) {
        return Version.choose(def, version1, value1, 0.0, null);
    }

    public static <T> T choose(T def, double version1, T value1, double version2, T value2) {
        return Version.choose(def, version1, value1, version2, value2, 0.0, null);
    }

    public static <T> T choose(T def, double version1, T value1, double version2, T value2, double version3, T value3) {
        return Version.choose(def, version1, value1, version2, value2, version3, value3, 0.0, null);
    }

    public static <T> T choose(T def, double version1, T value1, double version2, T value2, double version3, T value3, double version4, T value4) {
        return Version.choose(def, version1, value1, version2, value2, version3, value3, version4, value4, 0.0, null);
    }

    public static <T> T choose(T def, double version1, T value1, double version2, T value2, double version3, T value3, double version4, T value4, double version5, T value5) {
        return Version.choose(def, version1, value1, version2, value2, version3, value3, version4, value4, version5, value5, 0.0, null);
    }

    public static <T> T choose(T def, double version1, T value1, double version2, T value2, double version3, T value3, double version4, T value4, double version5, T value5, double version6, T value6) {
        Object[] values = new Object[]{def, value1, value2, value3, value4, value5, value6};
        double[] versions = new double[]{-1.0, version1, version2, version3, version4, version5, version6};
        for (int i = 0; i < versions.length; ++i) {
            double version = versions[i];
            if (version == -1.0) continue;
            if (version == 0.0) {
                return (T)values[i - 1];
            }
            int diff = Version.get().ordinal() - Version.byId(version).ordinal();
            if (diff >= 0) continue;
            return (T)values[i - 1];
        }
        return (T)values[values.length - 1];
    }

    @SafeVarargs
    public static <T> T since(double version, T old, T ... updated) {
        Version v = Version.byId(version);
        int diff = Version.get().ordinal() - v.ordinal();
        if (diff >= 0) {
            if (diff >= updated.length || updated[diff] == null) {
                for (int i = diff = Math.min(diff, updated.length - 1); i >= 0; --i) {
                    if (updated[i] == null) continue;
                    return updated[i];
                }
            } else {
                return updated[diff];
            }
        }
        return old;
    }

    public double getId() {
        return this.id[this.id.length - 1];
    }

    public String fullVersion() {
        return NAME + " (" + SPECIFICATION + ", " + (Object)((Object)TYPE) + ")";
    }

    public String getShortVersionName() {
        return Bukkit.getBukkitVersion().split("-")[0];
    }

    public boolean isBiggerThan(Version version) {
        return this.ordinal() > version.ordinal();
    }

    public boolean isBiggerThan(double version) {
        return this.id[this.id.length - 1] > version;
    }

    static {
        supportWarning = true;
        VERSION = null;
        NAME = null;
        SPECIFICATION = null;
        TYPE = Type.UNKNOWN;
        Version.load();
    }

    private static class ServerBuildInfo {
        private static final Object info;
        private static final IReflection.MethodAccessor minecraftVersionId;
        private static final IReflection.MethodAccessor minecraftVersionName;

        private ServerBuildInfo() {
        }

        private static boolean isAvailable() {
            return info != null;
        }

        @NotNull
        private static String minecraftVersionId() {
            if (minecraftVersionId == null) {
                throw new IllegalStateException();
            }
            return (String)minecraftVersionId.invoke(info, new Object[0]);
        }

        @NotNull
        private static String minecraftVersionName() {
            if (minecraftVersionName == null) {
                throw new IllegalStateException();
            }
            return (String)minecraftVersionName.invoke(info, new Object[0]);
        }

        static {
            Class<?> infoClass;
            try {
                infoClass = Class.forName("io.papermc.paper.ServerBuildInfo");
            }
            catch (ClassNotFoundException e) {
                infoClass = null;
            }
            if (infoClass == null) {
                info = null;
                minecraftVersionId = null;
                minecraftVersionName = null;
            } else {
                IReflection.MethodAccessor buildInfo = IReflection.getMethod(infoClass, infoClass, new Class[0]);
                info = buildInfo.invoke(null, new Object[0]);
                minecraftVersionId = IReflection.getMethod(infoClass, "minecraftVersionId", String.class, new Class[0]);
                minecraftVersionName = IReflection.getMethod(infoClass, "minecraftVersionName", String.class, new Class[0]);
            }
        }
    }
}

