/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.sounds;

import de.codingair.tradesystem.lib.codingapi.server.sounds.Sound;
import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SoundData {
    private Sound sound;
    private float volume;
    private float pitch;

    public SoundData(Sound sound, float volume, float pitch) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    public Sound getSound() {
        return this.sound;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void play(Player player) {
        if (!this.sound.isSupported()) {
            return;
        }
        this.sound.playSound((Entity)player, this.volume, this.pitch);
    }

    public void stop(Player player) {
        this.sound.stopSound(player);
    }

    public SoundData clone() {
        return new SoundData(this.sound, this.volume, this.pitch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoundData soundData = (SoundData)o;
        return Float.compare(soundData.volume, this.volume) == 0 && Float.compare(soundData.pitch, this.pitch) == 0 && this.sound == soundData.sound;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sound, Float.valueOf(this.volume), Float.valueOf(this.pitch)});
    }
}

