/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.sounds;

import de.codingair.tradesystem.lib.codingapi.server.sounds.Sound;
import de.codingair.tradesystem.lib.codingapi.server.sounds.SoundData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MusicData
extends SoundData {
    private final int delay;
    private MusicData follower;

    public MusicData(Sound sound, float volume, float pitch, int delay) {
        super(sound, volume, pitch);
        this.delay = delay;
    }

    public MusicData(SoundData data, int delay) {
        super(data.getSound(), data.getVolume(), data.getPitch());
        this.delay = delay;
    }

    public void play(final Player player, JavaPlugin plugin) {
        BukkitRunnable runnable = new BukkitRunnable(){
            int currentDelay = 0;
            MusicData musicPlayer = MusicData.this;

            public void run() {
                if (this.currentDelay == this.musicPlayer.getDelay()) {
                    this.currentDelay = 0;
                    this.musicPlayer.getSound().playSound((Entity)player, this.musicPlayer.getVolume(), this.musicPlayer.getPitch());
                    if (this.musicPlayer.getFollower() == null) {
                        this.cancel();
                        return;
                    }
                    this.musicPlayer = this.musicPlayer.getFollower();
                } else {
                    ++this.currentDelay;
                }
            }
        };
        runnable.runTaskTimer((Plugin)plugin, 0L, 1L);
    }

    public MusicData getFollower() {
        return this.follower;
    }

    public void setFollower(MusicData follower) {
        this.follower = follower;
    }

    public int getDelay() {
        return this.delay;
    }
}

