/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.reflections;

import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONObject;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONParser;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.ParseException;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;

public class PotionData {
    private PotionType type;
    private int level;
    private boolean splash;
    private boolean extended;

    public PotionData(PotionType type, int level, boolean splash, boolean extended) {
        this.type = type;
        this.level = level;
        this.splash = splash;
        this.extended = extended;
    }

    public PotionData(ItemStack item) {
        if (Version.get().isBiggerThan(Version.v1_8)) {
            if (item.getItemMeta() instanceof PotionMeta) {
                PotionMeta meta = (PotionMeta)item.getItemMeta();
                org.bukkit.potion.PotionData data = meta.getBasePotionData();
                this.type = data.getType();
                this.level = data.isUpgraded() ? 2 : 1;
                this.splash = false;
                this.extended = data.isExtended();
            }
        } else {
            Potion potion = Potion.fromItemStack((ItemStack)item);
            this.type = potion.getType();
            this.level = potion.getLevel();
            this.splash = potion.isSplash();
            this.extended = potion.hasExtendedDuration();
        }
    }

    public PotionData(Potion potion) {
        this.type = potion.getType();
        this.level = potion.getLevel();
        this.splash = potion.isSplash();
        this.extended = potion.hasExtendedDuration();
    }

    public PotionType getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isSplash() {
        return this.splash;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public PotionMeta getMeta() {
        if (this.getPotion() == null) {
            return null;
        }
        return (PotionMeta)this.getPotion().toItemStack(1).getItemMeta();
    }

    public Potion getPotion() {
        if (this.type == null) {
            return null;
        }
        return new Potion(this.type, this.level, this.splash, this.extended);
    }

    public org.bukkit.potion.PotionData getBukkitData() {
        return new org.bukkit.potion.PotionData(this.type, this.extended, this.level == 2);
    }

    public boolean isCorrect() {
        return this.type != null;
    }

    public String toJSONString() {
        JSONObject object = new JSONObject();
        object.put("Type", this.type.name());
        object.put("Level", this.level);
        object.put("Splash", this.splash);
        object.put("Extended", this.extended);
        return object.toJSONString();
    }

    public static PotionData fromJSONString(String code) {
        try {
            JSONObject json = (JSONObject)new JSONParser().parse(code);
            PotionType type = PotionType.valueOf((String)((String)json.get("Type")));
            int level = Integer.parseInt(json.get("Level") + "");
            boolean splash = (Boolean)json.get("Splash");
            boolean extended = (Boolean)json.get("Extended");
            return new PotionData(type, level, splash, extended);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

