/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.reflections;

import de.codingair.tradesystem.lib.codingapi.nms.NmsLoader;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.Packet;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.tools.items.XMaterial;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class PacketUtils {
    public static final Class<?> CraftPlayerClass = PacketUtils.getClass(IReflection.ServerPacket.CRAFTBUKKIT_PACKAGE, "entity.CraftPlayer");
    public static final Class<?> CraftEntityClass = PacketUtils.getClass(IReflection.ServerPacket.CRAFTBUKKIT_PACKAGE, "entity.CraftEntity");
    public static final Class<?> CraftServerClass = PacketUtils.getClass(IReflection.ServerPacket.CRAFTBUKKIT_PACKAGE, "CraftServer");
    public static final Class<?> CraftBlockClass = PacketUtils.getClass(IReflection.ServerPacket.CRAFTBUKKIT_BLOCK, "CraftBlock");
    public static final Class<?> MinecraftServerClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.server"), "MinecraftServer");
    public static final Class<?> DedicatedServerClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.server.dedicated"), "DedicatedServer");
    public static final Class<?> CraftWorldClass = PacketUtils.getClass(IReflection.ServerPacket.CRAFTBUKKIT_PACKAGE, "CraftWorld");
    public static final Class<?> WorldClass = PacketUtils.getClass(IReflection.ServerPacket.WORLD_LEVEL, Version.choose("World", 20.5, "Level"));
    public static final Class<?> WorldServerClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.server.level"), Version.choose("WorldServer", 20.5, "ServerLevel"));
    public static final Class<?> BlockPositionClass = PacketUtils.getClass(IReflection.ServerPacket.CORE, Version.since(20.5, "BlockPosition", "BlockPos"));
    public static final Class<?> BlockClass = PacketUtils.getClass(IReflection.ServerPacket.BLOCK, "Block");
    public static final Class<?> BlocksClass = PacketUtils.getClass(IReflection.ServerPacket.BLOCK, "Blocks");
    public static final Class<?> IBlockDataClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.level.block.state"), Version.choose("IBlockData", 20.5, "BlockState"));
    public static final Class<?> TileEntityClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.level.block.entity"), Version.choose("TileEntity", 20.5, "BlockEntity"));
    public static final Class<?> TileEntitySignClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.level.block.entity"), Version.choose("TileEntitySign", 20.5, "SignBlockEntity"));
    public static final Class<?> NBTTagCompoundClass = PacketUtils.getClass(IReflection.ServerPacket.NBT, Version.choose("NBTTagCompound", 20.5, "CompoundTag"));
    public static final Class<?> EntityClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.entity"), "Entity");
    public static final Class<?> EntityPlayerClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.server.level"), Version.choose("EntityPlayer", 20.5, "ServerPlayer"));
    public static final Class<?> EntityLivingClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.entity"), Version.choose("EntityLiving", 20.5, "LivingEntity"));
    public static final Class<?> EntityHumanClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.entity.player"), Version.choose("EntityHuman", 20.5, "Player"));
    public static final Class<?> ItemStackClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.item"), "ItemStack");
    public static final Class<?> CraftItemStackClass = PacketUtils.getClass(IReflection.ServerPacket.CRAFTBUKKIT_PACKAGE, "inventory.CraftItemStack");
    public static final IReflection.MethodAccessor getCustomModelData = PacketUtils.getMethod(ItemMeta.class, "getCustomModelData", Integer.TYPE, new Class[0], true);
    public static final IReflection.MethodAccessor hasCustomModelData = PacketUtils.getMethod(ItemMeta.class, "hasCustomModelData", Boolean.TYPE, new Class[0], true);
    public static final IReflection.MethodAccessor setCustomModelData = PacketUtils.getMethod(ItemMeta.class, "setCustomModelData", new Class[]{Integer.TYPE}, true);
    public static final Class<?> PlayerConnectionClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.server.network"), Version.choose("PlayerConnection", 20.5, "ServerGamePacketListenerImpl"));
    public static final Class<?> NetworkManagerClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.network"), Version.choose("NetworkManager", 20.5, "Connection"));
    public static final Class<?> DataWatcherClass = PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.network.syncher"), Version.choose("DataWatcher", 20.5, "SynchedEntityData"));
    public static final Class<?> DataWatcherObjectClass = IReflection.wrap(Version.atLeast(19.3), () -> PacketUtils.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.network.syncher"), Version.choose("DataWatcherObject", 20.5, "EntityDataAccessor")));
    public static final Class<?> PacketClass = PacketUtils.getClass(IReflection.ServerPacket.PROTOCOL, "Packet");
    public static final Class<?> PacketPlayOutAttachEntityClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutAttachEntity");
    public static final Class<?> PacketPlayOutEntityDestroyClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutEntityDestroy");
    public static final Class<?> PacketPlayOutEntityTeleportClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutEntityTeleport");
    public static final Class<?> PacketPlayOutEntityVelocityClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutEntityVelocity");
    public static final Class<?> PacketPlayOutEntityMetadataClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutEntityMetadata");
    public static final Class<?> PacketPlayOutSpawnEntityLivingClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutSpawnEntityLiving", true);
    public static final Class<?> PacketPlayOutSpawnEntityClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutSpawnEntity");
    public static final Class<?> PacketPlayOutBlockActionClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutBlockAction");
    public static final Class<?> PacketPlayInUpdateSignClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayInUpdateSign");
    public static final Class<?> PacketPlayOutOpenSignEditorClass = PacketUtils.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutOpenSignEditor");
    public static final Class<?> ChatSerializerClass = PacketUtils.getClass(IReflection.ServerPacket.CHAT, Version.since(20.5, "IChatBaseComponent$ChatSerializer", "Component$Serializer"));
    public static final Class<?> IChatMutableComponentClass = IReflection.wrap(Version.atLeast(16.0), () -> PacketUtils.getClass(IReflection.ServerPacket.CHAT, Version.choose("IChatMutableComponent", 20.5, "MutableComponent")));
    public static final Class<?> IChatBaseComponentClass = PacketUtils.getClass(IReflection.ServerPacket.CHAT, Version.choose("IChatBaseComponent", 20.5, "Component"));
    public static final IReflection.MethodAccessor getHandle = PacketUtils.getMethod(CraftPlayerClass, "getHandle", EntityPlayerClass, new Class[0]);
    public static final IReflection.MethodAccessor getHandleEntity = PacketUtils.getMethod(CraftEntityClass, "getHandle", EntityClass, new Class[0]);
    public static final IReflection.MethodAccessor getBukkitEntity = PacketUtils.getMethod(EntityClass, "getBukkitEntity", CraftEntityClass, new Class[0]);
    public static final IReflection.MethodAccessor getHandleOfCraftWorld = PacketUtils.getMethod(CraftWorldClass, "getHandle", WorldServerClass, new Class[0]);
    public static final IReflection.MethodAccessor sendPacket;
    public static final IReflection.MethodAccessor getEntityId;
    public static final IReflection.MethodAccessor getTileEntity;
    public static final IReflection.FieldAccessor<Integer> getId;
    public static final IReflection.FieldAccessor<?> playerConnection;
    public static final Class<?> HolderLookupProvider;

    @NmsLoader
    private PacketUtils() {
    }

    public static IReflection.MethodAccessor getMethod(Class<?> target, String methodName, Class<?>[] parameterTypes) {
        return PacketUtils.getMethod(target, methodName, null, parameterTypes, false);
    }

    public static IReflection.MethodAccessor getMethod(Class<?> target, String methodName, Class<?> returnType, Class<?>[] parameterTypes) {
        return PacketUtils.getMethod(target, methodName, returnType, parameterTypes, false);
    }

    public static IReflection.MethodAccessor getMethod(Class<?> target, String methodName, Class<?>[] parameterTypes, boolean acceptNull) {
        return PacketUtils.getMethod(target, methodName, null, parameterTypes, acceptNull);
    }

    public static IReflection.MethodAccessor getMethod(Class<?> target, String methodName, Class<?> returnType, Class<?>[] parameterTypes, boolean acceptNull) {
        if (acceptNull) {
            try {
                return IReflection.getMethod(target, methodName, returnType, parameterTypes);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return IReflection.getMethod(target, methodName, returnType, parameterTypes);
    }

    public static Class<?> getClass(IReflection.ServerPacket packet, String className) {
        return PacketUtils.getClass(packet, className, false);
    }

    public static Class<?> getClass(IReflection.ServerPacket packet, String className, boolean acceptNull) {
        return PacketUtils.getClass(packet.toString(), className, acceptNull);
    }

    public static Class<?> getClass(String packet, String className) {
        return PacketUtils.getClass(packet, className, false);
    }

    public static Class<?> getClass(String packet, String className, boolean acceptNull) {
        if (acceptNull) {
            try {
                return IReflection.getClass(packet, className);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return IReflection.getClass(packet, className);
    }

    public static void sendBlockChange(@NotNull Player player, @NotNull Location location, @NotNull XMaterial data) {
        Object iBlockData = PacketUtils.getIBlockData(data);
        PacketUtils.sendBlockChange(player, location, iBlockData);
    }

    public static void sendBlockChange(@NotNull Player player, @NotNull Location location, @NotNull Block data) {
        Object iBlockData;
        if (Version.atLeast(13.0)) {
            IReflection.MethodAccessor getState = IReflection.getMethod(CraftBlockClass, IBlockDataClass, new Class[0]);
            iBlockData = getState.invoke(data, new Object[0]);
        } else {
            IReflection.MethodAccessor getState = IReflection.getMethod(CraftBlockClass, BlockClass, new Class[0]);
            IReflection.MethodAccessor getBlockData = IReflection.getMethod(BlockClass, IBlockDataClass, new Class[0]);
            Object nmsBlock = getState.invoke(data, new Object[0]);
            iBlockData = getBlockData.invoke(nmsBlock, new Object[0]);
        }
        PacketUtils.sendBlockChange(player, location, iBlockData);
    }

    public static void sendBlockChange(@NotNull Player player, @NotNull Location location, @NotNull Object iBlockData) {
        Object packet;
        Class<?> packetPlayOutBlockChange = IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutBlockChange");
        Object blockPos = PacketUtils.getBlockPosition(location);
        if (Version.atLeast(17.0)) {
            IReflection.ConstructorAccessor con = IReflection.getConstructor(packetPlayOutBlockChange, BlockPositionClass, IBlockDataClass);
            if (con == null) {
                throw new NullPointerException("Cannot prepare temporary sign: Could not find PacketPlayOutBlockChange constructor.");
            }
            packet = con.newInstance(blockPos, iBlockData);
        } else {
            IReflection.ConstructorAccessor con = IReflection.getConstructor(packetPlayOutBlockChange, new Class[0]);
            if (con == null) {
                throw new NullPointerException("Cannot prepare temporary sign: Could not find PacketPlayOutBlockChange constructor.");
            }
            packet = con.newInstance(new Object[0]);
            IReflection.FieldAccessor<?> blockPosition = IReflection.getField(packetPlayOutBlockChange, BlockPositionClass, 0);
            IReflection.FieldAccessor<?> blockData = IReflection.getField(packetPlayOutBlockChange, IBlockDataClass, 0);
            blockPosition.set(packet, blockPos);
            blockData.set(packet, iBlockData);
        }
        PacketUtils.sendPacket(player, packet);
    }

    public static void sendPacketToAll(Object packet) {
        Bukkit.getOnlinePlayers().forEach(p -> PacketUtils.sendPacket(p, packet));
    }

    public static void sendPacket(Player target, Object packet) {
        if (!target.isOnline()) {
            return;
        }
        if (Version.atLeast(20.2)) {
            sendPacket.invoke(PacketUtils.getPlayerConnection(target), packet, null);
        } else {
            sendPacket.invoke(PacketUtils.getPlayerConnection(target), packet);
        }
    }

    public static Object getPlayerConnection(Player player) {
        Object entityPlayer = getHandle.invoke(CraftPlayerClass.cast(player), new Object[0]);
        return playerConnection.get(entityPlayer);
    }

    public static void sendPacket(Object packet, Player ... target) {
        for (Player player : target) {
            if (player == null) continue;
            PacketUtils.sendPacket(player, packet);
        }
    }

    public static Object getEntityPlayer(Player p) {
        if (p == null) {
            return null;
        }
        return getHandle.invoke(CraftPlayerClass.cast(p), new Object[0]);
    }

    public static Object getTileEntity(Location loc) {
        return getTileEntity.invoke(PacketUtils.getWorldServer(loc.getWorld()), PacketUtils.getBlockPosition(loc));
    }

    public static Object getCraftPlayer(Player p) {
        return CraftPlayerClass.cast(p);
    }

    public static int getEntityId(Player p) {
        Object cp = PacketUtils.getCraftPlayer(p);
        return (Integer)getEntityId.invoke(cp, new Object[0]);
    }

    public static Object getEntity(Entity entity) {
        return getHandleEntity.invoke(CraftEntityClass.cast(entity), new Object[0]);
    }

    public static Entity getBukkitEntity(Object entity) {
        return (Entity)getBukkitEntity.invoke(entity, new Object[0]);
    }

    public static Object getIChatBaseComponent(String text) {
        return PacketUtils.getRawIChatBaseComponent("{\"text\":\"" + text + "\"}");
    }

    public static Object getRawIChatBaseComponent(String jsonFormat) {
        if (Version.atLeast(20.5)) {
            IReflection.MethodAccessor fromJson = IReflection.getMethod(ChatSerializerClass, IChatMutableComponentClass, new Class[]{String.class, HolderLookupProvider});
            return fromJson.invoke(null, jsonFormat, PacketUtils.emptyHolderLookupProvider());
        }
        IReflection.MethodAccessor a = Version.atLeast(16.0) ? IReflection.getMethod(ChatSerializerClass, "a", IChatMutableComponentClass, new Class[]{String.class}) : IReflection.getMethod(ChatSerializerClass, "a", IChatBaseComponentClass, new Class[]{String.class});
        return a.invoke(IChatBaseComponentClass, jsonFormat);
    }

    public static Object getChatMessage(String text) {
        if (Version.atLeast(20.5)) {
            return PacketUtils.getIChatBaseComponent(text);
        }
        if (Version.atLeast(19.0)) {
            IReflection.MethodAccessor creator = IReflection.getMethod(IChatBaseComponentClass, IChatBaseComponentClass, new Class[]{String.class});
            return creator.invoke(null, text);
        }
        Class<?> ChatMessageClass = PacketUtils.getClass(IReflection.ServerPacket.CHAT, "ChatMessage");
        IReflection.ConstructorAccessor chatMessageCon = IReflection.getConstructor(ChatMessageClass, String.class, Object[].class);
        return chatMessageCon.newInstance(text, new Object[0]);
    }

    public static Object getMinecraftServer() {
        IReflection.MethodAccessor getServer = IReflection.getSaveMethod(CraftServerClass, "getServer", MinecraftServerClass, new Class[0]);
        if (getServer == null) {
            getServer = PacketUtils.getMethod(CraftServerClass, "getServer", DedicatedServerClass, new Class[0]);
        }
        return getServer.invoke(PacketUtils.getCraftServer(), new Object[0]);
    }

    public static Object getCraftServer() {
        return CraftServerClass.cast(Bukkit.getServer());
    }

    public static Object getWorldServer() {
        return PacketUtils.getWorldServer((World)Bukkit.getWorlds().get(0));
    }

    public static Object getWorldServer(World world) {
        return getHandleOfCraftWorld.invoke(CraftWorldClass.cast(world), new Object[0]);
    }

    public static Object getItemStack(ItemStack item) {
        IReflection.MethodAccessor asNMSCopy = IReflection.getMethod(CraftItemStackClass, "asNMSCopy", ItemStackClass, new Class[]{ItemStack.class});
        return asNMSCopy.invoke(null, item);
    }

    public static ItemStack getItemStack(Object item) {
        IReflection.MethodAccessor asNMSCopy = IReflection.getMethod(CraftItemStackClass, "asBukkitCopy", ItemStack.class, new Class[]{ItemStackClass});
        return (ItemStack)asNMSCopy.invoke(null, item);
    }

    public static Object getBlockPosition(Location location) {
        if (Version.atLeast(19.4)) {
            IReflection.ConstructorAccessor con = IReflection.getConstructor(BlockPositionClass, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return con.newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }
        IReflection.ConstructorAccessor con = IReflection.getConstructor(BlockPositionClass, Double.class, Double.class, Double.class);
        return con.newInstance(location.getX(), location.getY(), location.getZ());
    }

    public static Object getIBlockData(XMaterial material) {
        IReflection.MethodAccessor getBlockData = IReflection.getMethod(BlockClass, IBlockDataClass, new Class[0]);
        if (Version.atLeast(13.0)) {
            Class<?> craftMagicNumbers = IReflection.getClass(IReflection.ServerPacket.CRAFTBUKKIT_UTILS, "CraftMagicNumbers");
            IReflection.MethodAccessor getBlock = IReflection.getMethod(craftMagicNumbers, BlockClass, new Class[]{Material.class});
            Object block = getBlock.invoke(null, material.parseMaterial());
            return getBlockData.invoke(block, new Object[0]);
        }
        if (material.name().contains("_SIGN")) {
            Class<?> blocks = IReflection.getClass(IReflection.ServerPacket.PACKETS, "Blocks");
            String name = Version.since(13.0, "STANDING_SIGN", "SIGN");
            Object standingSign = IReflection.getField(blocks, name).get(null);
            return getBlockData.invoke(standingSign, new Object[0]);
        }
        IReflection.MethodAccessor getByCombinedId = IReflection.getMethod(BlockClass, "getByCombinedId", IBlockDataClass, new Class[]{Integer.TYPE});
        return getByCombinedId.invoke(null, PacketUtils.getCombinedId(material.getId(), (byte)0));
    }

    public static int getCombinedId(int id, byte data) {
        return id + (data << 12);
    }

    public static Object emptyHolderLookupProvider() {
        IReflection.MethodAccessor create = IReflection.getMethod(HolderLookupProvider, HolderLookupProvider, new Class[]{Stream.class});
        return create.invoke(null, Stream.empty());
    }

    static {
        getEntityId = PacketUtils.getMethod(CraftPlayerClass, "getEntityId", Integer.TYPE, new Class[0]);
        getTileEntity = PacketUtils.getMethod(WorldClass, null, TileEntityClass, new Class[]{BlockPositionClass});
        getId = IReflection.getNonStaticField(EntityClass, Integer.TYPE, 0);
        playerConnection = IReflection.getField(EntityPlayerClass, Version.since(17.0, "playerConnection", "b"), 20.0, PlayerConnectionClass, 0, true);
        HolderLookupProvider = IReflection.wrap(Version.atLeast(20.5), () -> PacketUtils.getClass(IReflection.ServerPacket.CORE, "HolderLookup$Provider"));
        if (Version.atLeast(20.2)) {
            Class<?> packetSendListenerClass = IReflection.getClass(IReflection.ServerPacket.NETWORK, "PacketSendListener");
            sendPacket = IReflection.getMethod(PlayerConnectionClass, (Class)null, new Class[]{PacketClass, packetSendListenerClass});
        } else {
            sendPacket = PacketUtils.getMethod(PlayerConnectionClass, Version.since(18.0, "sendPacket", "a"), new Class[]{PacketClass});
        }
        PacketUtils.getChatMessage("Test");
        PacketUtils.getIChatBaseComponent("Test");
        PacketUtils.getMinecraftServer();
        PacketUtils.getCraftServer();
        PacketUtils.getWorldServer();
    }

    public static class EntityPackets {
        public static void spawnEntity(Object entity, int entityTypeId, Player ... players) {
            EntityPackets.spawnEntity(entity, entityTypeId, 0, players);
        }

        public static void spawnEntity(Object entity, int entityTypeId, int entityThrowerId, Player ... players) {
            Object packet = IReflection.getConstructor(PacketPlayOutSpawnEntityClass, EntityClass, Integer.TYPE, Integer.TYPE).newInstance(entity, entityTypeId, entityThrowerId);
            PacketUtils.sendPacket(packet, players);
        }

        public static void destroyEntity(Object entity, Player ... players) {
            Object packet = IReflection.getConstructor(PacketPlayOutEntityDestroyClass, int[].class).newInstance(new Object[]{new int[]{EntityPackets.getId(entity)}});
            PacketUtils.sendPacket(packet, players);
        }

        public static Object getTeleportPacket(Object entity, Location location) {
            IReflection.MethodAccessor getId = IReflection.getMethod(EntityPlayerClass, "getId", Integer.TYPE, null);
            int id = (Integer)getId.invoke(entity, new Object[0]);
            Object packet = IReflection.getConstructor(PacketPlayOutEntityTeleportClass, new Class[0]).newInstance(new Object[0]);
            IReflection.FieldAccessor a = IReflection.getField(PacketPlayOutEntityTeleportClass, "a");
            IReflection.FieldAccessor b = IReflection.getField(PacketPlayOutEntityTeleportClass, "b");
            IReflection.FieldAccessor c = IReflection.getField(PacketPlayOutEntityTeleportClass, "c");
            IReflection.FieldAccessor d = IReflection.getField(PacketPlayOutEntityTeleportClass, "d");
            IReflection.FieldAccessor e = IReflection.getField(PacketPlayOutEntityTeleportClass, "e");
            IReflection.FieldAccessor f = IReflection.getField(PacketPlayOutEntityTeleportClass, "f");
            IReflection.FieldAccessor g = IReflection.getField(PacketPlayOutEntityTeleportClass, "g");
            a.set(packet, id);
            if (Version.get().isBiggerThan(Version.v1_8)) {
                b.set(packet, location.getX());
                c.set(packet, location.getY());
                d.set(packet, location.getZ());
            } else {
                b.set(packet, EntityPackets.toFixedPointNumber(location.getX()));
                c.set(packet, EntityPackets.toFixedPointNumber(location.getY()));
                d.set(packet, EntityPackets.toFixedPointNumber(location.getZ()));
            }
            e.set(packet, EntityPackets.toAngle(location.getYaw()));
            f.set(packet, EntityPackets.toAngle(location.getPitch()));
            g.set(packet, false);
            return packet;
        }

        public static int getId(Object entity) {
            return getId.get(entity);
        }

        public static Packet getVelocityPacket(Object entity, Vector vector) {
            int id = EntityPackets.getId(entity);
            Packet packet = new Packet(PacketPlayOutEntityVelocityClass);
            packet.initialize(id, vector.getX(), vector.getY(), vector.getZ());
            return packet;
        }

        public static Packet getPassengerPacket(Object vehicle, Object passenger) {
            Packet packet = new Packet(PacketPlayOutAttachEntityClass);
            if (Version.get().isBiggerThan(Version.v1_8)) {
                packet.initialize(new Class[]{EntityClass, EntityClass}, vehicle, passenger);
            } else {
                packet.initialize(new Class[]{Integer.TYPE, EntityClass, EntityClass}, new Object[]{0, passenger, vehicle});
            }
            return packet;
        }

        public static Packet getEjectPacket(Object vehicle) {
            Packet packet = new Packet(PacketPlayOutAttachEntityClass);
            if (Version.get().isBiggerThan(Version.v1_8)) {
                packet.initialize(new Class[]{EntityClass, EntityClass}, new Object[]{vehicle, null});
                return packet;
            }
            packet.initialize(new Class[]{Integer.TYPE, EntityClass, EntityClass}, new Object[]{0, vehicle, null});
            return packet;
        }

        private static int toFixedPointNumber(double value) {
            return (int)Math.floor(value * 32.0);
        }

        private static byte toAngle(float value) {
            return (byte)(value * 256.0f / 360.0f);
        }
    }

    public static class Blocks {
        public static Object findByName(String name) {
            IReflection.FieldAccessor field = IReflection.getField(BlocksClass, name);
            return field.get(null);
        }
    }
}

