/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.reflections;

import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.Bukkit;

public class IReflection {
    public static <V> V wrap(boolean useSupplier, Supplier<V> s) {
        if (useSupplier) {
            return s.get();
        }
        return null;
    }

    public static void setValue(@NotNull Object instance, @NotNull String fieldName, @NotNull Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        FieldAccessor field = IReflection.getField(instance.getClass(), fieldName);
        field.set(instance, value);
    }

    @NotNull
    public static Class<?> getSaveClass(@NotNull ServerPacket packet, @NotNull String name) throws ClassNotFoundException {
        return IReflection.getSaveClass(packet.toString(), name);
    }

    @NotNull
    public static Class<?> getSaveClass(@NotNull String packet, @NotNull String name) throws ClassNotFoundException {
        return Class.forName(packet + name);
    }

    @NotNull
    public static Class<?> getClass(@NotNull String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static Class<?> getClass(@NotNull ServerPacket packet, @NotNull String name) {
        return IReflection.getClass(packet.toString(), name);
    }

    @NotNull
    public static Class<?> getClass(@NotNull String path, @NotNull String name) {
        try {
            return Class.forName(path + name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static ConstructorAccessor getConstructor(@NotNull Class<?> clazz, Class<?> ... parameterTypes) {
        Class<?>[] p = DataType.convertToPrimitive(parameterTypes);
        for (final Constructor<?> c : clazz.getDeclaredConstructors()) {
            if (!DataType.equalsArray(DataType.convertToPrimitive(c.getParameterTypes()), p)) continue;
            c.setAccessible(true);
            return new ConstructorAccessor(){

                @Override
                public Object newInstance(Object ... args) {
                    try {
                        return c.newInstance(args);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Cannot use reflection.", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("An internal error occured.", e.getCause());
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException("Cannot instantiate object.", e);
                    }
                }

                @Override
                public Constructor<?> getConstructor() {
                    return c;
                }
            };
        }
        if (clazz.getSuperclass() != null) {
            return IReflection.getConstructor(clazz.getSuperclass(), parameterTypes);
        }
        return null;
    }

    @NotNull
    public static @NotNull ConstructorAccessor @NotNull [] getConstructors(@NotNull Class<?> clazz) {
        ArrayList<2> cons = new ArrayList<2>();
        for (final Constructor<?> c : clazz.getDeclaredConstructors()) {
            c.setAccessible(true);
            cons.add(new ConstructorAccessor(){

                @Override
                public Object newInstance(Object ... args) {
                    try {
                        return c.newInstance(args);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Cannot use reflection.", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("An internal error occured.", e.getCause());
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException("Cannot instantiate object.", e);
                    }
                }

                @Override
                public Constructor<?> getConstructor() {
                    return c;
                }
            });
        }
        return cons.toArray(new ConstructorAccessor[0]);
    }

    @NotNull
    public static MethodAccessor getMethod(Class<?> target, Class<?> ... parameterTypes) {
        return IReflection.getMethod(target, null, null, parameterTypes);
    }

    @NotNull
    public static MethodAccessor getMethod(Class<?> target, @Nullable Class<?> returnType, Class<?> ... parameterTypes) {
        return IReflection.getMethod(target, null, returnType, parameterTypes);
    }

    @NotNull
    public static MethodAccessor getMethod(Class<?> target, @Nullable String methodName, Class<?> ... parameterTypes) {
        return IReflection.getMethod(target, methodName, null, parameterTypes);
    }

    @NotNull
    public static MethodAccessor getMethod(Class<?> target, @Nullable String methodName, @Nullable Class<?> returnType, Class<?> ... parameterTypes) {
        if (target == null) {
            throw new IllegalArgumentException("Target class cannot be null.");
        }
        Class<?>[] primitiveParameter = DataType.convertToPrimitive(parameterTypes);
        for (final Method method : target.getDeclaredMethods()) {
            if (methodName != null && !method.getName().equals(methodName) || returnType != null && !method.getReturnType().equals(returnType) || (primitiveParameter.length != 0 || method.getParameterTypes().length != 0) && !DataType.equalsArray(DataType.convertToPrimitive(method.getParameterTypes()), primitiveParameter)) continue;
            method.setAccessible(true);
            return new MethodAccessor(){

                @Override
                public Object invoke(Object target, Object ... args) {
                    try {
                        return method.invoke(target, args);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Cannot use reflection.", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("An internal error occured.", e.getCause());
                    }
                }

                @Override
                public Method getMethod() {
                    return method;
                }
            };
        }
        if (target.getSuperclass() != null) {
            return IReflection.getMethod(target.getSuperclass(), methodName, returnType, parameterTypes);
        }
        throw new IllegalStateException(String.format("Unable to find method %s (%s).", methodName, Arrays.toString(parameterTypes)));
    }

    public static MethodAccessor getSaveMethod(@NotNull Class<?> target, @Nullable String methodName, @Nullable Class<?> returnType, Class<?> ... parameterTypes) throws IllegalStateException {
        Class<?>[] primitiveParameter = DataType.convertToPrimitive(parameterTypes);
        for (final Method method : target.getDeclaredMethods()) {
            if (methodName != null && !method.getName().equals(methodName) || returnType != null && !method.getReturnType().equals(returnType) || primitiveParameter.length != 0 && !DataType.equalsArray(DataType.convertToPrimitive(method.getParameterTypes()), primitiveParameter)) continue;
            method.setAccessible(true);
            return new MethodAccessor(){

                @Override
                public Object invoke(Object target, Object ... args) {
                    try {
                        return method.invoke(target, args);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Cannot use reflection.", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("An internal error occured.", e.getCause());
                    }
                }

                @Override
                public Method getMethod() {
                    return method;
                }
            };
        }
        if (target.getSuperclass() != null) {
            return IReflection.getSaveMethod(target.getSuperclass(), methodName, returnType, parameterTypes);
        }
        return null;
    }

    public static <T> FieldAccessor<T> getField(Class<?> target, String fieldName) {
        return IReflection.getField(target, fieldName, null, 0, false);
    }

    public static <T> FieldAccessor<T> getField(Class<?> target, String fieldName, double since, Class<T> fieldType, int index, boolean ignoreStatic) {
        if (Version.atLeast(since)) {
            return IReflection.getField(target, null, fieldType, index, ignoreStatic);
        }
        return IReflection.getField(target, fieldName, null, 0, ignoreStatic);
    }

    public static <T> FieldAccessor<T> getField(Class<?> target, Class<T> fieldType, int index) {
        return IReflection.getField(target, null, fieldType, index, false);
    }

    public static <T> FieldAccessor<T> getNonStaticField(Class<?> target, String fieldName) {
        return IReflection.getField(target, fieldName, null, 0, true);
    }

    public static <T> FieldAccessor<T> getNonStaticField(Class<?> target, Class<T> fieldType, int index) {
        return IReflection.getField(target, null, fieldType, index, true);
    }

    private static <T> FieldAccessor<T> getField(Class<?> target, String fieldName, Class<T> fieldType, int index, boolean ignoreStatic) {
        for (final Field field : target.getDeclaredFields()) {
            if (ignoreStatic && Modifier.isStatic(field.getModifiers()) || fieldName != null && !fieldName.equals(field.getName()) || fieldType != null && (!fieldType.isAssignableFrom(field.getType()) || index-- > 0)) continue;
            field.setAccessible(true);
            return new FieldAccessor<T>(){

                @Override
                public T get(Object target) {
                    try {
                        return field.get(target);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Cannot use reflection.", e);
                    }
                }

                @Override
                public void set(Object target, Object value) {
                    try {
                        field.set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Cannot use reflection.", e);
                    }
                }

                @Override
                public Field getField() {
                    return field;
                }
            };
        }
        if (target.getSuperclass() != null) {
            return IReflection.getField(target.getSuperclass(), fieldName, fieldType, index, ignoreStatic);
        }
        throw new IllegalStateException(String.format("Unable to find field %s (%s).", fieldName, fieldType));
    }

    public static interface FieldAccessor<T> {
        public T get(Object var1);

        public void set(Object var1, Object var2);

        public Field getField();
    }

    public static interface MethodAccessor {
        public Object invoke(Object var1, Object ... var2);

        public Method getMethod();
    }

    public static interface ConstructorAccessor {
        public Object newInstance(Object ... var1);

        public Constructor<?> getConstructor();
    }

    public static enum ServerPacket {
        MINECRAFT_PACKAGE("net.minecraft.server." + ServerPacket.minecraftVersion()),
        MOJANG_AUTHLIB("com.mojang.authlib"),
        CRAFTBUKKIT_PACKAGE(Bukkit.getServer().getClass().getPackage().getName()),
        CRAFTBUKKIT_UTILS(ServerPacket.CRAFTBUKKIT_PACKAGE.path + ".util"),
        CRAFTBUKKIT_BLOCK(ServerPacket.CRAFTBUKKIT_PACKAGE.path + ".block"),
        BUKKIT_PACKET("org.bukkit"),
        PROTOCOL(17, "net.minecraft.network.protocol"),
        PACKETS(17, "net.minecraft.network.protocol.game"),
        CHAT(17, "net.minecraft.network.chat"),
        NETWORK(17, "net.minecraft.network"),
        NBT(17, "net.minecraft.nbt"),
        CORE(17, "net.minecraft.core"),
        COMPONENT(17, "net.minecraft.core.component"),
        PARTICLES(17, "net.minecraft.core.particles"),
        SERVER_LEVEL(17, "net.minecraft.server.level"),
        WORLD_LEVEL(17, "net.minecraft.world.level"),
        WORLD_ITEM(17, "net.minecraft.world.item"),
        INVENTORY(17, "net.minecraft.world.inventory"),
        BLOCK(17, "net.minecraft.world.level.block"),
        BLOCK_ENTITY(17, "net.minecraft.world.level.block.entity"),
        COMMANDS(17, "net.minecraft.commands");

        private final String path;

        private ServerPacket(String path) {
            this.path = path;
        }

        private ServerPacket(int version, String path) {
            this.path = Version.before(version) ? "net.minecraft.server." + ServerPacket.minecraftVersion() : path;
        }

        @NotNull
        private static String minecraftVersion() {
            String name = Bukkit.getServer().getClass().getPackage().getName();
            if (name.length() > 23) {
                return name.substring(23);
            }
            return "";
        }

        public String toString() {
            return this.path + ".";
        }

        public static String MINECRAFT_PACKAGE(String path) {
            if (Version.before(17.0)) {
                return MINECRAFT_PACKAGE.toString();
            }
            return path + ".";
        }
    }

    public static enum DataType {
        BYTE(Byte.TYPE, Byte.class),
        SHORT(Short.TYPE, Short.class),
        INTEGER(Integer.TYPE, Integer.class),
        LONG(Long.TYPE, Long.class),
        CHARACTER(Character.TYPE, Character.class),
        FLOAT(Float.TYPE, Float.class),
        DOUBLE(Double.TYPE, Double.class),
        BOOLEAN(Boolean.TYPE, Boolean.class);

        private static final Map<Class<?>, DataType> CLASS_MAP;
        private final Class<?> primitive;
        private final Class<?> reference;

        private DataType(Class<?> primitive, Class<?> reference) {
            this.primitive = primitive;
            this.reference = reference;
        }

        public static DataType fromClass(Class<?> c) {
            return CLASS_MAP.get(c);
        }

        public static Class<?> getPrimitive(Class<?> c) {
            DataType t = DataType.fromClass(c);
            return t == null ? c : t.getPrimitive();
        }

        public static Class<?> getReference(Class<?> c) {
            DataType t = DataType.fromClass(c);
            return t == null ? c : t.getReference();
        }

        public static Class<?>[] convertToPrimitive(@NotNull Class<?> @Nullable [] classes) {
            int length = classes == null ? 0 : classes.length;
            Class[] types = new Class[length];
            for (int i = 0; i < length; ++i) {
                types[i] = DataType.getPrimitive(classes[i]);
            }
            return types;
        }

        public static boolean equalsArray(Class<?>[] a1, Class<?>[] a2) {
            if (a1 == null || a2 == null || a1.length != a2.length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i].equals(a2[i]) || a1[i].isAssignableFrom(a2[i])) continue;
                return false;
            }
            return true;
        }

        public Class<?> getPrimitive() {
            return this.primitive;
        }

        public Class<?> getReference() {
            return this.reference;
        }

        static {
            CLASS_MAP = new HashMap();
            for (DataType t : DataType.values()) {
                CLASS_MAP.put(t.primitive, t);
                CLASS_MAP.put(t.reference, t);
            }
        }
    }
}

