/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.listeners;

import de.codingair.tradesystem.lib.codingapi.nms.NmsLoader;
import de.codingair.tradesystem.lib.codingapi.player.data.PacketReader;
import de.codingair.tradesystem.lib.codingapi.server.AsyncCatcher;
import de.codingair.tradesystem.lib.codingapi.server.events.PlayerPickItemEvent;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class PickItemListener
implements Listener {
    private static final Class<?> PACKET_CLASS = IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayInSetCreativeSlot");
    private static final IReflection.FieldAccessor<?> slot;
    private static final IReflection.FieldAccessor<?> item;
    private final JavaPlugin plugin;

    @NmsLoader
    private PickItemListener() {
        this(null);
    }

    public PickItemListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private void call(Player player, int slot, ItemStack item) {
        boolean correct;
        if (item.getType() == Material.AIR) {
            return;
        }
        Block b = player.getTargetBlock((Set)new HashSet<Material>(){
            {
                this.add(Material.AIR);
            }
        }, 10);
        boolean bl = correct = b.getType() == item.getType();
        if (!correct) {
            for (ItemStack drop : b.getDrops()) {
                if (drop.getType() != item.getType()) continue;
                correct = true;
                break;
            }
        }
        if (correct) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerPickItemEvent(player, slot, player.getItemInHand(), b));
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        final Player p = e.getPlayer();
        new PacketReader(p, "PickItemListener", this.plugin){

            @Override
            public boolean readPacket(Object packet) {
                if (PACKET_CLASS == packet.getClass()) {
                    int slot;
                    Object slotId = slot.get(packet);
                    if (slotId instanceof Integer) {
                        slot = (Integer)slotId;
                    } else if (slotId instanceof Short) {
                        slot = ((Short)slotId).shortValue();
                    } else {
                        throw new IllegalStateException("Cannot cast '" + slotId + "' (" + slotId.getClass() + ")");
                    }
                    AsyncCatcher.runSync(PickItemListener.this.plugin, () -> PickItemListener.this.call(p, slot, PacketUtils.getItemStack(item.get(packet))));
                }
                return false;
            }

            @Override
            public boolean writePacket(Object packet) {
                return false;
            }
        }.inject();
    }

    static {
        if (Version.atLeast(20.5)) {
            slot = IReflection.getField(PACKET_CLASS, Short.TYPE, 0);
            item = IReflection.getField(PACKET_CLASS, PacketUtils.ItemStackClass, 0);
        } else {
            slot = Version.get().isBiggerThan(16.0) ? IReflection.getField(PACKET_CLASS, "a") : IReflection.getField(PACKET_CLASS, "slot");
            item = IReflection.getField(PACKET_CLASS, "b");
        }
    }
}

