/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.commands.builder;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.CommandBuilder;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.brigadier.CommandListenerWrapper;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.bukkit.Bukkit;

public class CommandWrapper
implements Predicate<Object>,
Command<Object>,
SuggestionProvider<Object> {
    private final CommandListenerWrapper wrapper;
    private final CommandBuilder builder;

    private CommandWrapper(CommandBuilder builder) {
        this.builder = builder;
        this.wrapper = new CommandListenerWrapper(builder);
    }

    public static CommandWrapper register(CommandBuilder builder) {
        return new CommandWrapper(builder).register();
    }

    private CommandWrapper register() {
        this.registerCommand(this.builder.getName());
        for (String alias : this.builder.getMain().getAliases()) {
            this.registerCommand(alias);
        }
        return this;
    }

    public void unregister() {
        this.unregisterCommand(this.builder.getName());
        for (String alias : this.builder.getMain().getAliases()) {
            this.unregisterCommand(alias);
        }
    }

    private void registerCommand(String name) {
        CommandDispatcher<Object> dispatcher = CommandWrapper.dispatcher();
        LiteralArgumentBuilder l = LiteralArgumentBuilder.literal((String)name);
        ((LiteralArgumentBuilder)l.requires((Predicate)this)).executes((Command)this);
        RequiredArgumentBuilder r = RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString());
        l.then(r.suggests((SuggestionProvider)this).executes((Command)this));
        dispatcher.register(l);
    }

    @Override
    public boolean test(Object context) {
        return true;
    }

    public int run(CommandContext<Object> context) {
        return Bukkit.getServer().dispatchCommand(this.wrapper.getBukkitSender(context.getSource()), context.getInput()) ? 1 : 0;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<Object> context, SuggestionsBuilder builder) {
        List<String> results = this.wrapper.tabComplete(context, builder.getInput());
        builder = builder.createOffset(builder.getInput().lastIndexOf(32) + 1);
        for (String s : results) {
            builder.suggest(s);
        }
        return builder.buildFuture();
    }

    private void unregisterCommand(String name) {
        RootCommandNode root = CommandWrapper.dispatcher().getRoot();
        IReflection.FieldAccessor children = IReflection.getField(CommandNode.class, "children");
        ((Map)children.get(root)).remove(name);
        IReflection.FieldAccessor literals = IReflection.getField(CommandNode.class, "literals");
        ((Map)literals.get(root)).remove(name);
        IReflection.FieldAccessor arguments = IReflection.getField(CommandNode.class, "arguments");
        ((Map)arguments.get(root)).remove(name);
    }

    public static CommandDispatcher<Object> dispatcher() {
        Object commandDispatcher;
        IReflection.MethodAccessor getCommandDispatcher;
        Class<?> commandDispatcherClass = IReflection.getClass(IReflection.ServerPacket.COMMANDS, "CommandDispatcher");
        if (Version.atLeast(19.3)) {
            getCommandDispatcher = IReflection.getMethod(PacketUtils.MinecraftServerClass, commandDispatcherClass, new Class[0]);
            commandDispatcher = getCommandDispatcher.invoke(PacketUtils.getMinecraftServer(), new Object[0]);
        } else if (Version.atLeast(18.0)) {
            IReflection.FieldAccessor vanillaCommandDispatcher = IReflection.getField(PacketUtils.MinecraftServerClass, "vanillaCommandDispatcher");
            commandDispatcher = vanillaCommandDispatcher.get(PacketUtils.getMinecraftServer());
        } else {
            getCommandDispatcher = IReflection.getMethod(PacketUtils.MinecraftServerClass, "getCommandDispatcher", new Class[0]);
            commandDispatcher = getCommandDispatcher.invoke(PacketUtils.getMinecraftServer(), new Object[0]);
        }
        Class<?> commandDispatcherBrigadierClass = IReflection.getClass("com.mojang.brigadier.CommandDispatcher");
        IReflection.MethodAccessor a = IReflection.getMethod(commandDispatcherClass, commandDispatcherBrigadierClass, new Class[0]);
        return (CommandDispatcher)a.invoke(commandDispatcher, new Object[0]);
    }

    protected static class Backup {
        protected CommandNode<?>[] commands;
        protected String label;

        public Backup(CommandNode<?>[] commands, String label) {
            this.commands = commands;
            this.label = label;
        }
    }
}

