/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.commands.builder;

import de.codingair.tradesystem.lib.codingapi.server.commands.builder.BaseComponent;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.special.SpecialCommandComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;

public abstract class CommandComponent {
    protected CommandComponent parent;
    protected final List<CommandComponent> children = new ArrayList<CommandComponent>();
    protected final String argument;
    protected final String permission;
    protected Boolean onlyPlayers = null;
    protected Boolean onlyConsole = null;

    public CommandComponent(String argument) {
        this(argument, null);
    }

    public CommandComponent(String argument, String permission) {
        this.argument = argument;
        this.permission = permission;
    }

    public boolean useInTabCompleter(CommandSender sender, String label, String[] args) {
        return true;
    }

    public boolean matchTabComplete(CommandSender sender, String suggestion, String argument) {
        return false;
    }

    public abstract boolean runCommand(CommandSender var1, String var2, String[] var3);

    private void setParent(CommandComponent parent) {
        this.parent = parent;
    }

    public CommandComponent getParent() {
        return this.parent;
    }

    public BaseComponent getBase() {
        if (this instanceof BaseComponent) {
            return (BaseComponent)this;
        }
        if (this.parent instanceof BaseComponent) {
            return (BaseComponent)this.parent;
        }
        return this.parent == null ? null : this.parent.getBase();
    }

    public List<CommandComponent> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public CommandComponent addChild(CommandComponent child) {
        if (child instanceof SpecialCommandComponent && this.getChild(null) != null) {
            throw new IllegalStateException("There is already a SpecialCommandComponent!");
        }
        child.setParent(this);
        this.children.add(child);
        return this;
    }

    public Object buildArgument() {
        return null;
    }

    public CommandComponent getChild(String arg) {
        ArrayList<CommandComponent> children = new ArrayList<CommandComponent>(this.children);
        CommandComponent child = null;
        CommandComponent special = null;
        for (CommandComponent c : children) {
            if (c instanceof SpecialCommandComponent) {
                special = c;
                continue;
            }
            if (arg == null || arg.isEmpty() || !c.getArgument().equalsIgnoreCase(arg)) continue;
            child = c;
            break;
        }
        children.clear();
        return child == null ? special : child;
    }

    public boolean removeChild(CommandComponent child) {
        if (this.children.remove(child)) {
            child.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeChild(String arg) {
        CommandComponent cc = this.getChild(arg);
        if (cc == null) {
            return false;
        }
        return this.removeChild(cc);
    }

    public String getArgument() {
        return this.argument;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean hasPermission(CommandSender sender) {
        return !(this.permission != null && !sender.hasPermission(this.permission) || this.parent != null && !this.parent.hasPermission(sender));
    }

    public List<String> getArgs() {
        ArrayList<String> s = new ArrayList<String>();
        this.addArgs(s);
        return s;
    }

    private void addArgs(List<String> s) {
        if (this.parent == null) {
            s.add(this.argument);
        } else {
            this.parent.addArgs(s);
            s.add(this.argument);
        }
    }

    public boolean isOnlyPlayers() {
        if (this.onlyPlayers != null) {
            return this.onlyPlayers;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.isOnlyPlayers();
    }

    public CommandComponent setOnlyPlayers(boolean onlyPlayers) {
        this.onlyPlayers = onlyPlayers;
        return this;
    }

    public boolean isOnlyConsole() {
        if (this.onlyConsole != null) {
            return this.onlyConsole;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.isOnlyConsole();
    }

    public CommandComponent setOnlyConsole(boolean onlyConsole) {
        this.onlyConsole = onlyConsole;
        return this;
    }
}

