/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.commands.builder;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.BaseComponent;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.CommandComponent;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.CustomCommand;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.special.MultiCommandComponent;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.special.NaturalCommandComponent;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandBuilder
implements CommandExecutor,
TabCompleter,
Removable {
    private static SimpleCommandMap simpleCommandMap = null;
    private static Map<String, Command> knownCommands = null;
    private static Class<?> wrapper = null;
    private static IReflection.MethodAccessor register = null;
    private static IReflection.MethodAccessor unregister = null;
    private final HashMap<String, Command> fallback = new HashMap();
    private final UUID uniqueId = UUID.randomUUID();
    private final JavaPlugin plugin;
    private final String name;
    private final String description;
    private final String[] importantAliases;
    private final List<String> aliases;
    private final BaseComponent baseComponent;
    private final boolean tabCompleter;
    private Object wrapperInstance = null;
    private PluginCommand main;
    private TabCompleter ownTabCompleter = null;
    private boolean mergeSpaceArguments = true;

    public CommandBuilder(JavaPlugin plugin, String name, BaseComponent baseComponent, boolean tabCompleter) {
        this(plugin, name, null, baseComponent, tabCompleter, (String[])null);
    }

    public CommandBuilder(JavaPlugin plugin, String name, String description, BaseComponent baseComponent, boolean tabCompleter, String ... aliases) {
        this(plugin, name, description, baseComponent, tabCompleter, (String[])null, aliases);
    }

    public CommandBuilder(JavaPlugin plugin, String name, String description, BaseComponent baseComponent, boolean tabCompleter, String[] importantAliases, String ... aliases) {
        this.plugin = plugin;
        this.name = name.toLowerCase(Locale.ENGLISH).trim();
        this.description = description;
        this.baseComponent = baseComponent;
        this.baseComponent.setBuilder(this);
        this.tabCompleter = tabCompleter;
        this.aliases = new ArrayList<String>();
        if (importantAliases == null) {
            this.importantAliases = new String[0];
        } else {
            this.importantAliases = new String[importantAliases.length];
            for (int i = 0; i < importantAliases.length; ++i) {
                String s;
                this.importantAliases[i] = s = importantAliases[i].toLowerCase(Locale.ENGLISH).trim();
                this.aliases.add(s);
            }
        }
        if (aliases != null) {
            for (String alias : aliases) {
                this.aliases.add(alias.toLowerCase(Locale.ENGLISH).trim());
            }
        }
        if (Version.get().isBiggerThan(12.0) && wrapper == null) {
            String path = CommandBuilder.class.getName();
            path = path.substring(0, path.lastIndexOf("."));
            try {
                wrapper = Class.forName(path + ".CommandWrapper");
                register = IReflection.getMethod(wrapper, "register", wrapper, new Class[]{CommandBuilder.class});
                unregister = IReflection.getMethod(wrapper, "unregister", new Class[0]);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Command getCommand(String name) {
        if (name.startsWith("/")) {
            return CommandBuilder.getKnownCommands().get(name.toLowerCase().substring(1));
        }
        return CommandBuilder.getKnownCommands().get(name.toLowerCase());
    }

    public static boolean exists(String name) {
        return CommandBuilder.getCommand(name) != null;
    }

    public static Map<String, Command> getKnownCommands() {
        if (knownCommands == null) {
            try {
                Field knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommands.setAccessible(true);
                CommandBuilder.knownCommands = (Map)knownCommands.get(CommandBuilder.simpleCommandMap());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return new HashMap<String, Command>();
            }
        }
        return knownCommands;
    }

    public static SimpleCommandMap simpleCommandMap() {
        if (simpleCommandMap == null) {
            SimplePluginManager spm = (SimplePluginManager)Bukkit.getPluginManager();
            try {
                Field commandMap = SimplePluginManager.class.getDeclaredField("commandMap");
                Field knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
                commandMap.setAccessible(true);
                knownCommands.setAccessible(true);
                simpleCommandMap = (SimpleCommandMap)commandMap.get(spm);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return simpleCommandMap;
    }

    @Override
    public void destroy() {
        this.unregister();
    }

    public void register() {
        if (this.main != null) {
            return;
        }
        API.addRemovable(this);
        Command c = CommandBuilder.getKnownCommands().remove(this.name);
        if (c != null) {
            this.fallback.put(this.name, c);
        }
        for (String importantAlias : this.importantAliases) {
            c = CommandBuilder.getKnownCommands().remove(importantAlias);
            if (c == null) continue;
            this.fallback.put(importantAlias, c);
        }
        this.main = new CustomCommand((Plugin)this.plugin, this.name, this.description).invoke();
        this.main.setTabCompleter((TabCompleter)(this.tabCompleter ? this : null));
        this.main.setExecutor((CommandExecutor)this);
        this.main.setAliases(this.aliases);
        this.main.setPermission(null);
        this.main.setLabel(this.name);
        CommandBuilder.simpleCommandMap().register(this.plugin.getDescription().getName(), (Command)this.main);
        if (Version.get().isBiggerThan(12.0)) {
            this.wrapperInstance = register.invoke(null, this);
        }
    }

    public void unregister() {
        if (this.main == null) {
            return;
        }
        if (Version.get().isBiggerThan(12.0)) {
            unregister.invoke(this.wrapperInstance, new Object[0]);
        }
        this.unregister(this.name);
        for (String alias : this.aliases) {
            this.unregister(alias);
        }
        this.fallback.forEach((key, command) -> CommandBuilder.getKnownCommands().put((String)key, (Command)command));
        this.fallback.clear();
        this.main = null;
        API.removeRemovable(this);
    }

    private void unregister(String label) {
        label = label.toLowerCase(Locale.ENGLISH).trim();
        Map<String, Command> commands = CommandBuilder.getKnownCommands();
        Command c = commands.get(label);
        if (c instanceof PluginCommand && ((PluginCommand)c).getPlugin().getName().equals(this.plugin.getName())) {
            commands.remove(label);
        }
        commands.remove(this.main.getPlugin().getName().toLowerCase(Locale.ENGLISH).trim() + ":" + label);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CommandComponent component;
        CommandComponent commandComponent = component = (args = this.repairArgs(args)).length == 1 && args[0].equals("/" + label) || this.baseComponent.getChildren().isEmpty() ? this.getBaseComponent() : this.getComponent(args);
        if (component == null) {
            if (this.baseComponent.isOnlyConsole() && sender instanceof Player) {
                this.baseComponent.onlyFor(false, sender, label, component);
                return true;
            }
            if (this.baseComponent.isOnlyPlayers() && !(sender instanceof Player)) {
                this.baseComponent.onlyFor(true, sender, label, component);
                return true;
            }
            if (this.baseComponent.hasPermission(sender)) {
                this.baseComponent.unknownSubCommand(sender, label, args);
                return true;
            }
            this.baseComponent.noPermission(sender, label, component);
            return true;
        }
        if (component.isOnlyConsole() && sender instanceof Player) {
            this.baseComponent.onlyFor(false, sender, label, component);
            return true;
        }
        if (component.isOnlyPlayers() && !(sender instanceof Player)) {
            this.baseComponent.onlyFor(true, sender, label, component);
            return true;
        }
        if (component.hasPermission(sender)) {
            return component.runCommand(sender, label, args);
        }
        this.baseComponent.noPermission(sender, label, component);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        args = this.repairArgs(args);
        ArrayList<String> sug = new ArrayList<String>();
        if (this.ownTabCompleter != null) {
            List apply = this.ownTabCompleter.onTabComplete(sender, command, label, args);
            if (apply != null) {
                for (String s : apply) {
                    if (s.contains(" ") && this.mergeSpaceArguments) {
                        s = "\"" + s + "\"";
                    }
                    sug.add(s);
                }
            }
            return sug;
        }
        HashMap<CommandComponent, ArrayList<String>> sub = new HashMap<CommandComponent, ArrayList<String>>();
        if (args.length == 0) {
            return sug;
        }
        String lastArg = args[args.length - 1];
        lastArg = lastArg == null ? "" : lastArg.toLowerCase();
        args[args.length - 1] = "";
        CommandComponent component = this.getComponent(args);
        if (component == null) {
            return sug;
        }
        args[args.length - 1] = lastArg;
        if (!(component instanceof NaturalCommandComponent)) {
            for (CommandComponent child : component.getChildren()) {
                if (!child.hasPermission(sender) || !child.useInTabCompleter(sender, label, args)) continue;
                ArrayList<String> suggestion = new ArrayList<String>();
                if (child instanceof MultiCommandComponent) {
                    ((MultiCommandComponent)child).addArguments(sender, args, suggestion);
                } else {
                    suggestion.add(child.getArgument());
                }
                if (suggestion.isEmpty()) continue;
                sub.put(child, suggestion);
            }
            for (CommandComponent c : sub.keySet()) {
                List suggestions = (List)sub.get(c);
                for (String subCommand : suggestions) {
                    if (subCommand.contains(" ") && this.mergeSpaceArguments) {
                        String modSC = "\"" + subCommand + "\"";
                        if (c.matchTabComplete(sender, modSC, lastArg)) {
                            sug.add(modSC);
                            continue;
                        }
                        if (lastArg.isEmpty() || modSC.toLowerCase().startsWith(lastArg)) {
                            sug.add(modSC);
                            continue;
                        }
                    }
                    if (c.matchTabComplete(sender, subCommand, lastArg)) {
                        if (subCommand.contains(" ") && this.mergeSpaceArguments) {
                            sug.add("\"" + subCommand + "\"");
                            continue;
                        }
                        sug.add(subCommand);
                        continue;
                    }
                    if (!lastArg.isEmpty() && !subCommand.toLowerCase().startsWith(lastArg)) continue;
                    if (subCommand.contains(" ") && this.mergeSpaceArguments) {
                        sug.add("\"" + subCommand + "\"");
                        continue;
                    }
                    sug.add(subCommand);
                }
                suggestions.clear();
            }
            sub.clear();
        } else {
            List<String> list;
            NaturalCommandComponent ncc = (NaturalCommandComponent)component;
            if (ncc.hasPermission(sender) && (list = ncc.onTabComplete(sender, command, label, args)) != null) {
                for (String s : list) {
                    if (s.contains(" ") && this.mergeSpaceArguments) {
                        s = "\"" + s + "\"";
                    }
                    sug.add(s);
                }
                list.clear();
            }
        }
        sug.sort(Comparator.naturalOrder());
        return sug;
    }

    @Override
    public Player getPlayer() {
        return null;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public CommandComponent getComponent(String ... args) {
        if (args.length == 0) {
            return this.baseComponent;
        }
        return this.getComponent(Arrays.asList(args));
    }

    public CommandComponent getComponent(List<String> s) {
        if (s.isEmpty()) {
            return this.baseComponent;
        }
        CommandComponent current = this.baseComponent;
        for (String value : s) {
            if (current == null || current instanceof NaturalCommandComponent) break;
            CommandComponent cc = current.getChild(value);
            if (value != null && value.isEmpty() && !(cc instanceof NaturalCommandComponent)) break;
            current = cc;
        }
        return current;
    }

    private String[] repairArgs(String[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        StringBuilder b = new StringBuilder();
        for (String s : args) {
            b.append(s);
            b.append(" ");
        }
        String s = b.toString();
        s = s.substring(0, s.length() - 1);
        boolean endingSpace = s.endsWith(" ");
        s = b.toString().trim().replaceAll(" {2,}?", "") + (endingSpace ? " " : "");
        if (s.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> nArgs = new ArrayList<String>();
        int parse = 0;
        char[] cA = s.toCharArray();
        block1: for (int i = 0; i < cA.length; ++i) {
            char c = cA[i];
            if (c == '\"') {
                for (int j = i + 1; j < cA.length; ++j) {
                    char c1 = cA[j];
                    if (c1 != '\"') continue;
                    if (parse < i) {
                        nArgs.add(s.substring(parse, i));
                        parse = i;
                    }
                    nArgs.add(s.substring(parse + 1, j));
                    i = parse = j + 1;
                    continue block1;
                }
                continue;
            }
            if (c != ' ') continue;
            nArgs.add(s.substring(parse, i));
            parse = i + 1;
        }
        if (parse < cA.length) {
            nArgs.add(s.substring(parse, cA.length));
        }
        if (cA[cA.length - 1] == ' ') {
            nArgs.add("");
        }
        return nArgs.toArray(new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public BaseComponent getBaseComponent() {
        return this.baseComponent;
    }

    public TabCompleter getOwnTabCompleter() {
        return this.ownTabCompleter;
    }

    public void setOwnTabCompleter(TabCompleter ownTabCompleter) {
        this.ownTabCompleter = ownTabCompleter;
    }

    public PluginCommand getMain() {
        return this.main;
    }

    public String[] getImportantAliases() {
        return this.importantAliases;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public boolean isMergeSpaceArguments() {
        return this.mergeSpaceArguments;
    }

    public void setMergeSpaceArguments(boolean mergeSpaceArguments) {
        this.mergeSpaceArguments = mergeSpaceArguments;
    }
}

