/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server.blocks;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.server.blocks.data.BlockData;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class ModernBlock {
    private final Block block;
    private Material material;
    private BlockData data;

    public ModernBlock(Block block) {
        this.block = block;
    }

    private void prepareBlock() {
        Bukkit.getScheduler().runTask((Plugin)API.getInstance().getMainPlugin(), () -> {
            if (this.data != null) {
                if (!Version.get().isBiggerThan(Version.v1_12)) {
                    this.data.setTypeAndDataTo(this.block, this.material, (Byte)this.data.getData(this.block), false);
                } else {
                    this.block.setType(this.material);
                    this.data.setDataTo(this.block, this.data.getData(this.block));
                }
            } else {
                this.block.setType(this.material);
            }
        });
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockData getData() {
        return this.data;
    }

    public ModernBlock setData(BlockData data) {
        this.data = data;
        this.prepareBlock();
        return this;
    }

    public ModernBlock setTypeAndData(Material material, BlockData data) {
        this.material = material;
        this.data = data;
        this.prepareBlock();
        return this;
    }

    public ModernBlock setType(Material material) {
        this.material = material;
        this.prepareBlock();
        return this;
    }
}

