/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server;

public enum FontInfo {
    A('A', 26.0),
    a('a', 19.0),
    B('B', 20.0),
    b('b', 19.0),
    C('C', 22.0),
    c('c', 17.0),
    D('D', 21.0),
    d('d', 19.0),
    E('E', 20.0),
    e('e', 18.0),
    F('F', 20.0),
    f('f', 13.0),
    G('G', 22.0),
    g('g', 18.0),
    H('H', 23.0),
    h('h', 17.0),
    I('I', 11.0),
    i('i', 5.0),
    J('J', 17.0),
    j('j', 11.0),
    K('K', 19.0),
    k('k', 17.0),
    L('L', 19.0),
    l('l', 5.0),
    M('M', 28.0),
    m('m', 25.0),
    N('N', 22.0),
    n('n', 17.0),
    O('O', 26.0),
    o('o', 18.0),
    P('P', 18.0),
    p('p', 19.0),
    Q('Q', 27.0),
    q('q', 20.0),
    R('R', 18.0),
    r('r', 14.0),
    S('S', 20.0),
    s('s', 16.0),
    T('T', 23.0),
    t('t', 11.0),
    U('U', 23.0),
    u('u', 17.0),
    V('V', 23.0),
    v('v', 18.0),
    W('W', 30.0),
    w('w', 26.0),
    X('X', 26.0),
    x('x', 19.0),
    Y('Y', 25.0),
    y('y', 17.0),
    Z('Z', 25.0),
    z('z', 18.0),
    NUM_1('1', 13.0),
    NUM_2('2', 20.0),
    NUM_3('3', 19.0),
    NUM_4('4', 22.0),
    NUM_5('5', 20.0),
    NUM_6('6', 21.0),
    NUM_7('7', 22.0),
    NUM_8('8', 20.0),
    NUM_9('9', 21.0),
    NUM_0('0', 22.0),
    EXCLAMATION_POINT('!', 7.0),
    AT_SYMBOL('@', 30.0),
    NUM_SIGN('#', 22.0),
    DOLLAR_SIGN('$', 25.0),
    PERCENT('%', 30.0),
    UP_ARROW('^', 13.0),
    AMPERSAND('&', 22.0),
    ASTERISK('*', 11.0),
    LEFT_PARENTHESIS('(', 11.0),
    RIGHT_PERENTHESIS(')', 11.0),
    MINUS('-', 15.0),
    UNDERSCORE('_', 26.0),
    PLUS_SIGN('+', 20.0),
    EQUALS_SIGN('=', 19.0),
    LEFT_CURL_BRACE('{', 16.0),
    RIGHT_CURL_BRACE('}', 16.0),
    LEFT_BRACKET('[', 11.0),
    RIGHT_BRACKET(']', 11.0),
    COLON(':', 5.0),
    SEMI_COLON(';', 7.0),
    DOUBLE_QUOTE('\"', 14.0),
    SINGLE_QUOTE('\'', 7.0),
    LEFT_ARROW('<', 14.0),
    RIGHT_ARROW('>', 14.0),
    QUESTION_MARK('?', 18.0),
    SLASH('/', 18.0),
    BACK_SLASH('\\', 17.0),
    LINE('|', 4.0),
    TILDE('~', 20.0),
    TICK('`', 6.0),
    PERIOD('.', 5.0),
    COMMA(',', 7.0),
    SPACE(' ', 8.0);

    public static final double CHAT_WIDTH = 1480.5;
    private static final double SPACE_BETWEEN_CHARS = 5.5;
    private final char character;
    private final double length;

    private FontInfo(char character, double length) {
        this.character = character;
        this.length = length;
    }

    public double getSpaceAfter(char c) {
        double length = FontInfo.byChar(c).getLength();
        if (length <= 5.0) {
            return 2.0;
        }
        if (length <= 10.0) {
            return 3.0;
        }
        if (length <= 20.0) {
            return 4.0;
        }
        if (length <= 30.0) {
            return 5.0;
        }
        if (length <= 40.0) {
            return 6.0;
        }
        return 7.0;
    }

    public static FontInfo byChar(char c) {
        for (FontInfo fontInfo : FontInfo.values()) {
            if (fontInfo.getCharacter() != c) continue;
            return fontInfo;
        }
        return null;
    }

    public char getCharacter() {
        return this.character;
    }

    public double getLength() {
        return this.length;
    }

    public double getBoldLength() {
        if (this == SPACE) {
            return this.getLength();
        }
        return this.length + 1.0;
    }

    public static double getExactLength(String text) {
        double length = 0.0;
        boolean isColor = false;
        boolean isBold = false;
        for (char c : text.toCharArray()) {
            if (c == '\u00a7') {
                isColor = true;
                continue;
            }
            if (isColor) {
                isColor = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            FontInfo info = FontInfo.byChar(c);
            if (info == null) continue;
            length += isBold ? info.getBoldLength() : info.getLength();
            length += 5.5;
        }
        return length;
    }

    public static String center(String s) {
        double length = FontInfo.getExactLength(s);
        if (length >= 1480.5) {
            return s;
        }
        double toCompensate = (1480.5 - length) / 2.0;
        double space = toCompensate / (SPACE.getLength() + 1.0 + 5.5);
        int spaces = (int)Math.floor(space);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            builder.append(" ");
        }
        builder.append(s);
        return builder.toString();
    }
}

