/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.sounds.Sound;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.util.Vector;

public class Environment {
    private static final Cache<Material, Optional<Sound>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).softValues().build();

    public static boolean canBeEntered(Material m) {
        return !m.isOccluding() && !m.isSolid();
    }

    public static boolean isWaterFluid(Block b) {
        if (Version.get().isBiggerThan(12.0) && b.getBlockData() instanceof Waterlogged) {
            Waterlogged w = (Waterlogged)b.getBlockData();
            return w.isWaterlogged() && !b.getType().isSolid();
        }
        return b.getType() == Material.WATER;
    }

    public static boolean canBeEntered(Block b) {
        return Environment.canBeEntered(b.getType()) || Environment.isWaterFluid(b);
    }

    public static void playRandomFireworkEffect(Location loc) {
        Firework fw;
        Random r = new Random();
        int rt = r.nextInt(2) + 1;
        FireworkEffect.Type type = FireworkEffect.Type.BALL;
        if (rt == 1) {
            type = FireworkEffect.Type.BALL;
        }
        if (rt == 2) {
            type = FireworkEffect.Type.BALL_LARGE;
        }
        int r1i = r.nextInt(17) + 1;
        int r2i = r.nextInt(17) + 1;
        Color c1 = Environment.getColor(r1i);
        Color c2 = Environment.getColor(r2i);
        FireworkEffect effect = FireworkEffect.builder().flicker(r.nextBoolean()).withColor(c1).withFade(c2).with(type).trail(r.nextBoolean()).build();
        try {
            fw = (Firework)loc.getWorld().spawnEntity(loc, EntityType.FIREWORK);
        }
        catch (Exception ex) {
            return;
        }
        FireworkMeta fwm = fw.getFireworkMeta();
        fwm.setPower(1);
        fwm.addEffect(effect);
        fw.setFireworkMeta(fwm);
    }

    public static Sound getBreakSoundOf(Block b) {
        String key;
        Optional cachedSound = (Optional)CACHE.getIfPresent((Object)b.getType());
        if (cachedSound != null) {
            return cachedSound.orElse(null);
        }
        Object w = PacketUtils.getWorldServer(b.getWorld());
        IReflection.MethodAccessor getType = IReflection.getMethod(PacketUtils.WorldServerClass, "getType", PacketUtils.IBlockDataClass, new Class[]{PacketUtils.BlockPositionClass});
        Object blockType = getType.invoke(w, PacketUtils.getBlockPosition(b.getLocation()));
        IReflection.MethodAccessor getBlock = IReflection.getMethod(PacketUtils.IBlockDataClass, "getBlock", PacketUtils.BlockClass, new Class[0]);
        Object block = getBlock.invoke(blockType, new Object[0]);
        if (Version.get().isBiggerThan(Version.v1_8)) {
            String f;
            IReflection.FieldAccessor getSoundEffectType = IReflection.getField(PacketUtils.BlockClass, "stepSound");
            Class<?> soundEffectTypeClass = IReflection.getClass(IReflection.ServerPacket.BLOCK, "SoundEffectType");
            Class<?> soundEffectClass = IReflection.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.sounds"), "SoundEffect");
            Class<?> minecraftKeyClass = IReflection.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.resources"), "MinecraftKey");
            Object soundEffectType = getSoundEffectType.get(block);
            switch (Version.get()) {
                case v1_15: {
                    f = "z";
                    break;
                }
                case v1_14: {
                    f = "y";
                    break;
                }
                case v1_13: {
                    f = "q";
                    break;
                }
                default: {
                    f = "o";
                }
            }
            IReflection.FieldAccessor getSoundEffect = IReflection.getField(soundEffectTypeClass, f);
            Object soundEffect = getSoundEffect.get(soundEffectType);
            switch (Version.get()) {
                case v1_15: 
                case v1_14: 
                case v1_13: {
                    f = "a";
                    break;
                }
                default: {
                    f = "b";
                }
            }
            IReflection.FieldAccessor getMCKey = IReflection.getField(soundEffectClass, f);
            Object mcKey = getMCKey.get(soundEffect);
            f = Version.get().isBiggerThan(Version.v1_14) ? "key" : "a";
            IReflection.FieldAccessor getKey = IReflection.getField(minecraftKeyClass, f);
            key = (String)getKey.get(mcKey);
        } else {
            IReflection.FieldAccessor getStepSound = IReflection.getField(PacketUtils.BlockClass, "stepSound");
            Class<?> stepSoundClass = IReflection.getClass(IReflection.ServerPacket.BLOCK, "Block$StepSound");
            IReflection.MethodAccessor breakSound = IReflection.getMethod(stepSoundClass, "getBreakSound", String.class, new Class[0]);
            Object stepSound = getStepSound.get(block);
            key = (String)breakSound.invoke(stepSound, new Object[0]);
            if (b.getType().name().contains("GLASS")) {
                key = key.substring(4);
            }
        }
        Optional<Sound> s = Sound.matchXSound(key.replace(".", "_"));
        CACHE.put((Object)b.getType(), s);
        return s.orElse(null);
    }

    public static Color getColor(int i) {
        Color c = null;
        if (i == 1) {
            c = Color.AQUA;
        }
        if (i == 2) {
            c = Color.BLACK;
        }
        if (i == 3) {
            c = Color.BLUE;
        }
        if (i == 4) {
            c = Color.FUCHSIA;
        }
        if (i == 5) {
            c = Color.GRAY;
        }
        if (i == 6) {
            c = Color.GREEN;
        }
        if (i == 7) {
            c = Color.LIME;
        }
        if (i == 8) {
            c = Color.MAROON;
        }
        if (i == 9) {
            c = Color.NAVY;
        }
        if (i == 10) {
            c = Color.OLIVE;
        }
        if (i == 11) {
            c = Color.ORANGE;
        }
        if (i == 12) {
            c = Color.PURPLE;
        }
        if (i == 13) {
            c = Color.RED;
        }
        if (i == 14) {
            c = Color.SILVER;
        }
        if (i == 15) {
            c = Color.TEAL;
        }
        if (i == 16) {
            c = Color.WHITE;
        }
        if (i == 17) {
            c = Color.YELLOW;
        }
        return c;
    }

    public static void dropItem(ItemStack item, Player p) {
        if (item == null || item.getType().equals((Object)Material.AIR)) {
            return;
        }
        Location loc = p.getLocation();
        loc.setY(loc.getY() + 1.32);
        Item drop = p.getWorld().dropItemNaturally(loc, item);
        Vector v = p.getEyeLocation().getDirection();
        v.multiply(0.33);
        v.setY(v.getY() + 0.1);
        drop.setVelocity(v);
        drop.setPickupDelay(40);
    }

    public static boolean isBlock(Block block) {
        return block != null && !block.getType().isTransparent() && block.getType().isSolid() && !block.getType().name().contains("SIGN") && !block.getType().equals((Object)Material.AIR);
    }

    public static List<Chunk> getChunks(Location mid, int chunkRadius) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        if (chunkRadius <= 0) {
            return chunks;
        }
        int startX = Environment.floor((double)mid.getBlockX() / 16.0);
        int startZ = Environment.floor((double)mid.getBlockZ() / 16.0);
        for (int z = startZ - --chunkRadius; z <= startZ + chunkRadius; ++z) {
            for (int x = startX - chunkRadius; x <= startX + chunkRadius; ++x) {
                try {
                    chunks.add(mid.getWorld().getChunkAt(x, z));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return chunks;
    }

    private static int floor(double var0) {
        int var2 = (int)var0;
        return var0 < (double)var2 ? var2 - 1 : var2;
    }

    public static boolean isSlab(Block block) {
        if (block == null) {
            return false;
        }
        return block.getType().name().contains("SLAB") || block.getType().name().contains("STEP");
    }

    public static double getBlockHeight(Block block) {
        if (block == null) {
            return 0.0;
        }
        return block.getType().name().contains("SLAB") || block.getType().name().contains("STEP") ? 0.5 : 1.0;
    }

    public static List<Block> getNearbyBlocks(Location location, int radius, boolean yAxis) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = location.getBlockX() - radius; x <= location.getBlockX() + radius; ++x) {
            for (int z = location.getBlockZ() - radius; z <= location.getBlockZ() + radius; ++z) {
                if (yAxis) {
                    for (int y = location.getBlockY() - radius; y <= location.getBlockY() + radius; ++y) {
                        blocks.add(location.getWorld().getBlockAt(x, y, z));
                    }
                    continue;
                }
                blocks.add(location.getWorld().getBlockAt(x, location.getBlockY(), z));
            }
        }
        return blocks;
    }

    public static List<Block> getCylinder(Location center, int radius, int height, boolean hollow) {
        ArrayList<Block> circle = new ArrayList<Block>();
        int bX = center.getBlockX();
        int bY = center.getBlockY();
        int bZ = center.getBlockZ();
        for (int x = bX - radius; x <= bX + radius; ++x) {
            for (int y = bY - height; y <= bY + height; ++y) {
                for (int z = bZ - radius; z <= bZ + radius; ++z) {
                    double distance = Math.sqrt(Math.pow(bX - x, 2.0) + Math.pow(bY - y, 2.0) + Math.pow(bZ - z, 2.0));
                    if (!(distance < (double)radius) || hollow && distance < (double)(radius - 1)) continue;
                    circle.add(new Location(center.getWorld(), (double)x, (double)y, (double)z).getBlock());
                }
            }
        }
        return circle;
    }

    public static Block getNextBottomBlock(Location location) {
        while (location.getBlock() == null || !Environment.isBlock(location.getBlock())) {
            location.setY(location.getY() - 1.0);
            if (!(location.getY() <= 0.0)) continue;
            return null;
        }
        return location.getBlock();
    }

    public static Block getNextTopBlock(Location location, int max) {
        while (location.getBlock() == null || !Environment.isBlock(location.getBlock())) {
            location.setY(location.getY() + 1.0);
            if (!(location.getY() >= (double)max)) continue;
            return null;
        }
        return location.getBlock();
    }

    public static Block getNextNonSolidBlock(Location location, int max, Vector vector) {
        vector.normalize();
        for (int i = 0; i < max && location.getBlock().getType().isSolid(); ++i) {
            location.add(vector);
        }
        return location.getBlock();
    }

    public static Block getHeighestBlock(Location location, int max, boolean onlySolid) {
        location.setY((double)max);
        while (!(!onlySolid && location.getBlock().getType() != Material.AIR || onlySolid && location.getBlock().getType().isSolid())) {
            location.setY(location.getY() - 1.0);
        }
        return location.getBlock();
    }

    public static Block getNextBottomBlock(Location location, boolean ignoreTransparency) {
        Block b;
        if (!ignoreTransparency) {
            return Environment.getNextBottomBlock(location);
        }
        while ((b = Environment.getNextBottomBlock(location)) != null && !b.getType().isOccluding()) {
            location.setY(location.getY() - 1.0);
        }
        return b;
    }

    public static Block getNextTopBlock(Location location, int max, boolean ignoreTransparency) {
        Block b;
        if (!ignoreTransparency) {
            return Environment.getNextTopBlock(location, max);
        }
        while ((b = Environment.getNextTopBlock(location, max)) != null && !b.getType().isOccluding()) {
            location.setY(location.getY() + 1.0);
        }
        return location.getBlock();
    }

    public static List<Block> getBlocksBetween(Location loc, Location target, boolean ignoreTransparency) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Vector v = target.toVector().subtract(loc.toVector());
        Location c = loc.clone();
        double originalLength = v.length();
        double length = v.normalize().length();
        for (double i = 0.0; i <= originalLength; i += length) {
            if (!blocks.contains(c.getBlock()) && Environment.isBlock(c.getBlock())) {
                if (ignoreTransparency && (!c.getBlock().getType().isSolid() || c.getBlock().getType().isTransparent())) continue;
                blocks.add(c.getBlock());
            }
            c.add(v);
        }
        return blocks;
    }

    public static Location getInvisibleLocation(Player p) {
        return Environment.getInvisibleLocation(p, 32.0);
    }

    public static Location getInvisibleLocation(Player p, double multiply) {
        Location loc = p.getLocation().clone();
        return loc.getDirection().multiply(multiply).add(loc.toVector()).toLocation(p.getWorld());
    }

    public static void openChest(Location loc, Player ... players) {
        if (loc.getBlock() == null || !loc.getBlock().getType().equals((Object)Material.CHEST)) {
            return;
        }
        Object pos = PacketUtils.getBlockPosition(loc);
        IReflection.ConstructorAccessor con = IReflection.getConstructor(PacketUtils.PacketPlayOutBlockActionClass, PacketUtils.BlockPositionClass, PacketUtils.BlockClass, Integer.TYPE, Integer.TYPE);
        Object packet = con.newInstance(pos, PacketUtils.Blocks.findByName("CHEST"), 1, 1);
        if (players.length == 0) {
            PacketUtils.sendPacketToAll(packet);
        } else {
            PacketUtils.sendPacket(packet, players);
        }
    }

    public static void closeChest(Location loc, Player ... players) {
        if (loc.getBlock() == null || !loc.getBlock().getType().equals((Object)Material.CHEST)) {
            return;
        }
        Object pos = PacketUtils.getBlockPosition(loc);
        IReflection.ConstructorAccessor con = IReflection.getConstructor(PacketUtils.PacketPlayOutBlockActionClass, PacketUtils.BlockPositionClass, PacketUtils.BlockClass, Integer.TYPE, Integer.TYPE);
        Object packet = con.newInstance(pos, PacketUtils.Blocks.findByName("CHEST"), 1, 0);
        if (players.length == 0) {
            PacketUtils.sendPacketToAll(packet);
        } else {
            PacketUtils.sendPacket(packet, players);
        }
    }
}

