/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.sign;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.nms.NmsLoader;
import de.codingair.tradesystem.lib.codingapi.player.data.PacketReader;
import de.codingair.tradesystem.lib.codingapi.server.AsyncCatcher;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.Packet;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.tools.Call;
import de.codingair.tradesystem.lib.codingapi.tools.items.XMaterial;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.lang.reflect.Array;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SignGUI {
    private static final Class<?> packetClass = IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayInUpdateSign");
    private static final Class<?> updatePacket = Version.get().isBiggerThan(8.0) ? IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutTileEntityData") : IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutUpdateSign");
    private static final Class<?> baseBlockPosition;
    private static final IReflection.FieldAccessor<?> pos;
    private static final IReflection.MethodAccessor getX;
    private static final IReflection.MethodAccessor getY;
    private static final IReflection.MethodAccessor getZ;
    private static final IReflection.FieldAccessor<?> packetLines;
    private final Player player;
    private final JavaPlugin plugin;
    private final Sign sign;
    private final String[] lines;
    private Location signLocation = null;
    private Runnable waiting = null;

    @NmsLoader
    private SignGUI() {
        this.player = null;
        this.plugin = null;
        this.sign = null;
        this.lines = null;
    }

    public SignGUI(@NotNull Player player, @NotNull JavaPlugin plugin, @Nullable Sign sign, @Nullable String[] lines) {
        if (lines != null) {
            this.lines = new String[4];
            for (int i = 0; i < 4 && i < lines.length; ++i) {
                this.lines[i] = lines[i];
            }
        } else {
            this.lines = null;
        }
        this.player = player;
        this.plugin = plugin;
        this.sign = sign;
        if (this.sign != null) {
            this.signLocation = sign.getLocation();
        }
    }

    public SignGUI(@NotNull Player player, @NotNull JavaPlugin plugin, String ... lines) {
        this(player, plugin, (Sign)null, lines);
    }

    public SignGUI(@NotNull Player player, @Nullable Sign edit, @NotNull JavaPlugin plugin) {
        this(player, plugin, edit, null);
    }

    public SignGUI(@NotNull Player player, @NotNull JavaPlugin plugin) {
        this(player, plugin, (Sign)null, (String[])null);
    }

    public abstract void onSignChangeEvent(String[] var1);

    public void onClose(InventoryCloseEvent e) {
    }

    public void open() {
        boolean needsTempSign;
        if (Version.get().equals((Object)Version.v1_7)) {
            throw new IllegalStateException("The SignEditor does not work on 1.7!");
        }
        this.player.closeInventory();
        this.injectPacketReader();
        Runnable runnable = () -> {
            if (this.sign != null) {
                this.prepareSignEditing(this.sign);
            }
            this.openEditor(this.signLocation);
            this.waiting = null;
        };
        boolean bl = needsTempSign = this.sign == null;
        if (needsTempSign) {
            this.waiting = runnable;
            this.signLocation = this.getTemporarySignLocation();
            this.prepareTemporarySign(XMaterial.OAK_SIGN, this.signLocation);
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable);
        }
    }

    private void injectPacketReader() {
        new PacketReader(this.player, "SignEditor", this.plugin){

            @Override
            public boolean readPacket(Object packet) {
                if (packet.getClass().equals(packetClass)) {
                    String[] lines;
                    if (Version.atLeast(9.0)) {
                        lines = (String[])packetLines.get(packet);
                    } else {
                        lines = SignGUI.this.sign == null ? new String[4] : SignGUI.this.sign.getLines();
                        Object[] data = (Object[])packetLines.get(packet);
                        assert (PacketUtils.IChatBaseComponentClass != null);
                        IReflection.MethodAccessor getText = IReflection.getMethod(PacketUtils.IChatBaseComponentClass, "getText", String.class, new Class[0]);
                        IReflection.MethodAccessor getSiblings = IReflection.getMethod(PacketUtils.IChatBaseComponentClass, "a", List.class, new Class[0]);
                        for (int i = 0; i < 4; ++i) {
                            Object icbc;
                            try {
                                icbc = PacketUtils.IChatBaseComponentClass.cast(data[i]);
                            }
                            catch (Exception ex) {
                                icbc = PacketUtils.getChatMessage((String)data[i]);
                            }
                            int siblings = ((List)getSiblings.invoke(icbc, new Object[0])).size();
                            String line = (String)getText.invoke(icbc, new Object[0]);
                            if (line.isEmpty() && siblings != 0) continue;
                            lines[i] = line;
                        }
                    }
                    Bukkit.getScheduler().runTask((Plugin)SignGUI.this.plugin, () -> {
                        SignGUI.this.onSignChangeEvent(lines);
                        SignGUI.this.revertTempSignBlock();
                    });
                    return true;
                }
                return false;
            }

            @Override
            public boolean writePacket(Object packet) {
                if (packet.getClass().equals(updatePacket)) {
                    Object position = pos.get(packet);
                    int x = (Integer)getX.invoke(position, new Object[0]);
                    int y = (Integer)getY.invoke(position, new Object[0]);
                    int z = (Integer)getZ.invoke(position, new Object[0]);
                    if (SignGUI.this.waiting != null && SignGUI.this.signLocation != null && SignGUI.this.signLocation.getBlockX() == x && SignGUI.this.signLocation.getBlockY() == y && SignGUI.this.signLocation.getBlockZ() == z) {
                        Bukkit.getScheduler().runTask((Plugin)SignGUI.this.plugin, SignGUI.this.waiting);
                        SignGUI.this.waiting = null;
                    }
                }
                return false;
            }
        }.inject();
    }

    @NotNull
    private Location getTemporarySignLocation() {
        return this.player.getLocation().clone().subtract(0.0, 7.0, 0.0);
    }

    private void prepareTemporarySign(@NotNull XMaterial material, @NotNull Location tempSign) {
        PacketUtils.sendBlockChange(this.player, tempSign, material);
        if (this.lines != null) {
            this.sendLinesChange(tempSign, material);
        }
    }

    private void revertTempSignBlock() {
        if (this.sign != null) {
            return;
        }
        Block b = this.signLocation.getBlock();
        PacketUtils.sendBlockChange(this.player, this.signLocation, b);
    }

    private void sendLinesChange(@NotNull Location tempSign, @NotNull XMaterial material) {
        Object packet;
        IReflection.MethodAccessor createUpdatePacket;
        Object tileEntity;
        IReflection.ConstructorAccessor con;
        Class<?> iChatBaseComponentArrayClass = Array.newInstance(PacketUtils.IChatBaseComponentClass, 0).getClass();
        Class<?> craftSign = IReflection.getClass(IReflection.ServerPacket.CRAFTBUKKIT_BLOCK, "CraftSign");
        IReflection.MethodAccessor sanitizeLines = IReflection.getMethod(craftSign, iChatBaseComponentArrayClass, new Class[]{String[].class});
        Object[] lines = (Object[])sanitizeLines.invoke(null, new Object[]{this.lines});
        Object blockPos = PacketUtils.getBlockPosition(tempSign);
        Class<?> tileEntitySignClass = IReflection.getClass(IReflection.ServerPacket.BLOCK_ENTITY, "TileEntitySign");
        if (Version.atLeast(17.0)) {
            con = IReflection.getConstructor(tileEntitySignClass, PacketUtils.BlockPositionClass, PacketUtils.IBlockDataClass);
            if (con == null) {
                throw new NullPointerException("Cannot prepare temporary sign: Could not find TileEntitySign constructor.");
            }
            tileEntity = con.newInstance(PacketUtils.getBlockPosition(tempSign), PacketUtils.getIBlockData(material));
        } else {
            con = IReflection.getConstructor(tileEntitySignClass, new Class[0]);
            if (con == null) {
                throw new NullPointerException("Cannot prepare temporary sign: Could not find TileEntitySign constructor.");
            }
            tileEntity = con.newInstance(new Object[0]);
            IReflection.FieldAccessor<?> setBlockPos = IReflection.getField(tileEntitySignClass, PacketUtils.BlockPositionClass, 0);
            setBlockPos.set(tileEntity, blockPos);
        }
        if (Version.atLeast(20.0)) {
            Class<?> signTextClass = IReflection.getClass(IReflection.ServerPacket.BLOCK_ENTITY, "SignText");
            Class<?> enumColorClass = IReflection.getClass(IReflection.ServerPacket.WORLD_ITEM, "EnumColor");
            con = IReflection.getConstructor(signTextClass, iChatBaseComponentArrayClass, iChatBaseComponentArrayClass, enumColorClass, Boolean.TYPE);
            if (con == null) {
                throw new NullPointerException("Cannot prepare temporary sign: Could not find SignText constructor.");
            }
            Object blackColor = enumColorClass.getEnumConstants()[enumColorClass.getEnumConstants().length - 1];
            Object signText = con.newInstance(lines, lines, blackColor, false);
            IReflection.MethodAccessor applyText = IReflection.getMethod(tileEntitySignClass, Boolean.TYPE, new Class[]{signTextClass, Boolean.TYPE});
            boolean front = true;
            applyText.invoke(tileEntity, signText, front);
        } else if (Version.atLeast(13.0)) {
            IReflection.MethodAccessor applyLine = IReflection.getMethod(tileEntity.getClass(), new Class[]{Integer.TYPE, PacketUtils.IChatBaseComponentClass});
            for (int i = 0; i < lines.length; ++i) {
                applyLine.invoke(tileEntity, i, lines[i]);
            }
        } else {
            IReflection.FieldAccessor<?> linesField = IReflection.getField(tileEntitySignClass, Array.newInstance(PacketUtils.IChatBaseComponentClass, 0).getClass(), 0);
            linesField.set(tileEntity, lines);
        }
        if (Version.atLeast(9.0)) {
            createUpdatePacket = IReflection.getMethod(tileEntity.getClass(), IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutTileEntityData"), new Class[0]);
            packet = createUpdatePacket.invoke(tileEntity, new Object[0]);
        } else {
            createUpdatePacket = IReflection.getMethod(tileEntity.getClass(), IReflection.getClass(IReflection.ServerPacket.PACKETS, "Packet"), new Class[0]);
            packet = createUpdatePacket.invoke(tileEntity, new Object[0]);
        }
        PacketUtils.sendPacket(this.player, packet);
    }

    private void prepareSignEditing(@Nullable Sign sign) {
        if (sign != null) {
            Object tileEntity;
            if (Version.get().isBiggerThan(Version.v1_11)) {
                IReflection.MethodAccessor getTileEntity = IReflection.getMethod(sign.getClass(), "getTileEntity", new Class[0]);
                tileEntity = getTileEntity.invoke(sign, new Object[0]);
            } else {
                tileEntity = IReflection.getField(sign.getClass(), "sign").get(sign);
            }
            IReflection.FieldAccessor<Boolean> editable = IReflection.getNonStaticField(PacketUtils.TileEntitySignClass, Boolean.TYPE, 0);
            editable.set(tileEntity, true);
            if (Version.atLeast(17.0)) {
                IReflection.FieldAccessor<UUID> id = IReflection.getNonStaticField(PacketUtils.TileEntitySignClass, UUID.class, 0);
                id.set(tileEntity, this.player.getUniqueId());
            } else {
                IReflection.FieldAccessor owner = IReflection.getField(PacketUtils.TileEntitySignClass, Version.since(13.0, "h", "g", "j", "c"));
                owner.set(tileEntity, PacketUtils.getEntityPlayer(this.player));
            }
        }
    }

    private void openEditor(@NotNull Location signLocation) {
        Packet packet = new Packet(PacketUtils.PacketPlayOutOpenSignEditorClass, this.player);
        Object location = PacketUtils.getBlockPosition(signLocation);
        packet.initialize(location, Version.since(20.0, Packet.IGNORE, true));
        packet.send();
    }

    public void close() {
        this.close(null);
    }

    public void close(@Nullable Call call) {
        PacketReader packetReader = null;
        List<PacketReader> l = API.getRemovables(this.player, PacketReader.class);
        for (PacketReader reader : l) {
            if (!reader.getName().equals("SignEditor")) continue;
            packetReader = reader;
            break;
        }
        l.clear();
        if (packetReader != null) {
            packetReader.unInject();
        }
        AsyncCatcher.runSync(this.plugin, () -> {
            this.player.closeInventory();
            if (call != null) {
                call.proceed();
            }
        });
    }

    public String[] getLines() {
        return this.lines;
    }

    static {
        pos = IReflection.getField(updatePacket, PacketUtils.BlockPositionClass, 0);
        baseBlockPosition = IReflection.getClass(IReflection.ServerPacket.CORE, Version.choose("BaseBlockPosition", 20.5, "Vec3i"));
        getX = IReflection.getMethod(baseBlockPosition, Version.choose("getX", 18.0, "u", 20.5, "getX"), Integer.TYPE, new Class[0]);
        getY = IReflection.getMethod(baseBlockPosition, Version.choose("getY", 18.0, "v", 20.5, "getY"), Integer.TYPE, new Class[0]);
        getZ = IReflection.getMethod(baseBlockPosition, Version.choose("getZ", 18.0, "w", 20.5, "getZ"), Integer.TYPE, new Class[0]);
        packetLines = Version.atLeast(9.0) ? IReflection.getField(PacketUtils.PacketPlayInUpdateSignClass, String[].class, 0) : IReflection.getField(PacketUtils.PacketPlayInUpdateSignClass, "b");
    }

    public static class NmsWrapper
    extends SignGUI {
        @NmsLoader
        private NmsWrapper() {
        }

        @Override
        public void onSignChangeEvent(String[] lines) {
        }
    }
}

