/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.GUISwitchButton;
import de.codingair.tradesystem.lib.codingapi.player.gui.sign.SignGUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.sign.SignTools;
import de.codingair.tradesystem.lib.codingapi.tools.Call;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.block.Sign;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public abstract class SignButton
extends Button
implements GUISwitchButton {
    private final Sign sign;
    protected final Supplier<String[]> lines;

    private SignButton(@Nullable Sign sign, @NotNull Supplier<String[]> lines) {
        this.sign = sign;
        this.lines = lines;
    }

    private SignButton(@Nullable Sign sign, @Nullable String[] lines) {
        this(sign, () -> lines);
    }

    public SignButton(@Nullable Sign sign) {
        this(sign, (String[])null);
    }

    public SignButton(@Nullable String[] lines) {
        this(null, lines);
    }

    public SignButton(@NotNull Supplier<String[]> lines) {
        this(null, lines);
    }

    public abstract boolean onSignChangeEvent(GUI var1, String[] var2);

    @Override
    public boolean open(ClickType clickType, final GUI gui, final Call call) {
        new SignGUI(gui.getPlayer(), gui.getPlugin(), this.sign, this.lines.get()){

            @Override
            public void onSignChangeEvent(String[] lines) {
                if (SignButton.this.sign != null) {
                    Bukkit.getScheduler().runTask((Plugin)gui.getPlugin(), () -> SignTools.updateSign(SignButton.this.sign, lines, true));
                }
                if (SignButton.this.onSignChangeEvent(gui, lines)) {
                    this.close(call);
                } else {
                    Bukkit.getScheduler().runTask((Plugin)gui.getPlugin(), this::open);
                }
            }
        }.open();
        return false;
    }
}

