/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import java.util.HashMap;
import org.bukkit.util.Vector;

public abstract class Page {
    protected final GUI gui;
    protected final Page basic;
    private final HashMap<Integer, Button> items;
    private String title = null;

    public Page(GUI gui, Page basic) {
        this.gui = gui;
        this.basic = basic;
        this.items = new HashMap();
    }

    public Page(GUI gui) {
        this(gui, null);
    }

    public abstract void buildItems();

    public void apply() {
        this.apply(true);
    }

    public void apply(boolean basic) {
        this.buildItems();
        this.deploy(basic);
    }

    private void deploy(boolean basic) {
        if (basic && this.basic != null) {
            this.basic.apply(basic);
        }
        this.items.forEach((slot, item) -> this.gui.setItem((int)slot, item.buildItem()));
        this.gui.updateTitle(this.title);
    }

    public void rebuild() {
        this.rebuild(true);
    }

    public void rebuild(boolean basic) {
        this.clear(basic);
        this.items.clear();
        this.buildItems();
        this.deploy(basic);
    }

    public void updateItems() {
        this.updateItems(true);
    }

    public void updateItems(boolean basic) {
        this.deploy(basic);
    }

    public void updateItem(int slot) throws NullPointerException {
        Button button = this.getButtonAt(slot);
        if (button == null) {
            throw new NullPointerException("Could not find a button at slot=" + slot);
        }
        this.gui.setItem(slot, button.buildItem());
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean basic) {
        this.gui.clear(this.items.keySet());
        if (basic && this.basic != null) {
            this.basic.clear(basic);
        }
    }

    public Button getButtonAt(int slot) {
        Button b = this.items.get(slot);
        if (b == null && this.basic != null) {
            return this.basic.getButtonAt(slot);
        }
        return b;
    }

    public Button getButtonAt(int x, int y) {
        return this.getButtonAt(x + y * 9);
    }

    public Button removeButtonAt(int slot) {
        return this.items.remove(slot);
    }

    public Button removeButtonAt(int x, int y) {
        return this.removeButtonAt(x + y * 9);
    }

    public void addButton(int slot, Button button) {
        this.items.put(slot, button);
    }

    public void addButtonIfAbsent(int slot, Button button) {
        this.items.putIfAbsent(slot, button);
    }

    public void addButton(int x, int y, Button button) {
        this.items.put(x + y * 9, button);
    }

    public void addButtonIfAbsent(int x, int y, Button button) {
        this.items.putIfAbsent(x + y * 9, button);
    }

    public void addLine(int x0, int y0, int x1, int y1, Button button) {
        this.addLine(x0, y0, x1, y1, button, false);
    }

    public void addLine(int x0, int y0, int x1, int y1, Button button, boolean overwrite) {
        double cX = x0;
        double cY = y0;
        Vector v = new Vector(x1, y1, 0).subtract(new Vector(x0, y0, 0)).normalize();
        do {
            if (overwrite) {
                this.addButton((int)cX, (int)cY, button);
                continue;
            }
            this.addButtonIfAbsent((int)cX, (int)cY, button);
        } while ((int)(cX += v.getX()) != x1 || (int)(cY += v.getY()) != y1);
        if (overwrite) {
            this.addButton((int)cX, (int)cY, button);
        } else {
            this.addButtonIfAbsent((int)cX, (int)cY, button);
        }
    }

    public void destroy() {
        this.items.clear();
    }

    public Page getBasic() {
        return this.basic;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

