/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2;

import com.google.common.base.Preconditions;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.InventoryUtils;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class InventoryBuilder
implements Removable {
    protected final Player player;
    protected final UUID id = UUID.randomUUID();
    protected final JavaPlugin plugin;
    private String title;
    protected Inventory inventory;

    public InventoryBuilder(Player player, JavaPlugin plugin) {
        this.player = player;
        this.plugin = plugin;
    }

    public void buildInventory(int size, String title) {
        Preconditions.checkState((size % 9 == 0 ? 1 : 0) != 0);
        if (Version.before(11.0)) {
            int colors = this.count(title, '\u00a7') * 2;
            if (title.length() > 32 + colors) {
                title = title.substring(0, 32 + colors);
            }
        }
        this.title = title;
        this.inventory = Bukkit.createInventory(null, (int)size, (String)this.title);
    }

    private int count(String s, char c) {
        int i = 0;
        for (char c1 : s.toCharArray()) {
            if (c1 != c) continue;
            ++i;
        }
        return i;
    }

    public void clear() {
        Preconditions.checkNotNull((Object)this.inventory);
        this.inventory.clear();
    }

    public void clear(Collection<Integer> slots) {
        Preconditions.checkNotNull((Object)this.inventory);
        for (Integer slot : slots) {
            this.inventory.clear(slot.intValue());
        }
    }

    public boolean setItem(int slot, ItemStack item) {
        Preconditions.checkNotNull((Object)this.inventory);
        if (this.compare(this.getItem(slot), item)) {
            return false;
        }
        this.inventory.setItem(slot, item);
        return true;
    }

    public boolean setItem(int x, int y, ItemStack item) {
        return this.setItem(x + y * 9, item);
    }

    public ItemStack getItem(int slot) {
        Preconditions.checkNotNull((Object)this.inventory);
        return this.inventory.getItem(slot);
    }

    public ItemStack getItem(int x, int y) {
        return this.getItem(x + y * 9);
    }

    private boolean compare(ItemStack item, ItemStack other) {
        return Objects.equals(item, other);
    }

    public void updateTitle(String invTitle) {
        if (invTitle.length() > 32) {
            invTitle = invTitle.substring(0, 32);
        }
        if (this.title.equals(invTitle)) {
            return;
        }
        this.title = invTitle;
        InventoryUtils.updateTitle(this.player, this.title, this.inventory);
    }

    @Override
    public void destroy() {
        if (this.inventory != null) {
            this.player.closeInventory();
        }
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public UUID getUniqueId() {
        return this.id;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

