/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.GUISwitchButton;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsNotWaitingException;
import de.codingair.tradesystem.lib.codingapi.tools.Call;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GUIListener
implements Listener {
    private final GUI gui;
    private Call closeListener = null;

    public GUIListener(GUI gui) {
        this.gui = gui;
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (this.gui == null || this.gui.getInventory() == null) {
            return;
        }
        if (!this.gui.waiting && this.gui.getInventory().equals(e.getInventory())) {
            if (this.gui.closing != null) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.gui.getPlugin(), () -> this.gui.closing.accept(this.gui.getPlayer()), 1L);
            } else {
                this.gui.forceClose(this, null);
            }
        } else if (this.closeListener != null && e.getPlayer().equals(this.gui.getPlayer())) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.gui.getPlugin(), () -> {
                if (this.closeListener != null) {
                    this.closeListener.proceed();
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (this.gui == null || this.gui.getInventory() == null) {
            return;
        }
        if (!this.gui.waiting && this.gui.getInventory().equals(e.getInventory())) {
            if (e.getClickedInventory() != null && e.getClickedInventory().equals(e.getView().getTopInventory())) {
                Button b = this.gui.getActive().getButtonAt(e.getSlot());
                if (b != null) {
                    e.setCancelled(true);
                    if (b.canClick(e.getClick())) {
                        b.onClick(this.gui, e);
                        b.playSound(this.gui.getPlayer());
                        if (b instanceof GUISwitchButton && ((GUISwitchButton)((Object)b)).canSwitch(e.getClick())) {
                            this.gui.waiting = true;
                            Call closing = () -> {
                                try {
                                    this.gui.continueGUI();
                                }
                                catch (IsNotWaitingException ex) {
                                    ex.printStackTrace();
                                }
                            };
                            boolean listenOnClose = ((GUISwitchButton)((Object)b)).open(e.getClick(), this.gui, closing);
                            if (listenOnClose) {
                                this.closeListener = closing;
                            }
                        }
                    }
                } else if (this.gui.cancelInventoryEvents()) {
                    e.setCancelled(true);
                }
            } else if (this.gui.cancelInventoryEvents()) {
                if (e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                    e.setCancelled(true);
                } else if (e.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
                    e.setCancelled(true);
                    ItemStack cursor = e.getCursor();
                    if (cursor != null && cursor.getAmount() < cursor.getMaxStackSize()) {
                        Inventory inv = e.getView().getBottomInventory();
                        ArrayList<Integer> list = new ArrayList<Integer>();
                        for (int i2 = 0; i2 < inv.getSize(); ++i2) {
                            ItemStack current = inv.getItem(i2);
                            if (!cursor.isSimilar(current)) continue;
                            list.add(i2);
                        }
                        list.sort((i, i1) -> {
                            ItemStack current = inv.getItem(i.intValue());
                            ItemStack other = inv.getItem(i1.intValue());
                            return Integer.compare(current.getAmount(), other.getAmount());
                        });
                        for (Integer i3 : list) {
                            ItemStack current = inv.getItem(i3.intValue());
                            int trade = Math.min(cursor.getMaxStackSize() - cursor.getAmount(), current.getAmount());
                            cursor.setAmount(cursor.getAmount() + trade);
                            current.setAmount(current.getAmount() - trade);
                            if (current.getAmount() == 0) {
                                inv.clear(i3.intValue());
                            }
                            if (cursor.getAmount() != cursor.getMaxStackSize()) continue;
                            break;
                        }
                        list.clear();
                    }
                }
            }
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        if (this.gui == null || this.gui.getInventory() == null) {
            return;
        }
        if (!this.gui.waiting && this.gui.getInventory().equals(e.getInventory())) {
            int max = this.gui.getInventory().getSize();
            for (Integer rawSlot : e.getRawSlots()) {
                if (rawSlot >= max) continue;
                e.setCancelled(true);
            }
        }
    }

    public GUIListener setCloseListener(Call closeListener) {
        this.closeListener = closeListener;
        return this;
    }
}

