/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2;

import com.google.common.base.Preconditions;
import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.InventoryUtils;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUIListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.InventoryBuilder;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.Page;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyClosedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsNotWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.PageAlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.tools.Callback;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GUI
extends InventoryBuilder {
    protected final HashSet<Page> pages = new HashSet();
    protected final HashMap<Class<? extends Page>, Page> pageLink = new HashMap();
    protected GUIListener listener;
    protected GUI fallback;
    protected Page active;
    protected boolean waiting = false;
    Callback<Player> closing;
    private int size;
    private String title;
    private String originalTitle;
    private final boolean cancelInventoryEvents;

    public GUI(Player player, JavaPlugin plugin, boolean cancelInventoryEvents) {
        super(player, plugin);
        this.cancelInventoryEvents = cancelInventoryEvents;
    }

    public GUI(Player player, JavaPlugin plugin) {
        this(player, plugin, true);
    }

    public GUI(Player player, JavaPlugin plugin, int size, String title, boolean cancelInventoryEvents) {
        this(player, plugin, cancelInventoryEvents);
        this.buildInventory(size, title);
    }

    public GUI(Player player, JavaPlugin plugin, int size, String title) {
        this(player, plugin, size, title, true);
    }

    @Override
    public void buildInventory(int size, String title) {
        this.size = size;
        this.originalTitle = this.title = title;
        super.buildInventory(size, title);
    }

    public void open() throws AlreadyOpenedException, NoPageException, IsWaitingException {
        if (this.waiting) {
            throw new IsWaitingException();
        }
        if (this.isOpen()) {
            throw new AlreadyOpenedException();
        }
        if (this.active == null) {
            throw new NoPageException();
        }
        this.listener = new GUIListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)this.plugin);
        GUI gui = API.getRemovable(this.player, GUI.class);
        if (gui != null) {
            gui.waiting = true;
            this.setFallback(gui);
        }
        API.addRemovable(this);
        this.player.openInventory(this.inventory);
    }

    protected void continueGUI() throws IsNotWaitingException {
        if (!this.waiting) {
            throw new IsNotWaitingException();
        }
        this.waiting = false;
        this.listener.setCloseListener(null);
        this.player.openInventory(this.inventory);
    }

    public void close() throws AlreadyClosedException {
        this.close(null);
    }

    public void close(final Callback<Player> callback) throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException();
        }
        final GUIListener listener = this.listener;
        this.listener = null;
        if (this.fallback != null) {
            this.waiting = true;
            try {
                this.fallback.continueGUI();
            }
            catch (IsNotWaitingException e) {
                e.printStackTrace();
            }
            this.inventory = null;
            this.fallback = null;
            this.forceClose(listener, callback);
            this.waiting = false;
        } else {
            this.closing = new Callback<Player>(){

                @Override
                public void accept(Player player) {
                    GUI.this.forceClose(listener, callback);
                }
            };
            this.player.closeInventory();
        }
    }

    public void openNestedGUI(GUI gui, boolean listenOnClose, boolean clickSound) throws AlreadyOpenedException, NoPageException, IsWaitingException {
        this.waiting = true;
        if (clickSound) {
            Button.defaultSound().play(this.player);
        }
        gui.setFallback(this);
        gui.open();
        if (listenOnClose) {
            this.listener.setCloseListener(() -> {
                try {
                    this.continueGUI();
                }
                catch (IsNotWaitingException ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    void forceClose(GUIListener listener, Callback<Player> callback) {
        HandlerList.unregisterAll((Listener)listener);
        this.listener = null;
        API.removeRemovable(this);
        if (callback != null) {
            callback.accept(this.player);
        }
        this.closing = null;
        if (this.fallback != null && this.fallback.waiting) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> {
                try {
                    if (this.fallback != null && this.fallback.waiting) {
                        this.fallback.continueGUI();
                    }
                }
                catch (IsNotWaitingException e) {
                    e.printStackTrace();
                }
            }, 1L);
        }
    }

    public void registerPage(Page page) {
        this.registerPage(page, false);
    }

    public void registerPage(Page page, boolean active) {
        this.pageLink.putIfAbsent(page.getClass(), page);
        this.pages.add(page);
        if (active) {
            try {
                this.switchTo(page);
            }
            catch (PageAlreadyOpenedException e) {
                e.printStackTrace();
            }
        }
    }

    public void switchTo(Class<? extends Page> pageClass) throws PageAlreadyOpenedException {
        this.switchTo(this.pageLink.get(pageClass));
    }

    public void switchTo(Page page) throws PageAlreadyOpenedException {
        Preconditions.checkNotNull((Object)page);
        if (this.active == null) {
            this.active = page;
            page.apply(true);
            return;
        }
        if (this.active.equals(page)) {
            throw new PageAlreadyOpenedException();
        }
        boolean basic = !Objects.equals(this.active.getBasic(), page.getBasic());
        this.active.clear(basic);
        page.apply(basic);
        this.active = page;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.pages.forEach(Page::destroy);
        this.pages.clear();
        this.pageLink.clear();
        API.removeRemovable(this);
    }

    @Override
    public void updateTitle(String title) {
        if (title == null) {
            title = this.originalTitle;
        }
        if (this.title.equals(title)) {
            return;
        }
        this.title = title;
        InventoryUtils.updateTitle(this.player, title, this.inventory);
    }

    public GUI getFallback() {
        return this.fallback;
    }

    public GUI setFallback(GUI fallback) {
        this.fallback = fallback;
        return this;
    }

    public boolean isOpen() {
        return this.listener != null;
    }

    public Page getActive() {
        return this.active;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public boolean cancelInventoryEvents() {
        return this.cancelInventoryEvents;
    }
}

