/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.guis;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.InterfaceListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.itembutton.ItemButton;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.itembutton.ItemButtonOption;
import de.codingair.tradesystem.lib.codingapi.server.sounds.Sound;
import de.codingair.tradesystem.lib.codingapi.tools.Callback;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.codingapi.tools.items.XMaterial;
import de.codingair.tradesystem.lib.codingapi.utils.TextAlignment;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfirmGUI
extends GUI {
    private final Callback<Boolean> callback;
    private Runnable close;
    private final String accept;
    private final String message;
    private final String decline;

    public ConfirmGUI(Player p, String title, String accept, String message, String decline, JavaPlugin plugin, Callback<Boolean> callback) {
        super(p, title, 9, plugin, false);
        this.callback = callback;
        this.accept = accept;
        this.message = message;
        this.decline = decline;
        this.initialize(p);
    }

    public ConfirmGUI(Player p, String title, String accept, String message, String decline, final JavaPlugin plugin, Callback<Boolean> callback, Runnable close) {
        super(p, title, 9, plugin, false);
        this.callback = callback;
        this.close = close;
        this.accept = accept;
        this.message = message;
        this.decline = decline;
        this.addListener(new InterfaceListener(){
            boolean run = false;

            @Override
            public void onInvClickEvent(InventoryClickEvent e) {
            }

            @Override
            public void onInvOpenEvent(InventoryOpenEvent e) {
            }

            @Override
            public void onInvCloseEvent(InventoryCloseEvent e) {
                if (this.run) {
                    return;
                }
                this.run = true;
                if (ConfirmGUI.this.close != null) {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, ConfirmGUI.this.close, 1L);
                }
            }

            @Override
            public void onInvDragEvent(InventoryDragEvent e) {
            }
        });
        this.initialize(p);
    }

    @Override
    public void initialize(Player p) {
        ItemButtonOption option = new ItemButtonOption();
        option.setClickSound(Sound.UI_BUTTON_CLICK.parseSound());
        option.setOnlyLeftClick(true);
        option.setCloseOnClick(true);
        this.addButton(new ItemButton(2, new ItemBuilder(XMaterial.LIME_TERRACOTTA).setName(this.accept).getItem()){

            @Override
            public void onClick(InventoryClickEvent e) {
                ConfirmGUI.this.callback.accept(true);
            }
        }.setOption(option));
        List<String> lines = TextAlignment.lineBreak(this.message, 80);
        this.setItem(4, new ItemBuilder(Material.NETHER_STAR).setName(lines.remove(0)).setLore(lines).getItem());
        this.addButton(new ItemButton(6, new ItemBuilder(XMaterial.RED_TERRACOTTA).setName(this.decline).getItem()){

            @Override
            public void onClick(InventoryClickEvent e) {
                ConfirmGUI.this.callback.accept(false);
            }
        }.setOption(option));
    }
}

