/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple.SyncButton;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;

public abstract class SyncTriggerButton
extends SyncButton {
    private ClickType[] trigger;
    private ClickType lastTrigger = null;

    public SyncTriggerButton(int slot) {
        super(slot);
    }

    public SyncTriggerButton(int x, int y) {
        this(x + y * 9);
    }

    public SyncTriggerButton(int slot, ClickType ... trigger) {
        super(slot);
        this.trigger = trigger;
    }

    public SyncTriggerButton(int x, int y, ClickType ... trigger) {
        this(x + y * 9);
        this.trigger = trigger;
    }

    public ClickType getLastTrigger() {
        return this.lastTrigger;
    }

    @Override
    public void onClick(InventoryClickEvent e, Player player) {
        boolean triggered;
        boolean bl = triggered = this.trigger == null || this.trigger.length == 0;
        if (!triggered) {
            for (ClickType clickType : this.trigger) {
                if (e.getClick() != clickType) continue;
                triggered = true;
                this.lastTrigger = clickType;
                break;
            }
        }
        if (triggered) {
            this.onTrigger(e, e.getClick(), player);
        } else {
            this.onOtherClick(e);
        }
    }

    public abstract void onTrigger(InventoryClickEvent var1, ClickType var2, Player var3);

    public void onOtherClick(InventoryClickEvent e) {
    }
}

