/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple;

import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilClickEvent;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilCloseEvent;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilGUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilSlot;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple.SyncTriggerButton;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class SyncAnvilGUIButton
extends SyncTriggerButton {
    private boolean onlyOutputTrigger = true;
    private AnvilGUI gui;

    public SyncAnvilGUIButton(int slot) {
        super(slot);
    }

    public SyncAnvilGUIButton(int x, int y) {
        this(x + 9 * y);
    }

    public SyncAnvilGUIButton(int slot, ClickType ... trigger) {
        super(slot, trigger);
    }

    public SyncAnvilGUIButton(int x, int y, ClickType ... trigger) {
        this(x + 9 * y, trigger);
    }

    @Override
    public void onTrigger(InventoryClickEvent e, ClickType trigger, final Player player) {
        if (!this.canTrigger(e, trigger, player)) {
            return;
        }
        this.getInterface().setClosingByButton(true);
        this.getInterface().setClosingForGUI(true);
        ItemStack anvilItem = this.craftAnvilItem(trigger);
        this.gui = AnvilGUI.openAnvil(this.getInterface().getPlugin(), player, new AnvilListener(){

            @Override
            public void onClick(AnvilClickEvent e) {
                e.setCancelled(true);
                e.setClose(false);
                if (SyncAnvilGUIButton.this.onlyOutputTrigger && e.getSlot() != AnvilSlot.OUTPUT) {
                    return;
                }
                SyncAnvilGUIButton.this.playSound(e.getClickType(), player);
                SyncAnvilGUIButton.this.onClick(e);
            }

            @Override
            public void onClose(AnvilCloseEvent e) {
                SyncAnvilGUIButton.this.onClose(e);
                if (e.getPost() == null) {
                    SyncAnvilGUIButton.this.getInterface().reinitialize();
                    e.setPost(() -> SyncAnvilGUIButton.this.getInterface().open());
                }
            }
        }, anvilItem);
    }

    public boolean canTrigger(InventoryClickEvent e, ClickType trigger, Player player) {
        return true;
    }

    @Override
    public void update(boolean updateGUI) {
        super.update(updateGUI);
    }

    public boolean interrupt() {
        return false;
    }

    public abstract void onClick(AnvilClickEvent var1);

    public abstract void onClose(AnvilCloseEvent var1);

    @Override
    public abstract ItemStack craftItem();

    public abstract ItemStack craftAnvilItem(ClickType var1);

    public boolean isOnlyOutputTrigger() {
        return this.onlyOutputTrigger;
    }

    public void setOnlyOutputTrigger(boolean onlyOutputTrigger) {
        this.onlyOutputTrigger = onlyOutputTrigger;
    }

    public AnvilGUI getAnvilGUI() {
        return this.gui;
    }
}

