/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple.Button;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple.Layout;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple.SimpleGUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple.SyncButton;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public abstract class Page {
    private String title;
    private final Layout layout;
    private final List<Button> buttons = new ArrayList<Button>();
    private SimpleGUI last;

    public Page(Player p, String title, Layout layout) {
        this(p, title, layout, true);
    }

    public Page(Player p, String title) {
        this(p, title, null, true);
    }

    public Page(Player p, String title, boolean preInitialize) {
        this(p, title, null, preInitialize);
    }

    public Page(Player p, String title, Layout layout, boolean preInitialize) {
        this.title = title;
        this.layout = layout;
        if (preInitialize) {
            this.initialize(p);
        }
    }

    public abstract void initialize(Player var1);

    public boolean initialize(SimpleGUI gui) {
        this.last = gui;
        boolean haveToBeReopened = false;
        if (this.title != null && !gui.getTitle().equals(this.title)) {
            gui.setTitle(this.title, false);
            haveToBeReopened = gui.isOpen();
        }
        gui.clear();
        if (gui.getLayout() != null && gui.getLayout().initialize(gui)) {
            haveToBeReopened = true;
        }
        if (this.layout != null && this.layout.initialize(gui)) {
            haveToBeReopened = true;
        }
        for (Button button : this.buttons) {
            gui.addButton(button);
        }
        return haveToBeReopened;
    }

    public Button getButton(int slot) {
        for (Button button : this.buttons) {
            if (button.getSlot() != slot) continue;
            return button;
        }
        return null;
    }

    public void close() {
        if (this.last != null) {
            this.last.close();
        }
    }

    public Button getButton(int x, int y) {
        return this.getButton(x + y * 9);
    }

    public Button removeButton(int slot) {
        Button button = this.getButton(slot);
        if (button != null) {
            this.buttons.remove(button);
        }
        return button;
    }

    public Button removeButton(int x, int y) {
        return this.removeButton(x + y * 9);
    }

    public void addButton(Button button) {
        this.removeButton(button.getSlot());
        this.buttons.add(button);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title, boolean reopen) {
        this.title = title;
        if (this.getLast() != null && reopen && this.initialize(this.getLast())) {
            this.getLast().updateTitle();
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void updatePage() {
        for (Button button : this.buttons) {
            if (!(button instanceof SyncButton)) continue;
            ((SyncButton)button).update();
        }
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public void onExitByPlayer() {
    }

    public SimpleGUI getLast() {
        return this.last;
    }
}

