/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple;

import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilClickEvent;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilCloseEvent;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilGUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.simple.Button;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AnvilGUIButton
extends Button {
    private final ItemStack anvilItem;
    private final ClickType trigger;

    public AnvilGUIButton(int slot, ItemStack item, ItemStack anvilItem) {
        super(slot, item);
        this.anvilItem = anvilItem;
        this.trigger = null;
    }

    public AnvilGUIButton(int x, int y, ItemStack item, ItemStack anvilItem) {
        super(x, y, item);
        this.anvilItem = anvilItem;
        this.trigger = null;
    }

    public AnvilGUIButton(int slot, ItemStack item, ItemStack anvilItem, ClickType trigger) {
        super(slot, item);
        this.anvilItem = anvilItem;
        this.trigger = trigger;
    }

    public AnvilGUIButton(int x, int y, ItemStack item, ItemStack anvilItem, ClickType trigger) {
        super(x, y, item);
        this.anvilItem = anvilItem;
        this.trigger = trigger;
    }

    @Override
    public void onClick(InventoryClickEvent e, Player player) {
        if (this.interrupt()) {
            return;
        }
        if (this.trigger == null || e.getClick() == this.trigger) {
            this.getInterface().setClosingByButton(true);
            this.getInterface().setClosingForGUI(true);
            AnvilGUI.openAnvil(this.getInterface().getPlugin(), player, new AnvilListener(){

                @Override
                public void onClick(AnvilClickEvent e) {
                    e.setCancelled(true);
                    e.setClose(false);
                    AnvilGUIButton.this.onClick(e);
                }

                @Override
                public void onClose(AnvilCloseEvent e) {
                    AnvilGUIButton.this.onClose(e);
                    if (e.getPost() == null) {
                        AnvilGUIButton.this.getInterface().reinitialize();
                        e.setPost(() -> AnvilGUIButton.this.getInterface().open());
                        AnvilGUIButton.this.getInterface().setClosingForGUI(false);
                    }
                }
            }, this.anvilItem);
        } else {
            this.onOtherClick(e);
        }
    }

    public boolean interrupt() {
        return false;
    }

    public void onOtherClick(InventoryClickEvent e) {
    }

    public abstract void onClick(AnvilClickEvent var1);

    public abstract void onClose(AnvilCloseEvent var1);
}

