/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui;

import de.codingair.tradesystem.lib.codingapi.player.gui.GUIListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.InventoryUtils;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.InterfaceBackup;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.InterfaceListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.ItemAlignment;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.itembutton.ItemButton;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

@Deprecated
public class Interface {
    public static final List<Interface> interfaces = new ArrayList<Interface>();
    Inventory inventory;
    private List<InterfaceListener> listener = new ArrayList<InterfaceListener>();
    private HashMap<Integer, ItemButton> buttons = new HashMap();
    private HashMap<Integer, InterfaceBackup> backups = new HashMap();
    private List<Player> currentPlayers = new ArrayList<Player>();
    private String wrappersName = null;
    private boolean editableItems = true;
    private String oldTitle;
    private String title;
    boolean oldUsage = true;
    private final Plugin plugin;

    @Deprecated
    public Interface(InventoryHolder owner, String title, int size, Plugin plugin) {
        this.title = title;
        if (this.title.length() > 32 && !Version.get().isBiggerThan(Version.v1_8)) {
            this.title = this.title.substring(0, 32);
        }
        this.oldTitle = this.getTitle();
        this.inventory = Bukkit.createInventory((InventoryHolder)owner, (int)size, (String)this.oldTitle);
        if (plugin != null && !GUIListener.isRegistered()) {
            GUIListener.register(plugin);
        }
        this.plugin = plugin;
    }

    public void addListener(InterfaceListener listener) {
        this.listener.add(listener);
    }

    public List<InterfaceListener> getListener() {
        return this.listener;
    }

    public void clearListeners() {
        this.listener = new ArrayList<InterfaceListener>();
    }

    @Deprecated
    public void addButton(int slot, ItemButton button) {
        this.buttons.remove(slot);
        this.buttons.put(slot, button);
        button.setSlot(slot);
        button.setInterface(this);
        this.setItem(slot, button.getItem());
    }

    public void addButton(ItemButton button) {
        this.buttons.remove(button.getSlot());
        this.buttons.put(button.getSlot(), button);
        button.setInterface(this);
        this.setItem(button.getSlot(), button.getItem());
    }

    public void setItem(ItemStack item, int startSlot, int endSlot) {
        for (int i = startSlot; i <= endSlot; ++i) {
            this.setItem(i, item);
        }
    }

    public ItemButton removeButton(int slot) {
        return this.buttons.remove(slot);
    }

    public Interface removeAllButtons() {
        for (Integer slot : this.buttons.keySet()) {
            this.setItem(slot, new ItemStack(Material.AIR));
        }
        this.buttons.clear();
        return this;
    }

    public ItemButton removeButton(ItemButton button) {
        return this.buttons.remove(button);
    }

    public void clearButtons() {
        this.buttons = new HashMap();
    }

    public InterfaceBackup getBackup(int id) {
        return this.backups.get(id);
    }

    public InterfaceBackup removeBackup(int id) {
        return this.backups.remove(id);
    }

    public void setFrame(ItemStack item) {
        int i;
        for (i = 0; i < 9; ++i) {
            this.setItem(i, 0, item.clone());
        }
        for (i = 0; i < 9; ++i) {
            this.setItem(i, this.getSize() / 9 - 1, item.clone());
        }
        for (i = 1; i < this.getSize() / 9 - 1; ++i) {
            this.setItem(0, i, item.clone());
        }
        for (i = 1; i < this.getSize() / 9 - 1; ++i) {
            this.setItem(8, i, item.clone());
        }
    }

    public void backupContent(int id) {
        this.backups.remove(id);
        ItemStack[] backup = new ItemStack[this.getSize()];
        int i = 0;
        for (ItemStack item : this.getContents()) {
            backup[i] = item == null ? new ItemStack(Material.AIR) : item.clone();
            ++i;
        }
        this.backups.put(id, new InterfaceBackup(backup, this.getButtons(), this.wrappersName));
    }

    public boolean restoreBackup(int id) {
        InterfaceBackup backup = this.backups.get(id);
        if (backup == null) {
            return false;
        }
        this.setSize(backup.getContents().length);
        this.setContents(backup.getContents());
        this.buttons = backup.getButtons();
        this.wrappersName = backup.getWrappersName();
        return true;
    }

    public void clearBackups() {
        this.backups = new HashMap();
    }

    public ItemButton getButtonAt(int slot) {
        return this.buttons.get(slot);
    }

    public ItemButton getButton(ItemStack item) {
        for (ItemButton button : this.buttons.values()) {
            if (!button.getItem().equals((Object)item)) continue;
            return button;
        }
        return null;
    }

    public void updateButton(int slot, ItemButton button) {
        for (int slots : this.buttons.keySet()) {
            if (!this.buttons.get(slots).equals(button)) continue;
            this.buttons.remove(slots);
            this.buttons.put(slot, button);
            break;
        }
    }

    public HashMap<Integer, ItemButton> getButtons() {
        return this.buttons;
    }

    public void setBackground(ItemStack background) {
        for (int slot = 0; slot < this.getSize(); ++slot) {
            if (this.getItem(slot) == null) {
                this.setItem(slot, background.clone());
                continue;
            }
            if (!this.getItem(slot).getType().equals((Object)Material.AIR)) continue;
            this.setItem(slot, background.clone());
        }
    }

    public Interface setDisplayname(int slot, String name) {
        ItemStack item = this.getItem(slot).clone();
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        this.clear(slot);
        this.setItem(slot, item);
        return this;
    }

    public Interface setLore(int slot, String ... lore) {
        ItemStack item = this.getItem(slot).clone();
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> finalLore = new ArrayList<String>();
        for (String line : lore) {
            if (!line.startsWith("\u00a7")) {
                line = line + "\u00a7f";
            }
            finalLore.add(line);
        }
        meta.setLore(finalLore);
        item.setItemMeta(meta);
        this.clear(slot);
        this.setItem(slot, item);
        return this;
    }

    public Interface setAmount(int slot, int amount) {
        ItemStack item = this.getItem(slot).clone();
        item.setAmount(amount);
        this.clear(slot);
        this.setItem(slot, item);
        return this;
    }

    public boolean setSize(int size) {
        if (this.getSize() == size) {
            return true;
        }
        double s = size;
        double res = s / 9.0;
        String resS = (res *= 100.0) + "";
        if (!resS.endsWith("00") && !resS.endsWith("0") || size > 54) {
            return false;
        }
        ItemStack[] contents = this.getContents();
        ItemStack[] newContents = new ItemStack[size];
        int i = 0;
        for (ItemStack item : contents) {
            if (i >= size) break;
            newContents[i] = item;
            ++i;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this.getHolder(), (int)size, (String)this.getTitle());
        this.setContents(newContents);
        return true;
    }

    void rebuildInventory() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this.getHolder(), (int)this.getSize(), (String)this.getTitle());
        inventory.setContents(this.inventory.getContents());
        if (Version.get().isBiggerThan(Version.v1_9)) {
            inventory.setStorageContents(this.inventory.getStorageContents());
        }
        inventory.setMaxStackSize(this.inventory.getMaxStackSize());
        this.inventory = inventory;
    }

    public boolean isOldTitle(String title) {
        return this.oldTitle.equals(title);
    }

    public void setTitle(String title, boolean update) {
        if (title == null || title.equals(this.title)) {
            return;
        }
        this.title = title;
        if (this.title.length() > 32 && !Version.get().isBiggerThan(Version.v1_8)) {
            this.title = this.title.substring(0, 32);
        }
        if (update) {
            this.updateTitle();
        }
    }

    public void setTitle(String title) {
        this.setTitle(title, true);
    }

    public void updateTitle() {
        this.updateTitle(false);
    }

    public void updateTitle(boolean force) {
        if (!force && this.isOldTitle(this.title)) {
            return;
        }
        if (this instanceof GUI) {
            ((GUI)this).isClosed = false;
        }
        this.currentPlayers.forEach(p -> InventoryUtils.updateTitle(p, this.title, this.inventory));
        this.oldTitle = this.title;
    }

    private Object getContainerType(int size) {
        IReflection.FieldAccessor generic = IReflection.getField(InventoryUtils.CONTAINERS_CLASS, "GENERIC_9X" + size / 9);
        return generic.get(null);
    }

    public int getItemAmount() {
        int i = 0;
        for (ItemStack item : this.getContents()) {
            if (item == null || item.getType().equals((Object)Material.AIR)) continue;
            ++i;
        }
        return i;
    }

    public boolean isFull() {
        return this.getItemAmount() >= this.getSize();
    }

    public String getWrappersName() {
        return this.wrappersName;
    }

    public void setWrappersName(String wrappersName) {
        this.wrappersName = wrappersName;
    }

    public void clearContent() {
        this.setBackground(new ItemStack(Material.AIR));
    }

    public boolean isEditableItems() {
        return this.editableItems;
    }

    public void setEditableItems(boolean editableItems) {
        this.editableItems = editableItems;
    }

    public void open(Player p) {
        this.addToPlayerList(p);
        this.setTitle(this.title, false);
        if (this.oldUsage) {
            interfaces.add(this);
        }
        Bukkit.getScheduler().runTask(this.plugin, () -> p.openInventory(this.inventory));
    }

    protected void addToPlayerList(Player player) {
        this.currentPlayers.add(player);
    }

    public void close(Player p) {
        this.close(p, false);
    }

    public void close(Player p, boolean isClosing) {
        Player o = null;
        for (Player current : this.currentPlayers) {
            if (!current.getName().equals(p.getName())) continue;
            o = current;
        }
        if (o == null) {
            return;
        }
        ArrayList<Player> current = new ArrayList<Player>(this.currentPlayers);
        current.remove(o);
        this.currentPlayers = current;
        if (this.oldUsage) {
            interfaces.remove(this);
        }
        if (!isClosing) {
            p.closeInventory();
        }
    }

    public boolean isUsing(Player p) {
        for (Player current : this.currentPlayers) {
            if (!current.getName().equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public void setAlignment(ItemAlignment alignment) {
        block21: {
            block22: {
                block20: {
                    if (!alignment.equals((Object)ItemAlignment.LEFT)) break block20;
                    for (int i = 0; i < 6; ++i) {
                        int slot = 9 * i;
                        for (ItemStack stack : this.getItemsFromRow(i)) {
                            if (stack == null || stack.getType().equals((Object)Material.AIR)) continue;
                            this.setItem(slot, stack);
                            ++slot;
                        }
                    }
                    break block21;
                }
                if (!alignment.equals((Object)ItemAlignment.RIGHT)) break block22;
                for (int i = 0; i < 6; ++i) {
                    List<ItemStack> items = this.getItemsFromRow(i);
                    ArrayList<ItemStack> clone = new ArrayList<ItemStack>();
                    clone.addAll(items);
                    clone.forEach(item -> {
                        if (item == null || item.getType().equals((Object)Material.AIR)) {
                            items.remove(item);
                        }
                    });
                    if (items.size() == 0) {
                        return;
                    }
                    for (int slot = 8 + 8 * i; slot >= 9 * i; --slot) {
                        ItemStack item2 = items.get(items.size() - 1);
                        items.remove(item2);
                        this.setItem(slot, item2);
                    }
                }
                break block21;
            }
            if (!alignment.equals((Object)ItemAlignment.CENTER)) break block21;
            for (int i = 0; i < this.getSize() / 9; ++i) {
                int[] slots;
                List<ItemButton> buttons = this.getButtonsFromRow(i);
                List<ItemStack> items = this.getItemsFromRow(i);
                int amount = 0;
                for (ItemStack item3 : items) {
                    if (item3 == null || item3.getType().equals((Object)Material.AIR)) continue;
                    ++amount;
                }
                if (amount == 0) continue;
                switch (amount) {
                    case 9: {
                        slots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
                        break;
                    }
                    case 8: {
                        slots = new int[]{0, 1, 2, 3, 5, 6, 7, 8};
                        break;
                    }
                    case 7: {
                        slots = new int[]{1, 2, 3, 4, 5, 6, 7};
                        break;
                    }
                    case 6: {
                        slots = new int[]{1, 2, 3, 5, 6, 7};
                        break;
                    }
                    case 5: {
                        slots = new int[]{1, 2, 4, 6, 7};
                        break;
                    }
                    case 4: {
                        slots = new int[]{1, 3, 5, 7};
                        break;
                    }
                    case 3: {
                        slots = new int[]{2, 4, 6};
                        break;
                    }
                    case 2: {
                        slots = new int[]{2, 6};
                        break;
                    }
                    case 1: {
                        slots = new int[]{4};
                        break;
                    }
                    default: {
                        slots = new int[]{};
                    }
                }
                int slot = 0;
                this.clearRow(i);
                for (int id = 0; id < 9; ++id) {
                    ItemStack item4 = items.get(id);
                    if (item4 == null) continue;
                    ItemButton b = buttons.get(id);
                    this.setItem(i * 9 + slots[slot], item4);
                    if (b != null) {
                        b.setSlot(i * 9 + slots[slot]);
                        b.updateInInterface();
                    }
                    ++slot;
                }
            }
        }
    }

    public List<ItemStack> getItemsFromRow(int row) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            if (row != i || this.getSize() < 9 + 9 * i) continue;
            for (int slot = 9 * i; slot < 9 + 9 * i; ++slot) {
                items.add(this.getItem(slot));
            }
        }
        return items;
    }

    public List<ItemButton> getButtonsFromRow(int row) {
        ArrayList<ItemButton> items = new ArrayList<ItemButton>();
        for (int i = 0; i < 6; ++i) {
            if (row != i || this.getSize() < 9 + 9 * i) continue;
            for (int slot = 9 * i; slot < 9 + 9 * i; ++slot) {
                items.add(this.getButtonAt(slot));
            }
        }
        return items;
    }

    public void clearRow(int row) {
        for (int i = 0; i < 6; ++i) {
            if (row != i || this.getSize() < 9 + 9 * i) continue;
            for (int slot = 9 * i; slot < 9 + 9 * i; ++slot) {
                this.setItem(slot, new ItemStack(Material.AIR));
            }
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack ... arg0) throws IllegalArgumentException {
        return this.inventory.addItem(arg0);
    }

    public HashMap<Integer, ? extends ItemStack> all(Material arg0) throws IllegalArgumentException {
        return this.inventory.all(arg0);
    }

    public HashMap<Integer, ? extends ItemStack> all(ItemStack arg0) {
        return this.inventory.all(arg0);
    }

    public void clear() {
        this.inventory.clear();
        this.buttons.clear();
    }

    public void clear(int arg0) {
        this.inventory.clear(arg0);
    }

    public boolean contains(Material arg0) throws IllegalArgumentException {
        return this.inventory.contains(arg0);
    }

    public boolean contains(ItemStack arg0) {
        return this.inventory.contains(arg0);
    }

    public boolean contains(Material arg0, int arg1) {
        return this.inventory.contains(arg0, arg1);
    }

    public boolean contains(ItemStack arg0, int arg1) {
        return this.inventory.contains(arg0, arg1);
    }

    public boolean containsAtLeast(ItemStack arg0, int arg1) {
        return this.inventory.containsAtLeast(arg0, arg1);
    }

    public int first(Material arg0) throws IllegalArgumentException {
        return this.inventory.first(arg0);
    }

    public int first(ItemStack arg0) {
        return this.inventory.first(arg0);
    }

    public int firstEmpty() {
        return this.inventory.firstEmpty();
    }

    public ItemStack[] getContents() {
        return this.inventory.getContents();
    }

    public InventoryHolder getHolder() {
        return this.inventory.getHolder();
    }

    public ItemStack getItem(int arg0) {
        return this.inventory.getItem(arg0);
    }

    public ItemStack getItem(int x, int y) {
        return this.inventory.getItem(x + 9 * y);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public String getName() {
        return this.title;
    }

    public InventoryType getType() {
        return this.inventory.getType();
    }

    public List<HumanEntity> getViewers() {
        return this.inventory.getViewers();
    }

    public ListIterator<ItemStack> iterator() {
        return this.inventory.iterator();
    }

    public ListIterator<ItemStack> iterator(int arg0) {
        return this.inventory.iterator(arg0);
    }

    public void remove(Material arg0) throws IllegalArgumentException {
        this.inventory.remove(arg0);
    }

    public void remove(ItemStack arg0) {
        this.inventory.remove(arg0);
    }

    public HashMap<Integer, ItemStack> removeItem(ItemStack ... arg0) throws IllegalArgumentException {
        return this.inventory.removeItem(arg0);
    }

    public void setContents(ItemStack[] arg0) throws IllegalArgumentException {
        this.inventory.setContents(arg0);
    }

    public void setItem(int x, ItemStack item) {
        try {
            ItemStack old = this.inventory.getItem(x);
            if (old != null && old.isSimilar(item) && old.getAmount() == item.getAmount()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.inventory.setItem(x, item);
    }

    public void setItem(int x, int y, ItemStack item) {
        this.setItem(x + 9 * y, item);
    }

    public void setMaxStackSize(int arg0) {
        this.inventory.setMaxStackSize(arg0);
    }

    public int getSize() {
        return this.inventory.getSize();
    }

    public String getTitle() {
        return this.title;
    }
}

