/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.GUIListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.Interface;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.InterfaceListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.itembutton.ItemButton;
import de.codingair.tradesystem.lib.codingapi.server.sounds.Sound;
import de.codingair.tradesystem.lib.codingapi.server.sounds.SoundData;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.tools.Callback;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

@Deprecated
public abstract class GUI
extends Interface
implements Removable {
    public static final HashMap<Player, Callback<GUI>> foreignConfirmations = new HashMap();
    private final UUID uniqueId = UUID.randomUUID();
    private final JavaPlugin plugin;
    private final Player player;
    private SoundData openSound = null;
    private SoundData cancelSound = null;
    private boolean closingByButton = false;
    private boolean closingByOperation = false;
    private boolean closingForGUI = false;
    private boolean moveOwnItems = true;
    private final List<Integer> movableSlots = new ArrayList<Integer>();
    private final List<GUIListener> listeners = new ArrayList<GUIListener>();
    private boolean canDropItems = false;
    protected boolean isClosed = false;
    private boolean buffering = false;
    private Callback<GUI> closingConfirmed = null;
    private GUI fallbackGUI = null;
    private boolean useFallbackGUI = false;
    protected boolean openForFirstTime = true;

    public GUI(Player p, String title, int size, JavaPlugin plugin) {
        this(p, title, size, plugin, true);
    }

    public GUI(Player p, String title, int size, JavaPlugin plugin, boolean preInitialize) {
        super((InventoryHolder)p, title, size, (Plugin)plugin);
        this.oldUsage = false;
        super.setEditableItems(false);
        this.plugin = plugin;
        this.player = p;
        super.addListener(new InterfaceListener(){

            @Override
            public void onInvClickEvent(InventoryClickEvent e) {
                GUI.this.listeners.forEach(l -> l.onInvClickEvent(e));
            }

            @Override
            public void onInvOpenEvent(InventoryOpenEvent e) {
                GUI.this.listeners.forEach(l -> l.onInvOpenEvent(e));
            }

            @Override
            public void onInvCloseEvent(InventoryCloseEvent e) {
                if (GUI.this.closingForGUI) {
                    return;
                }
                GUI.this.listeners.forEach(l -> l.onInvCloseEvent(e));
                if (GUI.this.useFallbackGUI && GUI.this.fallbackGUI != null) {
                    GUI fb = GUI.this.fallbackGUI;
                    fb.reinitialize();
                    Bukkit.getScheduler().runTaskLater((Plugin)GUI.this.getPlugin(), fb::open, 1L);
                }
            }

            @Override
            public void onClickBottomInventory(InventoryClickEvent e) {
                GUI.this.listeners.forEach(l -> l.onClickBottomInventory(e));
            }

            @Override
            public void onDropItem(InventoryClickEvent e) {
                GUI.this.listeners.forEach(l -> l.onDropItem(e));
            }

            @Override
            public void onInvDragEvent(InventoryDragEvent e) {
                GUI.this.listeners.forEach(l -> l.onInvDragEvent(e));
            }
        });
        this.setEditableItems(false);
        if (preInitialize) {
            this.initialize(p);
        }
    }

    public List<GUIListener> getGUIListeners() {
        return this.listeners;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void destroy() {
        this.close();
    }

    public abstract void initialize(Player var1);

    public void addListener(GUIListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GUIListener listener) {
        this.listeners.remove(listener);
    }

    public void reinitialize() {
        this.clear();
        this.initialize(this.player);
    }

    public void reinitialize(String title) {
        this.reinitialize();
        this.setTitle(title);
    }

    @Deprecated
    public void onClose(Player p) {
    }

    @Deprecated
    public void onOpen(Player p) {
    }

    @Override
    public void open(final Player p) {
        this.isClosed = true;
        this.closingByButton = false;
        this.closingByOperation = false;
        this.closingForGUI = false;
        Callback<GUI> run = new Callback<GUI>(){

            @Override
            public void accept(GUI old) {
                if (GUI.this.fallbackGUI == null) {
                    GUI.this.fallbackGUI = old;
                }
                if (GUI.this.openForFirstTime) {
                    if (GUI.this.getOpenSound() != null) {
                        GUI.this.getOpenSound().play(GUI.this.player);
                    }
                    GUI.this.openForFirstTime = false;
                }
                if (old != null) {
                    if (old.getSize() == GUI.this.getSize()) {
                        GUI.this.isClosed = old.isClosed;
                        old.isClosed = true;
                        GUI.this.inventory = old.getInventory();
                        GUI.this.reinitialize();
                        if (!GUI.this.isClosed && !old.getTitle().equals(GUI.this.getTitle())) {
                            GUI.super.addToPlayerList(GUI.this.getPlayer());
                            GUI.this.updateTitle(true);
                        }
                    }
                    old.closingConfirmed = null;
                    API.removeRemovable(old);
                }
                API.addRemovable(GUI.this);
                if (GUI.this.isClosed) {
                    GUI.this.isClosed = false;
                    GUI.super.open(p);
                }
            }
        };
        if (GUI.usesGUI(p)) {
            if (GUI.getGUI(p) == this) {
                return;
            }
            GUI gui = GUI.getGUI(p);
            if (gui.closingForGUI && gui.getSize() == this.getSize() || gui.isClosed) {
                run.accept(gui);
            } else {
                gui.closingConfirmed = run;
                gui.close();
            }
            return;
        }
        if (GUI.usesOldGUI(p)) {
            GUI.getOldGUI(p).close(p);
        } else if (p.getOpenInventory() != null && p.getOpenInventory().getTopInventory() != null && p.getOpenInventory().getTopInventory().getType() != InventoryType.CRAFTING) {
            foreignConfirmations.put(p, run);
            return;
        }
        run.accept(null);
    }

    public void open() {
        this.open(this.player);
    }

    @Override
    public void close(Player p, boolean isClosing) {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.closingByOperation = !isClosing;
        super.close(p, isClosing);
    }

    @Override
    public void close(Player p) {
        this.close(p, false);
    }

    public void close() {
        this.close(this.player);
    }

    public void confirmClosing() {
        API.removeRemovable(this);
        if (this.closingConfirmed != null) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> this.closingConfirmed.accept(this), 1L);
        }
    }

    public void setEditableSlots(boolean movable, Integer ... slots) {
        this.setEditableSlots(movable, Arrays.asList(slots));
    }

    public void setEditableSlots(boolean movable, List<Integer> slots) {
        if (movable) {
            for (int slot : slots) {
                if (this.movableSlots.contains(slot)) continue;
                this.movableSlots.add(slot);
            }
        } else {
            for (int slot : slots) {
                this.movableSlots.remove((Object)slot);
            }
        }
        Collections.sort(this.movableSlots);
    }

    public List<Integer> getMovableSlots() {
        return Collections.unmodifiableList(this.movableSlots);
    }

    public boolean isMovable(int slot) {
        return this.movableSlots.contains(slot);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public boolean isUsing(Player player) {
        return this.player.getName().equals(player.getName());
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public SoundData getCancelSound() {
        return this.cancelSound;
    }

    public GUI setCancelSound(Sound sound) {
        this.cancelSound = new SoundData(sound, 1.0f, 1.0f);
        return this;
    }

    public GUI setCancelSound(SoundData cancelSound) {
        this.cancelSound = cancelSound;
        return this;
    }

    public boolean isClosingByButton() {
        return this.closingByButton;
    }

    public void setClosingByButton(boolean closingByButton) {
        this.closingByButton = closingByButton;
    }

    public void changeGUI(GUI newGui) {
        this.closingForGUI = true;
        newGui.open();
    }

    public void changeGUI(GUI newGui, boolean fallback) {
        this.closingForGUI = true;
        newGui.setUseFallbackGUI(fallback);
        newGui.open();
    }

    protected void setInventory(Inventory inv) {
        this.inventory = inv;
    }

    public void addLine(int x0, int y0, int x1, int y1, ItemStack item, boolean override) {
        double cX = x0;
        double cY = y0;
        Vector v = new Vector(x1, y1, 0).subtract(new Vector(x0, y0, 0)).normalize();
        do {
            if (!override && this.getItem((int)cX, (int)cY) != null && !this.getItem((int)cX, (int)cY).getType().equals((Object)Material.AIR)) continue;
            this.setItem((int)cX, (int)cY, item.clone());
        } while ((int)(cX += v.getX()) != x1 || (int)(cY += v.getY()) != y1);
        if (override || this.getItem((int)cX, (int)cY) == null || this.getItem((int)cX, (int)cY).getType().equals((Object)Material.AIR)) {
            this.setItem((int)cX, (int)cY, item.clone());
        }
    }

    @Override
    public void addButton(int slot, ItemButton button) {
        super.addButton(slot, button);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
    }

    @Override
    public HashMap<Integer, ItemStack> addItem(ItemStack ... arg0) throws IllegalArgumentException {
        HashMap<Integer, ItemStack> map = super.addItem(arg0);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
        return map;
    }

    @Override
    public void addButton(ItemButton button) {
        super.addButton(button);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
    }

    @Override
    public void setItem(ItemStack item, int startSlot, int endSlot) {
        super.setItem(item, startSlot, endSlot);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
    }

    @Override
    public void setFrame(ItemStack item) {
        super.setFrame(item);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
    }

    @Override
    public void setBackground(ItemStack background) {
        super.setBackground(background);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
    }

    @Override
    public Interface setDisplayname(int slot, String name) {
        super.setDisplayname(slot, name);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
        return this;
    }

    @Override
    public Interface setLore(int slot, String ... lore) {
        super.setLore(slot, lore);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
        return this;
    }

    @Override
    public Interface setAmount(int slot, int amount) {
        super.setAmount(slot, amount);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
        return this;
    }

    @Override
    public boolean setSize(int size) {
        boolean result = super.setSize(size);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
        return result;
    }

    @Override
    public void setTitle(String title, boolean update) {
        if (this.isOldTitle(title)) {
            return;
        }
        boolean isOpened = this.isOpen();
        super.setTitle(title, update && isOpened);
        if (!isOpened) {
            this.rebuildInventory();
        }
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
    }

    @Override
    public void setTitle(String title) {
        this.setTitle(title, true);
    }

    @Override
    public void setContents(ItemStack[] arg0) throws IllegalArgumentException {
        super.setContents(arg0);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
    }

    @Override
    public void setItem(int x, ItemStack item) {
        super.setItem(x, item);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
    }

    @Override
    public void setItem(int x, int y, ItemStack item) {
        super.setItem(x, y, item);
        if (!this.buffering) {
            GUI.updateInventory(this.player);
        }
    }

    public ItemButton getButtonAt(int x, int y) {
        return this.getButtonAt(x + y * 9);
    }

    public static GUI getGUI(Player p) {
        GUI g = API.getRemovable(p, GUI.class);
        return g;
    }

    public boolean isOpen() {
        return GUI.getGUI(this.getPlayer()) == this;
    }

    public static Interface getOldGUI(Player p) {
        for (Interface i : interfaces) {
            if (!i.isUsing(p)) continue;
            return i;
        }
        return null;
    }

    public static boolean usesGUI(Player p) {
        return GUI.getGUI(p) != null;
    }

    public static boolean usesOldGUI(Player p) {
        return GUI.getOldGUI(p) != null;
    }

    public SoundData getOpenSound() {
        return this.openSound;
    }

    public GUI setOpenSound(SoundData openSound) {
        this.openSound = openSound;
        return this;
    }

    public boolean isMoveOwnItems() {
        return this.moveOwnItems;
    }

    public void setMoveOwnItems(boolean moveOwnItems) {
        this.moveOwnItems = moveOwnItems;
    }

    public boolean isCanDropItems() {
        return this.canDropItems;
    }

    public void setCanDropItems(boolean canDropItems) {
        this.canDropItems = canDropItems;
    }

    public boolean isClosingByOperation() {
        return this.closingByOperation;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isBuffering() {
        return this.buffering;
    }

    public void setBuffering(boolean buffering) {
        this.buffering = buffering;
    }

    public void release() {
        GUI.updateInventory(this.getPlayer());
    }

    public boolean useFallbackGUI() {
        return this.useFallbackGUI;
    }

    public GUI setUseFallbackGUI(boolean useFallbackGUI) {
        this.useFallbackGUI = useFallbackGUI;
        return this;
    }

    public GUI setFallbackGUI(GUI fallbackGUI) {
        this.fallbackGUI = fallbackGUI;
        return this;
    }

    public GUI getFallbackGUI() {
        return this.fallbackGUI;
    }

    public boolean fallBack() {
        if (this.fallbackGUI == null) {
            return false;
        }
        this.useFallbackGUI = false;
        this.fallbackGUI.reinitialize();
        this.changeGUI(this.fallbackGUI);
        return true;
    }

    public boolean isClosingForGUI() {
        return this.closingForGUI;
    }

    public void setClosingForGUI(boolean closingForGUI) {
        this.closingForGUI = closingForGUI;
    }

    public static boolean updateInventory(Player player) {
        if (Version.get().isBiggerThan(Version.v1_13)) {
            return false;
        }
        player.updateInventory();
        return true;
    }
}

