/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.inventory;

import de.codingair.tradesystem.lib.codingapi.nms.NmsLoader;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerInventory {
    private static IReflection.FieldAccessor<ItemMeta> META = null;
    private final Player player;
    private final ItemStack[] content;
    private final ItemStack[] armor;
    private final int heldSlot;
    private final boolean exact;
    private final Map<Integer, Integer> type = new HashMap<Integer, Integer>();
    private Integer emptySlot = 0;

    @NmsLoader
    private PlayerInventory() {
        this((ItemStack[])null);
    }

    public PlayerInventory(Player player) {
        this(player, true);
    }

    public PlayerInventory(Player player, boolean exact) {
        this.player = player;
        this.exact = exact;
        this.content = new ItemStack[36];
        if (exact) {
            for (int i = 0; i < 36; ++i) {
                this.content[i] = player.getInventory().getContents()[i] == null ? null : player.getInventory().getContents()[i].clone();
            }
        } else {
            for (int i = 0; i < 36; ++i) {
                ItemStack item;
                ItemStack itemStack = item = player.getInventory().getContents()[i] == null ? null : player.getInventory().getContents()[i].clone();
                if (item == null || item.getType() == Material.AIR) continue;
                this.optimizedAddUntilPossible(item);
            }
        }
        this.armor = (ItemStack[])player.getInventory().getArmorContents().clone();
        this.heldSlot = player.getInventory().getHeldItemSlot();
    }

    public PlayerInventory(ItemStack[] content) {
        this.player = null;
        this.exact = true;
        this.content = content;
        this.armor = null;
        this.heldSlot = 0;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void restore() {
        this.player.getInventory().clear();
        this.player.getInventory().setContents((ItemStack[])this.content.clone());
        this.player.getInventory().setArmorContents((ItemStack[])this.armor.clone());
        this.player.getInventory().setHeldItemSlot(this.heldSlot);
        this.player.updateInventory();
    }

    public ItemStack[] getContent() {
        return this.content;
    }

    public ItemStack[] getArmor() {
        return this.armor;
    }

    public int addUntilPossible(@NotNull ItemStack item) {
        return this.addUntilPossible(item, true);
    }

    public int addUntilPossible(@NotNull ItemStack item, boolean stackBeforeAddingToEmptySlot) {
        if (this.exact) {
            return this.naiveAddUntilPossible(item, stackBeforeAddingToEmptySlot);
        }
        return this.optimizedAddUntilPossible(item);
    }

    public boolean addItem(@NotNull ItemStack item) {
        return this.addItem(item, true);
    }

    public boolean addItem(@NotNull ItemStack item, boolean stackBeforeAddingToEmptySlot) {
        return this.naiveAddUntilPossible(item, stackBeforeAddingToEmptySlot) == 0;
    }

    private int naiveAddUntilPossible(@NotNull ItemStack item, boolean stackBeforeAddingToEmptySlot) {
        item = item.clone();
        Integer empty = null;
        for (int slot = 0; slot < this.content.length; ++slot) {
            ItemStack other = this.content[slot];
            if (other == null || other.getType() == Material.AIR) {
                if (empty != null) continue;
                empty = slot;
                if (stackBeforeAddingToEmptySlot) continue;
                break;
            }
            if (other.getAmount() >= other.getMaxStackSize() || !other.isSimilar(item)) continue;
            this.stack(item, other);
            if (item.getAmount() > 0) continue;
            return 0;
        }
        if (empty == null) {
            return item.getAmount();
        }
        this.content[empty.intValue()] = item;
        return 0;
    }

    private int optimizedAddUntilPossible(@NotNull ItemStack itemStack) {
        boolean addedToEmptySlot;
        ItemStack item = itemStack.clone();
        Integer cacheEmptySlot = this.emptySlot;
        int hashCode = this.itemHashCode(item);
        this.type.compute(hashCode, (hash, slot) -> {
            boolean stillSpace;
            if (slot == null) {
                boolean isFull;
                boolean bl = isFull = this.emptySlot == null;
                if (isFull) {
                    return null;
                }
                this.content[this.emptySlot.intValue()] = item;
                Integer n = this.emptySlot;
                Integer n2 = this.emptySlot = Integer.valueOf(this.emptySlot + 1);
                return n;
            }
            ItemStack to = this.content[slot];
            boolean notFullyStacked = this.stack(item, to);
            boolean bl = stillSpace = this.emptySlot != null;
            if (notFullyStacked && stillSpace) {
                boolean isFull;
                this.content[this.emptySlot.intValue()] = item;
                slot = this.emptySlot;
                boolean bl2 = isFull = this.emptySlot + 1 == this.content.length;
                if (isFull) {
                    this.emptySlot = null;
                } else {
                    Integer n = this.emptySlot;
                    Integer n3 = this.emptySlot = Integer.valueOf(this.emptySlot + 1);
                }
            }
            return slot;
        });
        boolean bl = addedToEmptySlot = !Objects.equals(cacheEmptySlot, this.emptySlot);
        if (addedToEmptySlot) {
            return 0;
        }
        return item.getAmount();
    }

    private boolean stack(ItemStack from, ItemStack to) {
        int space = to.getMaxStackSize() - to.getAmount();
        int transport = Math.min(from.getAmount(), space);
        to.setAmount(to.getAmount() + transport);
        from.setAmount(from.getAmount() - transport);
        return from.getAmount() > 0;
    }

    private int itemHashCode(ItemStack item) {
        int hash = 1;
        hash = hash * 31 + item.getType().hashCode();
        hash = hash * 31 + (item.getDurability() & 0xFFFF);
        ItemMeta meta = null;
        if (item.hasItemMeta()) {
            if (META != null) {
                meta = META.get(item);
            }
            if (meta == null) {
                meta = item.getItemMeta();
            }
        }
        hash = hash * 31 + (meta == null ? 0 : meta.hashCode());
        return hash;
    }

    static {
        if (Version.before(21.0)) {
            META = IReflection.getField(ItemStack.class, ItemMeta.class, 0);
        }
    }
}

