/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.hotbar;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.gui.hotbar.EventListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.hotbar.components.ItemComponent;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.PlayerInventory;
import de.codingair.tradesystem.lib.codingapi.server.sounds.SoundData;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class HotbarGUI
implements Removable {
    private final UUID uniqueId = UUID.randomUUID();
    private final ItemComponent[] menu = new ItemComponent[9];
    private final Player player;
    private PlayerInventory backup;
    private SoundData clickSound;
    private SoundData openSound;
    private SoundData closeSound;
    private final JavaPlugin plugin;
    private long lastClick = 0L;
    private boolean waiting = false;
    private int startSlot = -1;
    private int lastTriggeredSlot = -1;
    private Runnable onFinish = null;

    public HotbarGUI(Player player, JavaPlugin plugin) {
        this.player = player;
        this.plugin = plugin;
        EventListener.register((Plugin)plugin);
    }

    public HotbarGUI(Player player, JavaPlugin plugin, int startSlot) {
        this(player, plugin);
        this.startSlot = startSlot;
    }

    public abstract void initialize();

    public boolean isOpened() {
        return API.getRemovable(this.player, this.getClass()) != null;
    }

    public void open(boolean sound) {
        this.lastClick = System.currentTimeMillis();
        List<HotbarGUI> l = API.getRemovables(this.player, HotbarGUI.class);
        for (HotbarGUI gui : l) {
            gui.setWaiting(true);
            this.backup = gui.getBackup();
            gui.destroy();
        }
        l.clear();
        if (this.backup == null) {
            this.backup = new PlayerInventory(this.player);
        }
        this.waiting = false;
        this.player.getInventory().clear();
        for (int i = 0; i < 9; ++i) {
            if (this.menu[i] == null) continue;
            this.player.getInventory().setItem(i, this.menu[i].getItem());
        }
        if (this.startSlot >= 0 && this.startSlot <= 8) {
            this.player.getInventory().setHeldItemSlot(this.startSlot);
        }
        this.player.updateInventory();
        if (this.openSound != null && sound) {
            this.openSound.play(this.player);
        }
        API.addRemovable(this);
        ItemComponent ic = this.getItem(this.player.getInventory().getHeldItemSlot());
        if (ic != null && ic.getAction() != null) {
            ic.getAction().onHover(this, null, ic, this.player);
        }
    }

    public void close(boolean sound) {
        if (!this.waiting) {
            this.backup.restore();
        }
        if (this.closeSound != null && sound) {
            this.closeSound.play(this.player);
        }
        API.removeRemovable(this);
    }

    public int getSlot(ItemComponent ic) {
        for (int i = 0; i < 9; ++i) {
            if (this.menu[i] != ic) continue;
            return i;
        }
        return -999;
    }

    public void updateDisplayName(ItemComponent ic, String s) {
        int slot = this.getSlot(ic);
        if (slot == -999) {
            return;
        }
        ItemMeta meta = ic.getItem().getItemMeta();
        meta.setDisplayName(s);
        ic.getItem().setItemMeta(meta);
        this.updateSingle(slot);
    }

    public void commit(ItemComponent ic) {
        this.commit(this.getSlot(ic), ic);
    }

    public void commit(int slot, ItemComponent ic) {
        this.player.getInventory().setItem(slot, ic == null || ic.getItem() == null ? new ItemStack(Material.AIR) : ic.getItem());
    }

    public void updateLore(ItemComponent ic, List<String> list) {
        int slot = this.getSlot(ic);
        if (slot == -999) {
            return;
        }
        ItemMeta meta = ic.getItem().getItemMeta();
        meta.setLore(list);
        ic.getItem().setItemMeta(meta);
        this.updateSingle(slot);
    }

    public void updateSingle(int slot) {
        ItemComponent ic = this.getItem(slot);
        this.commit(slot, ic);
        if (ic.getAction() != null) {
            ic.getAction().onHover(this, ic, ic, this.player);
        }
    }

    public void update() {
        this.initialize();
        this.commit();
    }

    public void commit() {
        if (!this.isOpened()) {
            return;
        }
        this.player.getInventory().clear();
        for (int i = 0; i < 9; ++i) {
            if (this.menu[i] == null || this.menu[i].getItem() == null) {
                this.player.getInventory().setItem(i, new ItemStack(Material.AIR));
                continue;
            }
            this.player.getInventory().setItem(i, this.menu[i].getItem());
        }
    }

    public ItemComponent setItem(int slot, ItemComponent ic) {
        return this.setItem(slot, ic, true);
    }

    public ItemComponent setItem(int slot, ItemComponent ic, boolean update) {
        ItemComponent old = this.menu[slot];
        this.menu[slot] = ic;
        if (update) {
            this.commit();
        }
        return old;
    }

    public ItemComponent getItem(int slot) {
        if (this.menu.length <= slot || slot < 0) {
            return null;
        }
        return this.menu[slot];
    }

    public boolean addItem(ItemComponent ic) {
        for (int i = 0; i < 9; ++i) {
            if (this.menu[i] != null) continue;
            this.menu[i] = ic;
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        this.close(false);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public SoundData getClickSound() {
        return this.clickSound;
    }

    public void setClickSound(SoundData clickSound) {
        this.clickSound = clickSound;
    }

    public ItemComponent[] getMenu() {
        return this.menu;
    }

    public SoundData getOpenSound() {
        return this.openSound;
    }

    public void setOpenSound(SoundData openSound) {
        this.openSound = openSound;
    }

    public SoundData getCloseSound() {
        return this.closeSound;
    }

    public void setCloseSound(SoundData closeSound) {
        this.closeSound = closeSound;
    }

    public long getLastClick() {
        return this.lastClick;
    }

    public void setLastClick(long lastClick) {
        this.lastClick = lastClick;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }

    public int getStartSlot() {
        return this.startSlot;
    }

    public void setStartSlot(int startSlot) {
        this.startSlot = startSlot;
    }

    public int getLastTriggeredSlot() {
        return this.lastTriggeredSlot;
    }

    public void setLastTriggeredSlot(int lastTriggeredSlot) {
        this.lastTriggeredSlot = lastTriggeredSlot;
    }

    public Runnable getOnFinish() {
        return this.onFinish;
    }

    public void setOnFinish(Runnable onFinish) {
        this.onFinish = onFinish;
    }

    public PlayerInventory getBackup() {
        return this.backup;
    }

    public void setBackup(PlayerInventory backup) {
        this.backup = backup;
    }
}

