/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.hotbar;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.gui.hotbar.ClickType;
import de.codingair.tradesystem.lib.codingapi.player.gui.hotbar.HotbarGUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.hotbar.components.ItemComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;

public class EventListener
implements Listener {
    private static EventListener instance;
    private static boolean registered;

    public static void register(Plugin plugin) {
        if (registered) {
            return;
        }
        instance = new EventListener();
        Bukkit.getPluginManager().registerEvents((Listener)instance, plugin);
        registered = true;
    }

    public static EventListener getInstance() {
        return instance;
    }

    @EventHandler
    public void onSwitch(PlayerItemHeldEvent e) {
        HotbarGUI gui = API.getRemovable(e.getPlayer(), HotbarGUI.class);
        if (gui == null) {
            return;
        }
        ItemComponent oldSlot = gui.getItem(e.getPreviousSlot());
        ItemComponent newSlot = gui.getItem(e.getNewSlot());
        if (oldSlot != null && oldSlot.getAction() != null) {
            oldSlot.getAction().onUnhover(gui, oldSlot, newSlot, e.getPlayer());
        }
        if (newSlot != null && newSlot.getAction() != null) {
            newSlot.getAction().onHover(gui, oldSlot, newSlot, e.getPlayer());
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            Player p = (Player)e.getEntity();
            HotbarGUI gui = API.getRemovable(p, HotbarGUI.class);
            if (gui == null) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        HotbarGUI gui = API.getRemovable(e.getPlayer(), HotbarGUI.class);
        if (gui != null) {
            ItemComponent ic = gui.getMenu()[e.getPlayer().getInventory().getHeldItemSlot()];
            if (ic == null || ic.getItem() == null) {
                return;
            }
            e.setCancelled(true);
            if (System.currentTimeMillis() - gui.getLastClick() <= 50L) {
                return;
            }
            gui.setLastClick(System.currentTimeMillis());
            if (ic.getClickSound() != null && !ic.isSilent()) {
                ic.getClickSound().play(e.getPlayer());
            } else if (gui.getClickSound() != null && !ic.isSilent()) {
                gui.getClickSound().play(e.getPlayer());
            }
            if (ic.getAction() != null) {
                ic.getAction().onClick(gui, ic, e.getPlayer(), ClickType.getByAction(e.getAction(), e.getPlayer()));
            }
            if (ic.isCloseOnClick() && ic.getLink() == null) {
                gui.close(true);
                if (gui.getOnFinish() != null) {
                    gui.getOnFinish().run();
                }
                return;
            }
            if (ic.getLink() != null) {
                gui.setWaiting(true);
                gui.setLastTriggeredSlot(e.getPlayer().getInventory().getHeldItemSlot());
                gui.close(false);
                ic.getLink().setBackup(gui.getBackup());
                ic.getLink().open(false);
                ic.getLink().setLastClick(System.currentTimeMillis());
                if (ic.getLink().getLastTriggeredSlot() != -1 && ic.getLink().getStartSlot() == -1) {
                    e.getPlayer().getInventory().setHeldItemSlot(ic.getLink().getLastTriggeredSlot());
                }
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (API.getRemovable(e.getPlayer(), HotbarGUI.class) != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        if (API.getRemovable(e.getPlayer(), HotbarGUI.class) != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent e) {
        if (API.getRemovable(e.getPlayer(), HotbarGUI.class) != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInvClick(InventoryClickEvent e) {
        for (HotbarGUI h : API.getRemovables((Player)e.getWhoClicked(), HotbarGUI.class)) {
            h = API.getRemovable((Player)e.getWhoClicked(), HotbarGUI.class);
            if (h == null || h.getItem(e.getSlot()) == null) continue;
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            return;
        }
    }

    static {
        registered = false;
    }
}

