/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.anvil;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.nms.NmsLoader;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilClickEvent;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilCloseEvent;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilSlot;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.depended.PrepareAnvilEventHelp;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.InventoryUtils;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AnvilGUI
implements Removable {
    private static final Class<?> ENTITY_PLAYER_CLASS;
    private static final Class<?> PLAYER_INVENTORY_CLASS;
    private static final IReflection.MethodAccessor GET_WORLD;
    private static final IReflection.ConstructorAccessor BLOCK_POSITION_CON;
    private static final IReflection.MethodAccessor NEXT_CONTAINER_COUNTER;
    private static final Class<?> WORLD_CLASS;
    private static final Class<?> BLOCK_POSITION_CLASS;
    private static final IReflection.ConstructorAccessor ANVIL_CONTAINER_CON;
    private static final Class<?> CONTAINER_CLASS;
    private static final IReflection.FieldAccessor<Object> REACHABLE;
    private static final IReflection.MethodAccessor GET_TOP_INVENTORY;
    private static final IReflection.MethodAccessor GET_BUKKIT_VIEW;
    private static final Class<?> PACKET_PLAY_OUT_OPEN_WINDOW_CLASS;
    private static final Class<?> CHAT_MESSAGE_CLASS;
    private static final IReflection.ConstructorAccessor CHAT_MESSAGE_CON;
    private static final IReflection.FieldAccessor<InventoryType.SlotType> SLOT_TYPE_FIELD;
    private static final Function<Object, Object> GET_INVENTORY;
    private final UUID uniqueId = UUID.randomUUID();
    private final JavaPlugin plugin;
    private final Player player;
    private AnvilListener listener;
    private HashMap<AnvilSlot, ItemStack> items = new HashMap();
    private String submittedText = null;
    private boolean submitted = false;
    private boolean onlyWithChanges = true;
    private boolean keepSubmittedText = true;
    private AnvilCloseEvent closeEvent = null;
    private Listener bukkitListener;
    private PrepareAnvilEventHelp prepareListener;
    private Inventory inv;
    private String title;

    @NmsLoader
    private AnvilGUI() {
        this.plugin = null;
        this.player = null;
    }

    public AnvilGUI(JavaPlugin plugin, Player player, AnvilListener listener, String title) {
        this.plugin = plugin;
        this.player = player;
        this.listener = listener;
        this.title = title == null ? "Repair & Name" : title;
        this.registerBukkitListener();
        if (Version.get().isBiggerThan(8.0)) {
            this.prepareListener = new PrepareAnvilEventHelp();
            Bukkit.getPluginManager().registerEvents((Listener)this.prepareListener, (Plugin)this.plugin);
        }
    }

    public AnvilGUI(JavaPlugin plugin, Player player, AnvilListener listener) {
        this(plugin, player, listener, "Repair & Name");
    }

    public static AnvilGUI openAnvil(JavaPlugin plugin, Player p, AnvilListener listener, ItemStack item) {
        return new AnvilGUI(plugin, p, listener).setSlot(AnvilSlot.INPUT_LEFT, item).open();
    }

    public static AnvilGUI openAnvil(JavaPlugin plugin, Player p, AnvilListener listener, ItemStack item, String title) {
        return new AnvilGUI(plugin, p, listener, title).setSlot(AnvilSlot.INPUT_LEFT, item).open();
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void destroy() {
        if (this.remove()) {
            try {
                this.player.closeInventory();
            }
            catch (Throwable ex) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)this.player).closeInventory());
            }
        }
    }

    private void registerBukkitListener() {
        this.bukkitListener = new Listener(){
            private final Map<String, InventoryType.SlotType> slotType = new HashMap<String, InventoryType.SlotType>();

            @EventHandler(priority=EventPriority.LOWEST)
            public void onInventoryClickBefore(InventoryClickEvent e) {
                if (e.getWhoClicked() instanceof Player) {
                    Player p = (Player)e.getWhoClicked();
                    if (e.getInventory().equals(AnvilGUI.this.inv)) {
                        this.slotType.put(p.getName(), e.getSlotType());
                        SLOT_TYPE_FIELD.set(e, InventoryType.SlotType.OUTSIDE);
                    }
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST)
            public void onInventoryClick(InventoryClickEvent e) {
                if (e.getWhoClicked() instanceof Player) {
                    Player p = (Player)e.getWhoClicked();
                    if (e.getInventory().equals(AnvilGUI.this.inv)) {
                        SLOT_TYPE_FIELD.set(e, this.slotType.remove(p.getName()));
                        e.setCancelled(true);
                        ItemStack item = AnvilGUI.this.inv.getItem(AnvilSlot.OUTPUT.getSlot());
                        int slot = e.getRawSlot();
                        if (AnvilSlot.bySlot(slot) == AnvilSlot.OUTPUT && (item == null || item.getType() == Material.AIR) && AnvilGUI.this.onlyWithChanges) {
                            return;
                        }
                        AnvilClickEvent clickEvent = new AnvilClickEvent(p, e.getClick(), AnvilSlot.bySlot(slot), item, AnvilGUI.this);
                        if (AnvilGUI.this.listener != null) {
                            AnvilGUI.this.listener.onClick(clickEvent);
                        }
                        if (clickEvent.getSlot().equals((Object)AnvilSlot.OUTPUT)) {
                            AnvilGUI.this.submitted = true;
                            AnvilGUI.this.submittedText = clickEvent.getSubmitted() == null ? clickEvent.getInput() : clickEvent.getSubmitted();
                        }
                        e.setCancelled(clickEvent.isCancelled());
                        if (AnvilGUI.this.keepSubmittedText && AnvilGUI.this.submitted && item != null && item.hasItemMeta()) {
                            ItemMeta meta = item.getItemMeta();
                            assert (meta != null);
                            meta.setDisplayName(AnvilGUI.this.submittedText);
                            item.setItemMeta(meta);
                            AnvilGUI.this.inv.setItem(AnvilSlot.INPUT_LEFT.getSlot(), item);
                            p.updateInventory();
                        }
                        if (clickEvent.getWillClose()) {
                            AnvilGUI.this.close(clickEvent.isKeepInventory());
                            if (clickEvent.isKeepInventory()) {
                                this.onInventoryClose(new InventoryCloseEvent(e.getView()));
                            }
                        }
                        if (clickEvent.getSlot() == AnvilSlot.OUTPUT && !clickEvent.isPayExp()) {
                            p.setLevel(AnvilGUI.this.player.getLevel());
                        }
                    }
                }
            }

            @EventHandler
            public void onInventoryClose(InventoryCloseEvent e) {
                if (e.getPlayer() instanceof Player && e.getInventory().equals(AnvilGUI.this.inv)) {
                    if (AnvilGUI.this.closeEvent == null) {
                        AnvilGUI.this.closeEvent = new AnvilCloseEvent(AnvilGUI.this.player, AnvilGUI.this);
                        if (AnvilGUI.this.listener != null) {
                            AnvilGUI.this.listener.onClose(AnvilGUI.this.closeEvent);
                        }
                    }
                    AnvilGUI.this.inv.clear();
                    AnvilGUI.this.remove();
                    if (AnvilGUI.this.closeEvent.getPost() != null) {
                        Bukkit.getScheduler().runTask((Plugin)AnvilGUI.this.plugin, AnvilGUI.this.closeEvent.getPost());
                    }
                }
            }
        };
        Bukkit.getPluginManager().registerEvents(this.bukkitListener, (Plugin)this.plugin);
    }

    public AnvilGUI open() {
        Object container;
        API.addRemovable(this);
        this.player.closeInventory();
        Object entityPlayer = PacketUtils.getEntityPlayer(this.player);
        Object inventory = GET_INVENTORY.apply(entityPlayer);
        Object world = GET_WORLD.invoke(entityPlayer, new Object[0]);
        Object blockPosition = BLOCK_POSITION_CON.newInstance(0, 0, 0);
        int c = (Integer)NEXT_CONTAINER_COUNTER.invoke(entityPlayer, new Object[0]);
        if (Version.get().isBiggerThan(Version.v1_13)) {
            Class<?> containerAccessClass = IReflection.getClass(IReflection.ServerPacket.INVENTORY, "ContainerAccess");
            IReflection.MethodAccessor at = IReflection.getMethod(containerAccessClass, containerAccessClass, new Class[]{WORLD_CLASS, BLOCK_POSITION_CLASS});
            Object containerAccess = at.invoke(null, world, blockPosition);
            container = ANVIL_CONTAINER_CON.newInstance(c, inventory, containerAccess);
            IReflection.FieldAccessor<?> title = IReflection.getField(CONTAINER_CLASS, PacketUtils.IChatBaseComponentClass, 0);
            title.set(container, PacketUtils.getIChatBaseComponent(this.title));
        } else {
            container = ANVIL_CONTAINER_CON.newInstance(inventory, world, blockPosition, entityPlayer);
        }
        REACHABLE.set(container, false);
        this.inv = (Inventory)GET_TOP_INVENTORY.invoke(GET_BUKKIT_VIEW.invoke(container, new Object[0]), new Object[0]);
        if (this.prepareListener != null) {
            this.prepareListener.setInv(this.inv);
        }
        for (AnvilSlot slot : this.items.keySet()) {
            this.inv.setItem(slot.getSlot(), this.items.get((Object)slot));
        }
        try {
            if (Version.get().isBiggerThan(Version.v1_13)) {
                String genericField = Version.choose("ANVIL", 17.0, "h", 20.4, "i", 20.5, "ANVIL");
                IReflection.FieldAccessor generic = IReflection.getField(InventoryUtils.CONTAINERS_CLASS, genericField);
                IReflection.ConstructorAccessor packetPlayOutOpenWindowCon = IReflection.getConstructor(PACKET_PLAY_OUT_OPEN_WINDOW_CLASS, Integer.TYPE, InventoryUtils.CONTAINERS_CLASS, PacketUtils.IChatBaseComponentClass);
                assert (packetPlayOutOpenWindowCon != null);
                Object packet = packetPlayOutOpenWindowCon.newInstance(c, generic.get(null), PacketUtils.getChatMessage(this.title));
                PacketUtils.sendPacket(this.player, packet);
            } else {
                IReflection.ConstructorAccessor packetPlayOutOpenWindowCon = IReflection.getConstructor(PACKET_PLAY_OUT_OPEN_WINDOW_CLASS, Integer.class, String.class, CHAT_MESSAGE_CLASS, Integer.TYPE);
                assert (packetPlayOutOpenWindowCon != null);
                PacketUtils.sendPacket(this.player, packetPlayOutOpenWindowCon.newInstance(c, "minecraft:anvil", CHAT_MESSAGE_CON.newInstance("AnvilGUI", new Object[0]), 0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.plugin.getLogger().log(Level.SEVERE, "Error: Cannot open the AnvilGUI in " + Version.get().name() + "!");
        }
        InventoryUtils.setActiveContainer(entityPlayer, container);
        InventoryUtils.setWindowId(container, c);
        if (Version.atLeast(17.0)) {
            IReflection.MethodAccessor initMenu = IReflection.getMethod(ENTITY_PLAYER_CLASS, (Class)null, new Class[]{CONTAINER_CLASS});
            initMenu.invoke(entityPlayer, container);
        } else {
            IReflection.MethodAccessor addSlotListener = IReflection.getMethod(CONTAINER_CLASS, "addSlotListener", ENTITY_PLAYER_CLASS);
            addSlotListener.invoke(InventoryUtils.getActiveContainer(entityPlayer), entityPlayer);
        }
        this.updateInventory();
        return this;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean keep) {
        this.closeEvent = new AnvilCloseEvent(this.player, this, this.submitted, this.submittedText);
        Bukkit.getPluginManager().callEvent((Event)this.closeEvent);
        if (this.listener != null) {
            this.listener.onClose(this.closeEvent);
        }
        if (!this.closeEvent.isCancelled()) {
            this.inv.clear();
            if (!keep) {
                this.getPlayer().closeInventory();
            }
        }
    }

    public void clearInventory() {
        this.items = new HashMap();
        this.updateInventory();
    }

    public void updateInventory() {
        Object entityPlayer = PacketUtils.getEntityPlayer(this.player);
        Object container = InventoryUtils.getActiveContainer(entityPlayer);
        if (!container.toString().toLowerCase().contains("anvil")) {
            return;
        }
        this.inv = (Inventory)GET_TOP_INVENTORY.invoke(GET_BUKKIT_VIEW.invoke(container, new Object[0]), new Object[0]);
        if (this.prepareListener != null) {
            this.prepareListener.setInv(this.inv);
        }
        this.inv.clear();
        for (AnvilSlot slot : this.items.keySet()) {
            this.inv.setItem(slot.getSlot(), this.items.get((Object)slot));
        }
        this.player.updateInventory();
    }

    public AnvilGUI setSlot(AnvilSlot slot, ItemStack item) {
        this.items.remove((Object)slot);
        this.items.put(slot, item);
        return this;
    }

    public boolean remove() {
        if (this.listener == null) {
            return false;
        }
        this.clearInventory();
        this.listener = null;
        this.items = null;
        HandlerList.unregisterAll((Listener)this.bukkitListener);
        if (this.prepareListener != null) {
            this.prepareListener.unregister();
        }
        this.listener = null;
        API.removeRemovable(this);
        return true;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title == null ? "Repair & Name" : title;
    }

    public boolean isKeepSubmittedText() {
        return this.keepSubmittedText;
    }

    public void setKeepSubmittedText(boolean keepSubmittedText) {
        this.keepSubmittedText = keepSubmittedText;
    }

    public boolean isOnlyWithChanges() {
        return this.onlyWithChanges;
    }

    public void setOnlyWithChanges(boolean onlyWithChanges) {
        this.onlyWithChanges = onlyWithChanges;
    }

    private static /* synthetic */ Object lambda$static$0(IReflection.MethodAccessor rec$, Object x$0) {
        return rec$.invoke(x$0, new Object[0]);
    }

    static {
        Object getInventory;
        Class<?> containerAnvilClass = IReflection.getClass(IReflection.ServerPacket.INVENTORY, "ContainerAnvil");
        PLAYER_INVENTORY_CLASS = IReflection.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.entity.player"), "PlayerInventory");
        WORLD_CLASS = PacketUtils.WorldClass;
        BLOCK_POSITION_CLASS = PacketUtils.BlockPositionClass;
        ENTITY_PLAYER_CLASS = PacketUtils.EntityPlayerClass;
        assert (ENTITY_PLAYER_CLASS != null);
        Class<?> craftInventoryViewClass = IReflection.getClass(IReflection.ServerPacket.CRAFTBUKKIT_PACKAGE, "inventory.CraftInventoryView");
        PACKET_PLAY_OUT_OPEN_WINDOW_CLASS = IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutOpenWindow");
        CONTAINER_CLASS = IReflection.getClass(IReflection.ServerPacket.INVENTORY, "Container");
        if (Version.get().isBiggerThan(Version.v1_13)) {
            Class<?> containerAccessClass = IReflection.getClass(IReflection.ServerPacket.INVENTORY, "ContainerAccess");
            ANVIL_CONTAINER_CON = IReflection.getConstructor(containerAnvilClass, Integer.TYPE, PLAYER_INVENTORY_CLASS, containerAccessClass);
        } else {
            ANVIL_CONTAINER_CON = IReflection.getConstructor(containerAnvilClass, PLAYER_INVENTORY_CLASS, WORLD_CLASS, BLOCK_POSITION_CLASS, ENTITY_PLAYER_CLASS);
        }
        BLOCK_POSITION_CON = IReflection.getConstructor(BLOCK_POSITION_CLASS, Integer.class, Integer.class, Integer.class);
        if (Version.before(14.0)) {
            CHAT_MESSAGE_CLASS = IReflection.getClass(IReflection.ServerPacket.CHAT, "ChatMessage");
            CHAT_MESSAGE_CON = IReflection.getConstructor(CHAT_MESSAGE_CLASS, String.class, Object[].class);
        } else {
            CHAT_MESSAGE_CLASS = null;
            CHAT_MESSAGE_CON = null;
        }
        GET_BUKKIT_VIEW = IReflection.getMethod(containerAnvilClass, "getBukkitView", craftInventoryViewClass, (Class[])null);
        GET_TOP_INVENTORY = IReflection.getMethod(craftInventoryViewClass, "getTopInventory", Inventory.class, (Class[])null);
        NEXT_CONTAINER_COUNTER = IReflection.getMethod(ENTITY_PLAYER_CLASS, "nextContainerCounter", Integer.TYPE, (Class[])null);
        GET_WORLD = IReflection.getMethod(PacketUtils.EntityClass, PacketUtils.WorldClass, new Class[0]);
        REACHABLE = IReflection.getField(containerAnvilClass, "checkReachable");
        SLOT_TYPE_FIELD = IReflection.getField(InventoryClickEvent.class, InventoryType.SlotType.class, 0);
        if (Version.atLeast(17.0)) {
            getInventory = IReflection.getMethod(PacketUtils.EntityHumanClass, PLAYER_INVENTORY_CLASS, new Class[0]);
            GET_INVENTORY = arg_0 -> AnvilGUI.lambda$static$0((IReflection.MethodAccessor)getInventory, arg_0);
        } else {
            getInventory = IReflection.getField(ENTITY_PLAYER_CLASS, "inventory");
            GET_INVENTORY = arg_0 -> getInventory.get(arg_0);
        }
    }
}

