/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui.anvil;

import com.google.common.base.CharMatcher;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilGUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilSlot;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class AnvilClickEvent
extends Event {
    private final Player player;
    private final AnvilSlot slot;
    private final ClickType clickType;
    private final String input;
    private String submitted = null;
    private boolean keepInventory = false;
    private boolean close = false;
    private boolean cancelled = true;
    private boolean payExp = false;
    private final AnvilGUI anvil;
    public static HandlerList handlers = new HandlerList();

    public AnvilClickEvent(Player player, ClickType clickType, AnvilSlot slot, ItemStack item, AnvilGUI anvil) {
        this.anvil = anvil;
        this.player = player;
        this.clickType = clickType;
        this.slot = slot;
        this.input = item == null || !item.hasItemMeta() ? null : item.getItemMeta().getDisplayName();
    }

    public AnvilClickEvent(Player player, ClickType clickType, AnvilSlot slot, String input, AnvilGUI anvil) {
        this.anvil = anvil;
        this.player = player;
        this.clickType = clickType;
        this.slot = slot;
        this.input = input;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public AnvilGUI getAnvil() {
        return this.anvil;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public AnvilSlot getSlot() {
        return this.slot;
    }

    public boolean getWillClose() {
        return this.close;
    }

    public void setWillClose(boolean close) {
        this.close = close;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean willClose() {
        return this.close;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getInput() {
        return this.getInput(true);
    }

    public String getInput(boolean colors) {
        String input = this.input;
        if (input != null) {
            input = colors ? input.replace("\u00a7", "&") : ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)input));
        }
        return input == null ? null : this.getWhitespace().trimFrom((CharSequence)input);
    }

    private CharMatcher getWhitespace() {
        if (Version.atLeast(18.0)) {
            return CharMatcher.whitespace();
        }
        IReflection.FieldAccessor WHITESPACE = IReflection.getField(CharMatcher.class, "WHITESPACE");
        return (CharMatcher)WHITESPACE.get(null);
    }

    public String getRawInput() {
        return this.input;
    }

    public boolean isPayExp() {
        return this.payExp;
    }

    public void setPayExp(boolean payExp) {
        this.payExp = payExp;
    }

    public ClickType getClickType() {
        return this.clickType;
    }

    public String getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(String submitted) {
        this.submitted = submitted;
    }

    public boolean isKeepInventory() {
        return this.keepInventory;
    }

    public void setKeepInventory(boolean keepInventory) {
        this.keepInventory = keepInventory;
    }
}

