/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.gui.GUIListener;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class PlayerItem
extends ItemStack
implements Removable {
    private final UUID uniqueId = UUID.randomUUID();
    private final JavaPlugin plugin;
    private final Player player;
    private boolean freezed = true;
    private long lastClick = 0L;

    public PlayerItem(JavaPlugin plugin, Player player, ItemStack item) {
        super(item);
        this.plugin = plugin;
        this.player = player;
        API.addRemovable(this);
        GUIListener.register((Plugin)plugin);
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void destroy() {
        this.remove();
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public void remove() {
        Integer slot = null;
        for (int i = 0; i < this.player.getInventory().getContents().length; ++i) {
            ItemStack stack = this.player.getInventory().getItem(i);
            if (!this.equals(stack)) continue;
            slot = i;
            break;
        }
        if (slot != null) {
            this.player.getInventory().setItem(slot.intValue(), null);
        }
        API.removeRemovable(this);
    }

    public void trigger(PlayerInteractEvent e) {
        if (System.currentTimeMillis() - this.lastClick <= 50L) {
            return;
        }
        this.lastClick = System.currentTimeMillis();
        this.onInteract(e);
    }

    public abstract void onInteract(PlayerInteractEvent var1);

    public abstract void onHover(PlayerItemHeldEvent var1);

    public abstract void onUnhover(PlayerItemHeldEvent var1);

    public boolean isFreezed() {
        return this.freezed;
    }

    public PlayerItem setFreezed(boolean freezed) {
        this.freezed = freezed;
        return this;
    }

    public static boolean isUsing(Player p) {
        return API.getRemovable(p, PlayerItem.class) != null;
    }

    public void setDisplayName(String name) {
        ItemMeta meta = this.getItemMeta();
        meta.setDisplayName(name);
        this.setItemMeta(meta);
    }

    public String getDisplayName() {
        ItemMeta meta = this.getItemMeta();
        return meta.hasDisplayName() ? meta.getDisplayName() : null;
    }
}

