/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.gui;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.gui.PlayerItem;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.Interface;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.InterfaceListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.itembutton.ItemButton;
import de.codingair.tradesystem.lib.codingapi.server.sounds.SoundData;
import de.codingair.tradesystem.lib.codingapi.tools.Callback;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GUIListener
implements Listener {
    private static GUIListener instance = null;
    private final Plugin plugin;

    private GUIListener(Plugin plugin) {
        this.plugin = plugin;
        if (instance != null) {
            HandlerList.unregisterAll((Listener)instance);
        }
        instance = this;
    }

    public static void register(Plugin plugin) {
        if (GUIListener.isRegistered()) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)new GUIListener(plugin), plugin);
    }

    public static boolean isRegistered() {
        return instance != null;
    }

    public static void setUnregistered() {
        instance = null;
    }

    public static Plugin getPlugin() {
        return instance == null ? null : GUIListener.instance.plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteractEvent(PlayerInteractEvent e) {
        if (!PlayerItem.isUsing(e.getPlayer())) {
            return;
        }
        List<PlayerItem> items = API.getRemovables(e.getPlayer(), PlayerItem.class);
        Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInHand();
        for (PlayerItem pItem : items) {
            if (!pItem.equals(item)) continue;
            pItem.trigger(e);
        }
        items.clear();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent e) {
        if (!PlayerItem.isUsing((Player)e.getWhoClicked())) {
            return;
        }
        List<PlayerItem> items = API.getRemovables((Player)e.getWhoClicked(), PlayerItem.class);
        ItemStack current = e.getCurrentItem();
        for (PlayerItem pItem : items) {
            if (!pItem.equals(current) || !pItem.isFreezed()) continue;
            e.setCancelled(true);
        }
        items.clear();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDrop(PlayerDropItemEvent e) {
        if (!PlayerItem.isUsing(e.getPlayer())) {
            return;
        }
        List<PlayerItem> items = API.getRemovables(e.getPlayer(), PlayerItem.class);
        ItemStack current = e.getItemDrop().getItemStack();
        for (PlayerItem pItem : items) {
            if (!pItem.equals(current) || !pItem.isFreezed()) continue;
            e.setCancelled(true);
        }
        items.clear();
    }

    @EventHandler
    public void onSwitch(PlayerItemHeldEvent e) {
        if (!PlayerItem.isUsing(e.getPlayer())) {
            return;
        }
        List<PlayerItem> items = API.getRemovables(e.getPlayer(), PlayerItem.class);
        ItemStack old = e.getPlayer().getInventory().getItem(e.getPreviousSlot());
        ItemStack current = e.getPlayer().getInventory().getItem(e.getNewSlot());
        PlayerItem prev = null;
        PlayerItem next = null;
        for (PlayerItem pItem : items) {
            if (pItem.equals(old) && pItem.isFreezed()) {
                prev = pItem;
            }
            if (!pItem.equals(current) || !pItem.isFreezed()) continue;
            next = pItem;
        }
        items.clear();
        if (prev != null) {
            prev.onUnhover(e);
        }
        if (next != null) {
            next.onHover(e);
        }
    }

    @EventHandler
    public void onSwap(InventoryClickEvent e) {
        Player player;
        if (e.getClick().name().startsWith("SWAP_OFFHAND") && e.getWhoClicked() instanceof Player && (API.getRemovable(player = (Player)e.getWhoClicked(), GUI.class) != null || API.getRemovable(player, de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI.class) != null)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDropWhileInInventory(PlayerDropItemEvent e) {
        Interface inv;
        Player p = e.getPlayer();
        if (!GUI.usesGUI(p) && !GUI.usesOldGUI(p)) {
            return;
        }
        Interface interface_ = inv = GUI.usesGUI(p) ? GUI.getGUI(p) : GUI.getOldGUI(p);
        if (inv instanceof GUI) {
            e.setCancelled(!((GUI)inv).isCanDropItems());
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInvClickEvent(InventoryClickEvent e) {
        GUI gui;
        Interface inv;
        if (e.getInventory() == null || !GUI.usesGUI((Player)e.getWhoClicked()) && !GUI.usesOldGUI((Player)e.getWhoClicked()) || e.getInventory().getType() != InventoryType.CHEST) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        Interface interface_ = inv = GUI.usesGUI(p) ? GUI.getGUI(p) : GUI.getOldGUI(p);
        if (e.getClickedInventory() == null) {
            if (inv instanceof GUI) {
                e.setCancelled(!((GUI)inv).isCanDropItems());
            }
            if (!e.isCancelled()) {
                for (InterfaceListener l2 : inv.getListener()) {
                    l2.onDropItem(e);
                }
            }
            return;
        }
        if (e.getClickedInventory() == e.getView().getBottomInventory()) {
            for (InterfaceListener l3 : inv.getListener()) {
                l3.onClickBottomInventory(e);
            }
        }
        e.setCancelled(false);
        if (e.getClickedInventory() == e.getView().getTopInventory()) {
            for (InterfaceListener l2 : inv.getListener()) {
                l2.onInvClickEvent(e);
            }
            if (e.isCancelled()) {
                return;
            }
            e.setCancelled(!inv.isEditableItems());
            if (inv instanceof GUI && (gui = (GUI)inv).isMovable(e.getSlot())) {
                switch (e.getAction()) {
                    case COLLECT_TO_CURSOR: {
                        int a;
                        int amount;
                        ItemStack cursor = e.getCursor();
                        int startSize = cursor.getAmount();
                        if (inv.isEditableItems()) {
                            e.setCancelled(false);
                            break;
                        }
                        e.setCancelled(true);
                        e.setResult(Event.Result.DENY);
                        ArrayList<Integer> movedFrom = new ArrayList<Integer>();
                        for (Integer slot : gui.getMovableSlots()) {
                            ItemStack itemStack = gui.getItem(slot);
                            if (itemStack == null || !cursor.isSimilar(itemStack)) continue;
                            amount = cursor.getAmount();
                            if (amount >= cursor.getMaxStackSize()) break;
                            a = cursor.getMaxStackSize() - amount;
                            if (itemStack.getAmount() > a) {
                                itemStack.setAmount(itemStack.getAmount() - a);
                                cursor.setAmount(cursor.getMaxStackSize());
                                movedFrom.add(slot);
                                continue;
                            }
                            cursor.setAmount(cursor.getAmount() + itemStack.getAmount());
                            gui.setItem(slot, new ItemStack(Material.AIR));
                            movedFrom.add(slot);
                        }
                        if (gui.isMoveOwnItems() && e.getView().getBottomInventory() != null) {
                            Inventory bottom = e.getView().getBottomInventory();
                            for (int slot = 0; slot < bottom.getSize(); ++slot) {
                                ItemStack itemStack = bottom.getItem(slot);
                                if (itemStack == null || !cursor.isSimilar(itemStack)) continue;
                                amount = cursor.getAmount();
                                if (amount >= cursor.getMaxStackSize()) break;
                                a = cursor.getMaxStackSize() - amount;
                                if (itemStack.getAmount() > a) {
                                    itemStack.setAmount(itemStack.getAmount() - a);
                                    cursor.setAmount(cursor.getMaxStackSize());
                                    movedFrom.add(slot + gui.getSize());
                                    continue;
                                }
                                cursor.setAmount(cursor.getAmount() + itemStack.getAmount());
                                bottom.setItem(slot, new ItemStack(Material.AIR));
                                movedFrom.add(slot + gui.getSize());
                            }
                        }
                        if (cursor.getAmount() <= startSize) break;
                        gui.getGUIListeners().forEach(l -> l.onCollectToCursor(e.getCursor(), movedFrom, e.getRawSlot()));
                        break;
                    }
                    default: {
                        e.setCancelled(false);
                    }
                }
            }
            ItemStack item = e.getCurrentItem();
            int slot = e.getSlot();
            if (item == null || slot == -1) {
                return;
            }
            ItemButton button = inv.getButtonAt(slot);
            if (button == null) {
                return;
            }
            e.setCancelled(!button.isMovable());
            if (button.canClick(e.getClick()) && (button.isOnlyLeftClick() && e.isLeftClick() || button.isOnlyRightClick() && e.isRightClick() || !button.isOnlyRightClick() && !button.isOnlyLeftClick() || button.getOption().isNumberKey() && e.getClick().equals((Object)ClickType.NUMBER_KEY))) {
                if (e.getClick() == ClickType.DOUBLE_CLICK != button.getOption().isDoubleClick()) {
                    return;
                }
                button.playSound(e.getClick(), (Player)e.getWhoClicked());
                button.onClick(e);
                if (button.isCloseOnClick()) {
                    if (inv instanceof GUI) {
                        GUI g = (GUI)inv;
                        g.setClosingByButton(true);
                        if (g.useFallbackGUI() && g.getFallbackGUI() != null) {
                            g.fallBack();
                        } else {
                            e.getWhoClicked().closeInventory();
                        }
                    } else {
                        e.getWhoClicked().closeInventory();
                    }
                }
            }
        } else if (inv instanceof GUI) {
            gui = (GUI)inv;
            e.setCancelled(!gui.isMoveOwnItems());
            if (gui.isMoveOwnItems() && e.getClickedInventory().equals(e.getView().getBottomInventory())) {
                ItemStack current = e.getCurrentItem();
                switch (e.getAction()) {
                    case MOVE_TO_OTHER_INVENTORY: {
                        if (inv.isEditableItems()) {
                            e.setCancelled(false);
                            break;
                        }
                        e.setCancelled(true);
                        ArrayList<Integer> movedTo = new ArrayList<Integer>();
                        int empty = -999;
                        int cAmount = current.getAmount();
                        for (Integer n : gui.getMovableSlots()) {
                            int amount;
                            ItemStack other = gui.getItem(n);
                            if (other == null) {
                                if (empty == -999) {
                                    empty = n;
                                }
                            } else if (other.isSimilar(current) && (amount = other.getAmount()) < other.getMaxStackSize()) {
                                int a = other.getMaxStackSize() - amount;
                                if (current.getAmount() > a) {
                                    cAmount -= a;
                                    movedTo.add(n);
                                } else {
                                    cAmount = 0;
                                    movedTo.add(n);
                                }
                            }
                            if (cAmount != 0) continue;
                            break;
                        }
                        if (cAmount > 0 && empty != -999) {
                            movedTo.add(empty);
                        }
                        boolean cancelled = false;
                        for (de.codingair.tradesystem.lib.codingapi.player.gui.inventory.gui.GUIListener l4 : gui.getGUIListeners()) {
                            if (l4.onMoveToTopInventory(e.getRawSlot(), movedTo, current.clone())) {
                                cancelled = true;
                            }
                            l4.onMoveToTopInventory(current.clone(), e.getRawSlot(), movedTo);
                        }
                        if (cancelled) break;
                        for (Integer slot : movedTo) {
                            ItemStack other = gui.getItem(slot);
                            if (other == null) {
                                gui.setItem(slot, current.clone());
                                current.setAmount(0);
                                continue;
                            }
                            int amount = other.getAmount();
                            if (amount >= other.getMaxStackSize()) continue;
                            int a = other.getMaxStackSize() - amount;
                            if (current.getAmount() > a) {
                                current.setAmount(current.getAmount() - a);
                                other.setAmount(other.getMaxStackSize());
                                continue;
                            }
                            other.setAmount(other.getAmount() + current.getAmount());
                            current.setAmount(0);
                        }
                        if (current.getAmount() != 0) break;
                        e.getClickedInventory().setItem(e.getSlot(), new ItemStack(Material.AIR));
                        break;
                    }
                    case COLLECT_TO_CURSOR: {
                        int a;
                        int amount;
                        ItemStack other;
                        ItemStack cursor = e.getCursor();
                        int startSize = cursor.getAmount();
                        if (inv.isEditableItems()) {
                            e.setCancelled(false);
                            break;
                        }
                        e.setCancelled(true);
                        e.setResult(Event.Result.DENY);
                        ArrayList<Integer> movedFrom = new ArrayList<Integer>();
                        for (Integer n : gui.getMovableSlots()) {
                            other = gui.getItem(n);
                            if (other == null || !cursor.isSimilar(other)) continue;
                            amount = cursor.getAmount();
                            if (amount >= cursor.getMaxStackSize()) break;
                            a = cursor.getMaxStackSize() - amount;
                            if (other.getAmount() > a) {
                                other.setAmount(other.getAmount() - a);
                                cursor.setAmount(cursor.getMaxStackSize());
                                movedFrom.add(n);
                                continue;
                            }
                            cursor.setAmount(cursor.getAmount() + other.getAmount());
                            gui.setItem(n, new ItemStack(Material.AIR));
                            movedFrom.add(n);
                        }
                        if (gui.isMoveOwnItems() && e.getView().getBottomInventory() != null) {
                            void var10_32;
                            Inventory bottom = e.getView().getBottomInventory();
                            boolean bl = false;
                            while (var10_32 < bottom.getSize()) {
                                other = bottom.getItem((int)var10_32);
                                if (other != null && cursor.isSimilar(other)) {
                                    amount = cursor.getAmount();
                                    if (amount >= cursor.getMaxStackSize()) break;
                                    a = cursor.getMaxStackSize() - amount;
                                    if (other.getAmount() > a) {
                                        other.setAmount(other.getAmount() - a);
                                        cursor.setAmount(cursor.getMaxStackSize());
                                        movedFrom.add((int)(var10_32 + gui.getSize()));
                                    } else {
                                        cursor.setAmount(cursor.getAmount() + other.getAmount());
                                        bottom.setItem((int)var10_32, new ItemStack(Material.AIR));
                                        movedFrom.add((int)(var10_32 + gui.getSize()));
                                    }
                                }
                                ++var10_32;
                            }
                        }
                        if (cursor.getAmount() <= startSize) break;
                        gui.getGUIListeners().forEach(l -> l.onCollectToCursor(e.getCursor(), movedFrom, e.getRawSlot()));
                        break;
                    }
                    default: {
                        e.setCancelled(false);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInvCloseEvent(InventoryCloseEvent e) {
        SoundData sound;
        Interface inv;
        Callback<GUI> confirm = GUI.foreignConfirmations.remove(e.getPlayer());
        if (confirm != null) {
            confirm.accept(null);
            return;
        }
        if (e.getInventory() == null || !GUI.usesGUI((Player)e.getPlayer()) && !GUI.usesOldGUI((Player)e.getPlayer()) || e.getInventory().getType() != InventoryType.CHEST) {
            return;
        }
        Player p = (Player)e.getPlayer();
        Interface interface_ = inv = GUI.usesGUI(p) ? GUI.getGUI(p) : GUI.getOldGUI(p);
        if (inv instanceof GUI && !((GUI)inv).isClosingByButton() && (sound = ((GUI)inv).getCancelSound()) != null && !((GUI)inv).isClosingForGUI()) {
            sound.play(p);
        }
        inv.close((Player)e.getPlayer(), true);
        for (InterfaceListener l : inv.getListener()) {
            l.onInvCloseEvent(e);
        }
        if (inv instanceof GUI) {
            ((GUI)inv).confirmClosing();
        }
    }

    @EventHandler
    public void onInvOpenEvent(InventoryOpenEvent e) {
        if (e.getInventory() == null || !GUI.usesGUI((Player)e.getPlayer()) && !GUI.usesOldGUI((Player)e.getPlayer()) || e.getInventory().getType() != InventoryType.CHEST) {
            return;
        }
        Player p = (Player)e.getPlayer();
        Interface inv = GUI.usesGUI(p) ? GUI.getGUI(p) : GUI.getOldGUI(p);
        for (InterfaceListener l : inv.getListener()) {
            l.onInvOpenEvent(e);
        }
    }

    @EventHandler
    public void onInvDragEvent(InventoryDragEvent e) {
        Object gui;
        if (e.getInventory() == null || !GUI.usesGUI((Player)e.getWhoClicked()) && !GUI.usesOldGUI((Player)e.getWhoClicked()) || e.getInventory().getType() != InventoryType.CHEST) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        Interface inv = GUI.usesGUI(p) ? GUI.getGUI(p) : GUI.getOldGUI(p);
        e.setCancelled(!inv.isEditableItems());
        if (inv instanceof GUI) {
            gui = (GUI)inv;
            boolean movableSlots = true;
            for (Integer slot : e.getRawSlots()) {
                if (slot < ((Interface)gui).getSize()) {
                    if (!((GUI)gui).isMovable(slot)) {
                        movableSlots = false;
                    }
                } else if (!((GUI)gui).isMoveOwnItems()) {
                    movableSlots = false;
                }
                if (movableSlots) continue;
                break;
            }
            e.setCancelled(!movableSlots && !inv.isEditableItems());
        }
        gui = inv.getListener().iterator();
        while (gui.hasNext()) {
            InterfaceListener l = (InterfaceListener)gui.next();
            l.onInvDragEvent(e);
        }
        if (inv instanceof GUI && ((GUI)(gui = (GUI)inv)).isMoveOwnItems()) {
            boolean topInv = false;
            for (Integer slot : e.getRawSlots()) {
                if (slot >= ((Interface)gui).getSize()) continue;
                topInv = true;
            }
            if (!topInv) {
                e.setCancelled(false);
            }
        }
    }
}

