/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.data;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.codingair.tradesystem.lib.codingapi.player.data.GameProfileUtils;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONArray;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONObject;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONParser;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.ParseException;
import de.codingair.tradesystem.lib.codingapi.utils.PropertyUtils;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Scanner;
import java.util.UUID;

public abstract class Skin {
    public static final String JSON_SKIN = "{\"timestamp\":%d,\"profileId\":\"%s\",\"profileName\":\"%s\",\"textures\":{\"SKIN\":{\"url\":\"%s\"}}}";
    public static final String JSON_CAPE = "{\"timestamp\":%d,\"profileId\":\"%s\",\"profileName\":\"%s\",\"textures\":{\"SKIN\":{\"url\":\"%s\"},\"CAPE\":{\"url\":\"%s\"}}}";
    private final UUID uuid;
    private final String name;
    private String signature;
    private String value;
    private boolean loaded = false;
    private boolean unsigned = false;

    @Deprecated
    public Skin(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.load();
    }

    @Deprecated
    public Skin(GameProfile profile) {
        this.uuid = profile.getId();
        this.name = profile.getName();
        profile.getProperties().get((Object)"textures").forEach(property -> {
            this.value = PropertyUtils.getValue(property);
            this.signature = PropertyUtils.getSignature(property);
        });
        this.loaded = true;
    }

    public Skin(UUID uuid, String name, boolean unsigned) {
        this.uuid = uuid;
        this.name = name;
        this.unsigned = unsigned;
        this.load();
    }

    public Skin(GameProfile profile, boolean unsigned) {
        this.uuid = profile.getId();
        this.name = profile.getName();
        this.unsigned = unsigned;
        profile.getProperties().get((Object)"textures").forEach(property -> {
            this.value = PropertyUtils.getValue(property);
            this.signature = PropertyUtils.getSignature(property);
        });
        this.loaded = true;
    }

    private void load() {
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + this.uuid.toString().replace("-", "") + "?unsigned=" + this.unsigned);
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setUseCaches(false);
            uc.setDefaultUseCaches(false);
            uc.addRequestProperty("User-Agent", "Mozilla/5.0");
            uc.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            uc.addRequestProperty("Pragma", "no-cache");
            uc.setRequestMethod("GET");
            uc.connect();
            if (uc.getResponseCode() == 204) {
                return;
            }
            if (uc.getResponseCode() != 200) {
                throw new RuntimeException("Error loading skin data: " + uc.getResponseCode());
            }
            String json = new Scanner(uc.getInputStream(), "UTF-8").useDelimiter("\\A").next();
            JSONObject data = (JSONObject)new JSONParser().parse(json);
            JSONArray properties = (JSONArray)data.get("properties");
            for (int i = 0; i < properties.size(); ++i) {
                try {
                    JSONObject property = (JSONObject)properties.get(i);
                    String value = (String)property.get("value");
                    String signature = property.containsKey("signature") ? (String)property.get("signature") : null;
                    this.value = value;
                    this.signature = signature;
                    this.loaded = true;
                    this.onLoad(this);
                    continue;
                }
                catch (Exception e) {
                    this.onFail(this);
                }
            }
        }
        catch (Exception e) {
            this.onFail(this);
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDecodedValue() {
        if (this.value == null) {
            return null;
        }
        return new String(Base64.getDecoder().decode(this.value));
    }

    public void encodeValue(String value) {
        this.value = Base64.getEncoder().encodeToString(value.getBytes());
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public abstract void onLoad(Skin var1);

    public abstract void onFail(Skin var1);

    public GameProfile modifyProfile(GameProfile profile) {
        if (!this.isLoaded()) {
            return profile;
        }
        profile.getProperties().removeAll((Object)"textures");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", this.value, this.signature));
        return profile;
    }

    @Nullable
    public <T> T getElement(@NotNull SkinElement element) {
        if (!this.isLoaded()) {
            return null;
        }
        String code = this.getDecodedValue();
        if (code == null) {
            return null;
        }
        if ((code = code.replace("{textures:", "{\"textures\":").replace("{SKIN:", "{\"SKIN\":").replace("{url:", "{\"url\":")).isEmpty()) {
            return null;
        }
        try {
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(code);
            if (element.equals((Object)SkinElement.TIMESTAMP) || element.equals((Object)SkinElement.PROFILE_ID) || element.equals((Object)SkinElement.PROFILE_NAME)) {
                return (T)jsonObject.get(element.getName());
            }
            JSONObject texturesJSON = (JSONObject)jsonObject.get("textures");
            if (element.equals((Object)SkinElement.SKIN)) {
                JSONObject skinJSON = (JSONObject)texturesJSON.get("SKIN");
                if (skinJSON == null) {
                    return null;
                }
                return (T)skinJSON.get("url");
            }
            if (element.equals((Object)SkinElement.CAPE)) {
                JSONObject capeJSON = (JSONObject)texturesJSON.get("CAPE");
                if (capeJSON == null) {
                    return null;
                }
                return (T)capeJSON.get("url");
            }
            return null;
        }
        catch (ParseException e) {
            new IllegalArgumentException("Cannot resolve '" + element.name() + "'-element. Data='" + code + "'", e).printStackTrace();
            return null;
        }
    }

    public void setElement(String src, SkinElement element) {
        String skin = (String)this.getElement(SkinElement.SKIN);
        String cape = (String)this.getElement(SkinElement.CAPE);
        long timestamp = (Long)this.getElement(SkinElement.TIMESTAMP);
        if (element.equals((Object)SkinElement.SKIN)) {
            GameProfile gameProfile = GameProfileUtils.getGameProfile(this.uuid, this.name, timestamp, this.signature, src, cape);
            Skin temp = Skin.getSkin(gameProfile);
            this.value = temp.getValue();
        } else if (element.equals((Object)SkinElement.CAPE)) {
            GameProfile gameProfile = GameProfileUtils.getGameProfile(this.uuid, this.name, timestamp, this.signature, skin, src);
            Skin temp = Skin.getSkin(gameProfile);
            this.value = temp.getValue();
        }
    }

    public void setPublic(boolean isPublic) {
    }

    @Deprecated
    public static Skin getSkin(UUID uuid) {
        return new Skin(uuid, "none"){

            @Override
            public void onLoad(Skin skin) {
            }

            @Override
            public void onFail(Skin skin) {
            }
        };
    }

    public static Skin getSkin(UUID uuid, String name) {
        return new Skin(uuid, name){

            @Override
            public void onLoad(Skin skin) {
            }

            @Override
            public void onFail(Skin skin) {
            }
        };
    }

    public static Skin getSkin(GameProfile profile) {
        return new Skin(profile){

            @Override
            public void onLoad(Skin skin) {
            }

            @Override
            public void onFail(Skin skin) {
            }
        };
    }

    public static enum SkinElement {
        SKIN("SKIN", String.class),
        CAPE("CAPE", String.class),
        TIMESTAMP("timestamp", Long.TYPE),
        PROFILE_ID("profileId", String.class),
        PROFILE_NAME("profileName", String.class);

        private final String name;
        private final Class<?> clazz;

        private SkinElement(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }
}

