/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.data;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.nms.NmsLoader;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class PacketReader
implements Removable {
    private static final IReflection.FieldAccessor<?> getPlayerConnection = PacketUtils.playerConnection;
    private static final IReflection.FieldAccessor<?> getNetworkManager = IReflection.getField(PacketUtils.PlayerConnectionClass, PacketUtils.NetworkManagerClass, 0);
    private static final IReflection.FieldAccessor<?> getChannel = IReflection.getField(PacketUtils.NetworkManagerClass, Channel.class, 0);
    private final UUID uniqueId = UUID.randomUUID();
    private final Player player;
    private final String name;
    private final UUID id = UUID.randomUUID();
    private final JavaPlugin plugin;
    private boolean injected = false;

    @NmsLoader
    private PacketReader() {
        this.player = null;
        this.name = null;
        this.plugin = null;
    }

    public PacketReader(Player player, String name, JavaPlugin plugin) {
        this.player = player;
        this.name = name;
        this.plugin = plugin;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void destroy() {
        this.unInject();
    }

    public synchronized void inject() {
        if (this.injected) {
            this.unInject(this::inject);
            return;
        }
        this.injected = true;
        this.modify(pipe -> {
            ChannelDuplexHandler currentHandler = new ChannelDuplexHandler(){

                public void channelRead(ChannelHandlerContext ctx, Object o) throws Exception {
                    try {
                        if (!PacketReader.this.readPacket(o)) {
                            super.channelRead(ctx, o);
                        }
                    }
                    catch (Exception ex) {
                        super.channelRead(ctx, o);
                    }
                }

                public void write(ChannelHandlerContext ctx, Object o, ChannelPromise promise) throws Exception {
                    try {
                        if (!PacketReader.this.writePacket(o)) {
                            super.write(ctx, o, promise);
                        }
                    }
                    catch (Exception ex) {
                        super.write(ctx, o, promise);
                    }
                }
            };
            if (pipe.get(this.getCombinedName()) != null) {
                pipe.remove(this.getCombinedName());
            }
            if (pipe.get("packet_handler") != null) {
                pipe.addBefore("packet_handler", this.getCombinedName(), (ChannelHandler)currentHandler);
            } else {
                pipe.addFirst(this.getCombinedName(), (ChannelHandler)currentHandler);
            }
        });
        API.addRemovable(this);
    }

    public void unInject() {
        this.unInject(null);
    }

    public synchronized void unInject(@Nullable Runnable later) {
        this.modify(pipe -> {
            if (pipe.get(this.getCombinedName()) != null) {
                pipe.remove(this.getCombinedName());
            }
        });
        API.removeRemovable(this);
        this.injected = false;
        if (later != null) {
            if (this.plugin.isEnabled()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, later);
            } else {
                later.run();
            }
        }
    }

    private void modify(@NotNull Consumer<ChannelPipeline> modifier) {
        Object ep = PacketUtils.getEntityPlayer(this.player);
        if (ep == null) {
            return;
        }
        Object playerCon = getPlayerConnection.get(ep);
        if (playerCon == null) {
            return;
        }
        Object networkMan = getNetworkManager.get(playerCon);
        if (networkMan == null) {
            return;
        }
        Channel channel = (Channel)getChannel.get(networkMan);
        if (channel == null) {
            return;
        }
        channel.eventLoop().execute(() -> {
            if (!this.player.isOnline()) {
                return;
            }
            try {
                modifier.accept(channel.pipeline());
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot modify channel pipeline of player '" + this.player.getName() + "'", t);
            }
        });
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public String getName() {
        return this.name;
    }

    public String getCombinedName() {
        return this.name + "#" + this.id;
    }

    public abstract boolean readPacket(Object var1);

    public abstract boolean writePacket(Object var1);

    public static class NmsWrapper
    extends PacketReader {
        @NmsLoader
        private NmsWrapper() {
        }

        @Override
        public boolean readPacket(Object packet) {
            return false;
        }

        @Override
        public boolean writePacket(Object packet) {
            return false;
        }
    }
}

