/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.data;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.codingair.tradesystem.lib.codingapi.player.data.Skin;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSON;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSONParser;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class GameProfileUtils {
    public static GameProfile getGameProfile(Player p) {
        IReflection.MethodAccessor getProfile = IReflection.getMethod(PacketUtils.EntityPlayerClass, GameProfile.class, new Class[0]);
        return (GameProfile)getProfile.invoke(PacketUtils.getEntityPlayer(p), new Object[0]);
    }

    public static String extractSkinId(Player p) {
        return GameProfileUtils.extractSkinId(GameProfileUtils.getGameProfile(p));
    }

    @Nullable
    public static String extractSkinId(@Nullable GameProfile gameProfile) {
        if (gameProfile == null) {
            return null;
        }
        Skin skin = new Skin(gameProfile, true){

            @Override
            public void onLoad(Skin skin) {
            }

            @Override
            public void onFail(Skin skin) {
            }
        };
        String data = (String)skin.getElement(Skin.SkinElement.SKIN);
        if (data == null) {
            return null;
        }
        return data.replace("http://textures.minecraft.net/texture/", "");
    }

    public static GameProfile createBySkinId(String skinId) {
        return GameProfileUtils.getGameProfile(UUID.randomUUID(), "-", 0L, "", "http://textures.minecraft.net/texture/" + skinId, null);
    }

    public static GameProfile gameProfileFromJSON(String code) {
        if (code == null) {
            return null;
        }
        try {
            JSON json = (JSON)new JSONParser().parse(code);
            UUID uniqueId = UUID.fromString((String)json.get("ID"));
            String name = (String)json.get("Name");
            String pName = (String)json.get("Property_Name");
            String pValue = (String)json.get("Property_Value");
            String pSignature = (String)json.get("Property_Signature");
            GameProfile gameProfile = new GameProfile(uniqueId, name);
            gameProfile.getProperties().put((Object)"textures", (Object)new Property(pName, pValue, pSignature));
            return gameProfile;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GameProfile getGameProfile(UUID uuid, String name, long timestamp, String signature, String skinUrl, String capeUrl) {
        GameProfile profile = new GameProfile(uuid, name);
        boolean cape = capeUrl != null && !capeUrl.isEmpty();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(timestamp);
        args.add(uuid.toString());
        args.add(name);
        args.add(skinUrl);
        if (cape) {
            args.add(capeUrl);
        }
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64Coder.encodeString((String)String.format(cape ? "{\"timestamp\":%d,\"profileId\":\"%s\",\"profileName\":\"%s\",\"textures\":{\"SKIN\":{\"url\":\"%s\"},\"CAPE\":{\"url\":\"%s\"}}}" : "{\"timestamp\":%d,\"profileId\":\"%s\",\"profileName\":\"%s\",\"textures\":{\"SKIN\":{\"url\":\"%s\"}}}", args.toArray(new Object[args.size()]))), signature));
        return profile;
    }
}

