/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.chat;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.chat.ChatButton;
import de.codingair.tradesystem.lib.codingapi.player.chat.ChatListener;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SimpleMessage
implements Removable {
    private final UUID uniqueId = UUID.randomUUID();
    private final List<Object> components = new ArrayList<Object>();
    private final Player player;
    private HoverEvent hoverEvent;
    private ClickEvent clickEvent;
    private final JavaPlugin plugin;
    private boolean sent = false;
    private int timeOut = -1;
    private int cachedSize;
    private BukkitRunnable runnable = null;

    public SimpleMessage(JavaPlugin plugin) {
        this((Player)null, plugin);
    }

    public SimpleMessage(String base, JavaPlugin plugin) {
        this(null, base, plugin);
    }

    public SimpleMessage(TextComponent base, JavaPlugin plugin) {
        this(null, base, plugin);
    }

    public SimpleMessage(Player player, JavaPlugin plugin) {
        this.plugin = plugin;
        this.player = player;
        API.addRemovable(this);
    }

    public SimpleMessage(Player player, String base, JavaPlugin plugin) {
        this(player, plugin);
        this.add(base);
    }

    public SimpleMessage(Player player, TextComponent base, JavaPlugin plugin) {
        this(player, plugin);
        this.add(base);
    }

    public SimpleMessage setHoverEvent(HoverEvent.Action action, BaseComponent ... value) {
        this.hoverEvent = new HoverEvent(action, value);
        return this;
    }

    public SimpleMessage setClickEvent(ClickEvent.Action action, String value) {
        this.clickEvent = new ClickEvent(action, value);
        return this;
    }

    public SimpleMessage add(String s) {
        s = s.replace("\\n", "\n");
        this.components.add(this.convert(s));
        this.cachedSize = -1;
        return this;
    }

    @NotNull
    private TextComponent convert(String s) {
        return new TextComponent(TextComponent.fromLegacyText((String)s));
    }

    public SimpleMessage add(TextComponent messageComponent) {
        this.components.add(messageComponent);
        this.cachedSize = -1;
        return this;
    }

    public SimpleMessage add(ChatButton button) {
        this.components.add(button);
        this.cachedSize = -1;
        return this;
    }

    public SimpleMessage add(int index, String s) {
        s = s.replace("\\n", "\n");
        this.components.add(index, this.convert(s));
        this.cachedSize = -1;
        return this;
    }

    public SimpleMessage add(int index, TextComponent messageComponent) {
        this.components.add(index, messageComponent);
        this.cachedSize = -1;
        return this;
    }

    private SimpleMessage add(int index, Object messageComponent) {
        if (messageComponent instanceof String) {
            messageComponent = ((String)messageComponent).replace("\\n", "\n");
        }
        this.components.add(index, messageComponent);
        this.cachedSize = -1;
        return this;
    }

    public SimpleMessage add(int index, ChatButton button) {
        this.components.add(index, button);
        this.cachedSize = -1;
        return this;
    }

    public SimpleMessage addComponent(int index, String message, boolean hover, boolean click) {
        message = message.replace("\\n", "\n");
        return this.addComponent(index, this.convert(message), hover, click);
    }

    public SimpleMessage addComponent(String message, boolean hover, boolean click) {
        message = message.replace("\\n", "\n");
        return this.addComponent(this.convert(message), hover, click);
    }

    public SimpleMessage addComponent(int index, TextComponent messageComponent, boolean hover, boolean click) {
        if (hover) {
            messageComponent.setHoverEvent(this.hoverEvent);
        }
        if (click) {
            messageComponent.setClickEvent(this.clickEvent);
        }
        if (index >= 0) {
            this.components.add(index, messageComponent);
        } else {
            this.components.add(messageComponent);
        }
        this.cachedSize = -1;
        return this;
    }

    public SimpleMessage addComponent(TextComponent messageComponent, boolean hover, boolean click) {
        return this.addComponent(-1, messageComponent, hover, click);
    }

    private TextComponent getTextComponent() {
        TextComponent base = null;
        for (Object tc : this.components) {
            TextComponent current;
            TextComponent textComponent = current = tc instanceof ChatButton ? ((ChatButton)tc).build() : new TextComponent((TextComponent)tc);
            if (base == null) {
                base = current;
                continue;
            }
            base.addExtra((BaseComponent)current);
        }
        return base;
    }

    public void send() {
        if (this.player == null) {
            throw new NullPointerException("The message receiver is not defined!");
        }
        this.send(this.player);
    }

    public void send(Player sender) {
        this.send(sender, (p, tc) -> p.spigot().sendMessage((BaseComponent)tc));
    }

    public void send(Player sender, BiConsumer<Player, TextComponent> sending) {
        sending.accept(sender, this.getTextComponent());
        this.sent = true;
        if (this.runnable == null && this.timeOut > 0) {
            this.runnable = new BukkitRunnable(){

                public void run() {
                    SimpleMessage.this.timeOut--;
                    if (SimpleMessage.this.timeOut == 0) {
                        SimpleMessage.this.onTimeOut();
                        SimpleMessage.this.destroy();
                    }
                }
            };
            this.runnable.runTaskTimer((Plugin)this.plugin, 20L, 20L);
        }
    }

    public List<ChatButton> getButtons() {
        ArrayList<ChatButton> buttons = new ArrayList<ChatButton>();
        for (Object c : this.components) {
            if (!(c instanceof ChatButton)) continue;
            buttons.add((ChatButton)c);
        }
        return buttons;
    }

    public ChatButton getButton(UUID uniqueId) {
        for (Object c : this.components) {
            if (!(c instanceof ChatButton) || !((ChatButton)c).getUniqueId().equals(uniqueId)) continue;
            return (ChatButton)c;
        }
        return null;
    }

    public boolean replace(String toReplaced, ChatButton replacement) {
        return this.replace(toReplaced, (Object)replacement);
    }

    public boolean replace(String toReplaced, TextComponent replacement) {
        return this.replace(toReplaced, (Object)replacement);
    }

    private boolean replace(String toReplaced, Object replacement) {
        boolean foundSth = false;
        int i = 0;
        ArrayList<Object> components = new ArrayList<Object>(this.components);
        for (Object e : components) {
            TextComponent c;
            TextComponent textComponent = c = e instanceof ChatButton ? ((ChatButton)e).build() : (TextComponent)e;
            if (!c.toLegacyText().contains(toReplaced)) {
                ++i;
                continue;
            }
            this.components.remove(c);
            foundSth = true;
            int j = 0;
            String[] a = c.toLegacyText().split(toReplaced, -1);
            for (int k = 0; k < a.length; ++k) {
                String s = a[k];
                if (s != null && !s.isEmpty()) {
                    TextComponent tc = this.convert(s);
                    tc.setClickEvent(c.getClickEvent());
                    tc.setHoverEvent(c.getHoverEvent());
                    tc.setBold(Boolean.valueOf(c.isBold()));
                    tc.setColor(c.getColor());
                    tc.setItalic(Boolean.valueOf(c.isItalic()));
                    tc.setObfuscated(Boolean.valueOf(c.isObfuscated()));
                    tc.setStrikethrough(Boolean.valueOf(c.isStrikethrough()));
                    tc.setUnderlined(Boolean.valueOf(c.isUnderlined()));
                    this.add(i + j++, tc);
                }
                if (k >= a.length - 1) continue;
                this.add(i + j++, replacement);
            }
            ++i;
        }
        components.clear();
        return foundSth;
    }

    @Override
    public void destroy() {
        for (Object component : this.components) {
            if (!(component instanceof ChatButton)) continue;
            ChatListener.DEAD_BUTTONS.add(((ChatButton)component).getUniqueId());
        }
        API.removeRemovable(this);
        this.components.clear();
        if (this.runnable != null) {
            this.runnable.cancel();
            this.runnable = null;
        }
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isSent() {
        return this.sent;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        if (this.sent) {
            return;
        }
        this.timeOut = timeOut;
    }

    public void onTimeOut() {
    }

    public void clearTimeOut() {
        this.sent = false;
    }

    public int size() {
        if (this.cachedSize == -1) {
            this.cachedSize = 0;
            int from = 0;
            for (Object c : this.components) {
                String s = c.toString();
                while ((from = s.indexOf("\n", from)) != -1) {
                    ++from;
                    ++this.cachedSize;
                }
            }
        }
        return this.cachedSize;
    }
}

