/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.chat;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.chat.ChatButton;
import de.codingair.tradesystem.lib.codingapi.player.chat.ChatButtonManager;
import de.codingair.tradesystem.lib.codingapi.player.chat.SimpleMessage;
import de.codingair.tradesystem.lib.codingapi.player.data.PacketReader;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class ChatListener
implements Listener {
    private static Class<?> chatPacket;
    private static String messagePrefix;
    private static final IReflection.FieldAccessor<String> text;
    static final Set<UUID> DEAD_BUTTONS;
    static boolean showError;

    @NotNull
    static UUID getRandom() {
        UUID id;
        while (DEAD_BUTTONS.contains(id = UUID.randomUUID())) {
        }
        return id;
    }

    public ChatListener() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            this.inject(onlinePlayer);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        this.inject(e.getPlayer());
    }

    private void inject(final Player player) {
        new PacketReader(player, "chat-button-listener", API.getInstance().getMainPlugin()){

            @Override
            public boolean readPacket(Object packet) {
                if (packet.getClass().equals(chatPacket)) {
                    try {
                        UUID uniqueId;
                        String msg = (String)text.get(packet);
                        if (msg != null) {
                            msg = messagePrefix + msg;
                        }
                        if (!ChatButton.isChatButton(msg)) {
                            return false;
                        }
                        String type = null;
                        if (msg.contains("#")) {
                            String[] a = msg.split("#");
                            uniqueId = UUID.fromString(ChatButton.removePrefix(a[0]));
                            type = a[1];
                        } else {
                            uniqueId = UUID.fromString(ChatButton.removePrefix(msg));
                        }
                        if (DEAD_BUTTONS.contains(uniqueId)) {
                            return true;
                        }
                        List<SimpleMessage> messageList = API.getRemovables(null, SimpleMessage.class);
                        boolean used = ChatListener.this.handleSimpleMessages(type, uniqueId, player, messageList);
                        messageList = API.getRemovables(player, SimpleMessage.class);
                        return used |= ChatListener.this.handleSimpleMessages(type, uniqueId, player, messageList);
                    }
                    catch (Throwable t) {
                        if (!showError) {
                            return false;
                        }
                        t.printStackTrace();
                        showError = false;
                        return false;
                    }
                }
                return false;
            }

            @Override
            public boolean writePacket(Object packet) {
                return false;
            }
        }.inject();
    }

    private boolean handleSimpleMessages(String type, UUID uniqueId, Player player, List<SimpleMessage> messageList) {
        boolean clicked = false;
        if (!messageList.isEmpty()) {
            for (SimpleMessage message : messageList) {
                ChatButton button = message.getButton(uniqueId);
                if (button == null) continue;
                clicked = true;
                Bukkit.getScheduler().runTask((Plugin)API.getInstance().getMainPlugin(), () -> {
                    if (button.canClick()) {
                        if (button.getSound() != null) {
                            button.getSound().play(player);
                        }
                        button.onClick(player);
                    }
                });
                break;
            }
            messageList.clear();
        }
        if (clicked) {
            return true;
        }
        return this.callForeignClick(player, uniqueId, type);
    }

    private boolean callForeignClick(Player player, UUID uniqueId, String type) {
        return ChatButtonManager.onAsyncInteract(l -> l.onAsyncClick(player, uniqueId, type));
    }

    static {
        messagePrefix = "";
        DEAD_BUTTONS = new HashSet<UUID>();
        showError = true;
        try {
            chatPacket = IReflection.getSaveClass(IReflection.ServerPacket.PACKETS, "ServerboundChatCommandPacket");
            messagePrefix = "/";
        }
        catch (ClassNotFoundException e) {
            chatPacket = IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayInChat");
        }
        text = IReflection.getField(chatPacket, String.class, 0);
    }
}

