/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player.chat;

import de.codingair.tradesystem.lib.codingapi.player.chat.ChatButtonListener;
import java.util.ArrayList;
import java.util.List;

public class ChatButtonManager {
    private static ChatButtonManager instance;
    private final List<ChatButtonListener> listeners = new ArrayList<ChatButtonListener>();

    public boolean addListener(ChatButtonListener l) {
        return this.listeners.add(l);
    }

    public boolean removeListener(ChatButtonListener l) {
        return this.listeners.remove(l);
    }

    static boolean onAsyncInteract(Event e) {
        if (!ChatButtonManager.hasInstance()) {
            return false;
        }
        ArrayList<ChatButtonListener> listeners = new ArrayList<ChatButtonListener>(ChatButtonManager.getInstance().listeners);
        for (ChatButtonListener listener : listeners) {
            if (!e.onInteract(listener)) continue;
            return true;
        }
        listeners.clear();
        return false;
    }

    public static ChatButtonManager getInstance() {
        if (instance == null) {
            instance = new ChatButtonManager();
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static interface Event {
        public boolean onInteract(ChatButtonListener var1);
    }
}

