/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.player;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.nms.NmsLoader;
import de.codingair.tradesystem.lib.codingapi.player.data.PacketReader;
import de.codingair.tradesystem.lib.codingapi.server.events.PlayerWalkEvent;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.Packet;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Hologram
implements Removable {
    private static final double DISTANCE_TO_SEE = 120.0;
    private static final double DISTANCE = 0.25;
    private static final double ARMOR_STAND_HEIGHT = 0.625;
    private static final Set<Object> DATA_WATCHER_OBJECTS = new HashSet<Object>();
    private final UUID uniqueId = UUID.randomUUID();
    private final JavaPlugin plugin;
    private final List<Object> entities = new ArrayList<Object>();
    private final List<Player> watchList = new ArrayList<Player>();
    private final HashMap<Player, Boolean> initiatedPlayers = new HashMap();
    private final List<String> text;
    private final long updateInterval;
    private Location source;
    private Location location;
    private boolean visible = false;
    private BukkitRunnable runnable;

    @NmsLoader
    private Hologram() {
        this.plugin = null;
        this.text = null;
        this.updateInterval = 0L;
    }

    public Hologram(Location location, JavaPlugin plugin, String ... text) {
        this(location, plugin, 0L, text);
    }

    public Hologram(Location location, JavaPlugin plugin, long updateInterval, String ... text) {
        if (!API.getInstance().isInitialized()) {
            throw new IllegalStateException("API have to be initialized!");
        }
        this.text = new ArrayList<String>(Arrays.asList(text));
        if (location.getWorld() == null) {
            throw new IllegalStateException("Could not initialize Hologram with a location without world!");
        }
        this.source = location.clone();
        this.plugin = plugin;
        this.updateInterval = updateInterval / 50L;
    }

    public static Listener getListener() {
        return new Listener(){

            @EventHandler(priority=EventPriority.LOWEST)
            public void onSwitchWorld(PlayerChangedWorldEvent e) {
                List<Hologram> l = API.getRemovables(null, Hologram.class);
                for (Hologram hologram : l) {
                    if (hologram.isNotWatching(e.getPlayer())) continue;
                    if (hologram.getLocation().getWorld() == e.getFrom()) {
                        hologram.remove(e.getPlayer());
                        continue;
                    }
                    if (hologram.getLocation().getWorld() != e.getPlayer().getWorld() || !(hologram.getLocation().distance(e.getPlayer().getLocation()) <= 120.0)) continue;
                    hologram.update(e.getPlayer());
                }
                l.clear();
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void onTeleport(PlayerTeleportEvent e) {
                if (e.getTo() == null) {
                    return;
                }
                if (e.getFrom().getWorld() != e.getTo().getWorld()) {
                    return;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)API.getInstance().getMainPlugin(), () -> {
                    List<Hologram> l = API.getRemovables(null, Hologram.class);
                    for (Hologram hologram : l) {
                        double from;
                        if (hologram.isNotWatching(e.getPlayer())) continue;
                        double to = e.getTo().getWorld() != hologram.getLocation().getWorld() ? -1.0 : hologram.getLocation().distance(e.getTo());
                        double d = from = e.getFrom().getWorld() != hologram.getLocation().getWorld() ? -1.0 : hologram.getLocation().distance(e.getFrom());
                        if (to != -1.0 && to <= 120.0 && (from == -1.0 || from > 120.0)) {
                            hologram.update(e.getPlayer());
                            continue;
                        }
                        if (to != -1.0 && !(to > 120.0) || from == -1.0 || !(from <= 120.0)) continue;
                        hologram.remove(e.getPlayer());
                    }
                    l.clear();
                }, 2L);
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void onJoin(PlayerJoinEvent e) {
                List<Hologram> l = API.getRemovables(null, Hologram.class);
                for (Hologram hologram : l) {
                    if (hologram.isNotWatching(e.getPlayer()) || hologram.getLocation().getWorld() != e.getPlayer().getWorld() || hologram.getLocation().getWorld() != e.getPlayer().getWorld() || !(hologram.getLocation().distance(e.getPlayer().getLocation()) <= 120.0)) continue;
                    hologram.update(e.getPlayer());
                }
                l.clear();
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void onQuit(PlayerQuitEvent e) {
                List<Hologram> l = API.getRemovables(null, Hologram.class);
                for (Hologram hologram : l) {
                    hologram.remove(e.getPlayer());
                    hologram.watchList.remove(e.getPlayer());
                }
                l.clear();
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void onWalk(PlayerWalkEvent e) {
                List<Hologram> l = API.getRemovables(null, Hologram.class);
                for (Hologram hologram : l) {
                    if (hologram.isNotWatching(e.getPlayer()) || e.getFrom().getWorld() != e.getTo().getWorld() || e.getTo().getWorld() != hologram.getLocation().getWorld()) continue;
                    double to = hologram.getLocation().distance(e.getTo());
                    double from = hologram.getLocation().distance(e.getFrom());
                    if (to <= 120.0 && from > 120.0) {
                        hologram.update(e.getPlayer(), true);
                        continue;
                    }
                    if (!(to > 120.0) || !(from <= 120.0)) continue;
                    hologram.remove(e.getPlayer());
                }
                l.clear();
            }
        };
    }

    private void initialize() {
        if (this.isInitialized()) {
            this.remove();
        }
        this.location = this.source.clone();
        this.location.subtract(0.0, 0.625, 0.0);
        this.location.add(0.0, (double)this.text.size() * 0.25, 0.0);
        for (String line : this.text) {
            Object armorStand = HologramPackets.createArmorStand(this.location);
            HologramPackets.setCustomName(armorStand, line);
            HologramPackets.setCustomNameVisible(armorStand, !line.isEmpty());
            HologramPackets.setInvisible(armorStand, true);
            HologramPackets.setInvulnerable(armorStand, true);
            HologramPackets.setMarker(armorStand, true);
            HologramPackets.setGravity(armorStand, false);
            this.location.subtract(0.0, 0.25, 0.0);
            this.entities.add(armorStand);
        }
        this.initializeRunnable();
        API.addRemovable(this);
    }

    private void initializeRunnable() {
        if (this.updateInterval > 0L) {
            this.runnable = new BukkitRunnable(){

                public void run() {
                    ArrayList watchList = new ArrayList(Hologram.this.watchList);
                    for (Player player : watchList) {
                        Hologram.this.initiatedPlayers.replace(player, true);
                    }
                    watchList.clear();
                    Hologram.this.update(null);
                }
            };
            this.runnable.runTaskTimer((Plugin)this.plugin, 0L, this.updateInterval);
        }
    }

    public void teleport(Location location) {
        this.source = location.clone();
        if (!this.isInitialized()) {
            return;
        }
        this.location = location.clone();
        this.location.subtract(0.0, 0.625, 0.0);
        this.location.add(0.0, (double)this.text.size() * 0.25, 0.0);
        for (Object entity : this.entities) {
            HologramPackets.setLocation(entity, location);
            HologramPackets.teleport(entity, this.location, this.initiatedPlayers.keySet().toArray(new Player[0]));
            this.location.subtract(0.0, 0.25, 0.0);
        }
    }

    public boolean isInitialized() {
        return API.getRemovable(Hologram.class, this.getUniqueId()) != null;
    }

    public void update() {
        if (this.cannotUpdateText()) {
            ArrayList<String> backupText = new ArrayList<String>(this.text);
            this.destroy();
            this.text.addAll(backupText);
            backupText.clear();
            this.initialize();
        } else {
            for (int i = 0; i < this.entities.size(); ++i) {
                Object entity = this.entities.get(i);
                String text = this.text.get(i);
                HologramPackets.setCustomName(entity, text);
            }
        }
        this.update(null);
    }

    public void update(Player player) {
        this.update(player, false);
    }

    private void update(Player player, boolean force) {
        ArrayList<Player> handle = new ArrayList<Player>();
        if (player != null) {
            if (this.isNotWatching(player)) {
                return;
            }
            handle.add(player);
        } else {
            handle.addAll(this.watchList);
        }
        for (Player p : handle) {
            if (!this.isSpawnable(p.getLocation(), force)) continue;
            if (this.visible) {
                if (this.isSpawnedFor(p)) {
                    if (!this.hasChanged(p)) continue;
                    this.updateText(p);
                    this.setChanged(p, false);
                    continue;
                }
                this.spawn(p);
                continue;
            }
            if (this.isSpawnedFor(p)) {
                this.destroy(p);
                continue;
            }
            this.initiatedPlayers.put(player, false);
        }
        handle.clear();
    }

    private void updateText(Player player) {
        if (this.cannotUpdateText() || !this.isSpawnedFor(player)) {
            return;
        }
        for (int i = 0; i < this.entities.size(); ++i) {
            HologramPackets.update(player, this.entities.get(i), this.modifyText(player, this.text.get(i)));
        }
    }

    public String modifyText(Player player, String text) {
        return text;
    }

    private void injectPacketReader(final Player player) {
        if (Version.atLeast(17.0)) {
            return;
        }
        new PacketReader(player, "CodingAPI-HologramReader", this.getPlugin()){

            @Override
            public boolean readPacket(Object packet) {
                if (packet.getClass().getSimpleName().equals("PacketPlayInUseEntity")) {
                    Action a;
                    IReflection.FieldAccessor action = IReflection.getField(packet.getClass(), "action");
                    IReflection.FieldAccessor fA = IReflection.getField(packet.getClass(), "a");
                    int clicked = (Integer)fA.get(packet);
                    String aS = action.get(packet).toString();
                    if (aS.equals("INTERACT_AT")) {
                        a = Action.RIGHT_CLICK_AIR;
                    } else if (aS.equals("ATTACK")) {
                        a = Action.LEFT_CLICK_AIR;
                    } else {
                        return false;
                    }
                    ArrayList armorStands = new ArrayList(Hologram.this.entities);
                    for (Object entity : armorStands) {
                        int id = PacketUtils.EntityPackets.getId(entity);
                        if (id != clicked) continue;
                        Bukkit.getScheduler().runTask((Plugin)Hologram.this.getPlugin(), () -> Bukkit.getPluginManager().callEvent((Event)new PlayerInteractEvent(player, a, player.getInventory().getItem(player.getInventory().getHeldItemSlot()), null, BlockFace.UP)));
                        break;
                    }
                    armorStands.clear();
                }
                return false;
            }

            @Override
            public boolean writePacket(Object packet) {
                return false;
            }
        }.inject();
    }

    private void uninjectPacketReader(Player player) {
        if (Version.atLeast(17.0)) {
            return;
        }
        List<PacketReader> l = API.getRemovables(player, PacketReader.class);
        for (PacketReader reader : l) {
            if (!reader.getName().equals("CodingAPI-HologramReader")) continue;
            reader.unInject();
            break;
        }
        l.clear();
    }

    private void spawn(Player player) {
        if (this.isSpawnedFor(player)) {
            return;
        }
        this.injectPacketReader(player);
        for (Object entity : this.entities) {
            HologramPackets.spawn(player, entity);
        }
        this.initiatedPlayers.put(player, true);
        this.update(player);
    }

    private void destroy(Player player) {
        if (!this.isSpawnedFor(player)) {
            return;
        }
        for (Object entity : this.entities) {
            HologramPackets.destroy(player, entity);
        }
        this.uninjectPacketReader(player);
        this.initiatedPlayers.remove(player);
    }

    private void remove() {
        this.remove(null);
    }

    private void remove(Player player) {
        if (this.initiatedPlayers.containsKey(player)) {
            this.initiatedPlayers.remove(player);
            this.destroy(player);
        }
    }

    @Override
    public void destroy() {
        this.watchList.forEach(this::destroy);
        this.initiatedPlayers.clear();
        this.watchList.clear();
        this.text.clear();
        this.entities.clear();
        if (this.runnable != null) {
            this.runnable.cancel();
            this.runnable = null;
        }
        API.removeRemovable(this);
    }

    private void setChanged() {
        for (Player player : this.initiatedPlayers.keySet()) {
            this.setChanged(player, true);
        }
    }

    private void setChanged(Player player, boolean changed) {
        this.initiatedPlayers.replace(player, changed);
    }

    private boolean hasChanged(Player player) {
        Boolean changed = this.initiatedPlayers.get(player);
        return changed != null && changed != false;
    }

    public void addPlayer(Player player) {
        if (!this.watchList.contains(player)) {
            this.watchList.add(player);
            this.update(player);
        }
    }

    public void addAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.addPlayer(player);
        }
    }

    public void removePlayer(Player player) {
        this.watchList.remove(player);
        this.destroy(player);
    }

    public boolean isNotWatching(Player player) {
        return !this.watchList.contains(player);
    }

    public void addText(String ... text) {
        this.addText(new ArrayList<String>(Arrays.asList(text)));
    }

    public void addText(List<String> text) {
        if (this.isSame(this.text, text)) {
            return;
        }
        this.setChanged();
        this.text.addAll(text);
        text.clear();
    }

    public List<String> getText() {
        return Collections.unmodifiableList(this.text);
    }

    public void setText(String ... text) {
        this.setText(new ArrayList<String>(Arrays.asList(text)));
    }

    public void setText(List<String> text) {
        if (this.isSame(this.text, text)) {
            return;
        }
        this.setChanged();
        this.text.clear();
        for (String s : text) {
            this.text.addAll(Arrays.asList(s.split("\n", -1)));
        }
        text.clear();
    }

    private boolean isSame(List<String> list0, List<String> list1) {
        if (list0 == list1) {
            return true;
        }
        if (list0 == null || list1 == null) {
            return false;
        }
        if (list0.size() == list1.size()) {
            boolean same = true;
            for (int i = 0; i < list0.size(); ++i) {
                if (list0.get(i) == null || list1.get(i) == null) {
                    if (Objects.equals(list0.get(i), list1.get(i))) continue;
                    same = false;
                    break;
                }
                if (list0.get(i).equals(list1.get(i))) continue;
                same = false;
                break;
            }
            return same;
        }
        return false;
    }

    private boolean isSpawnable(Location location, boolean force) {
        return this.location != null && location != null && this.location.getWorld() == location.getWorld() && (force || this.location.distance(location) <= 120.0);
    }

    private boolean cannotUpdateText() {
        return this.text == null || this.text.size() != this.entities.size();
    }

    private boolean isSpawnedFor(Player player) {
        return this.initiatedPlayers.containsKey(player);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.setChanged();
        this.visible = visible;
    }

    @Override
    public Player getPlayer() {
        return null;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public Location getSource() {
        return this.source.clone();
    }

    public Location getLocation() {
        return this.location.clone();
    }

    static {
        if (Version.atLeast(19.3)) {
            Class<?> c = HologramPackets.getArmorStandClass();
            DATA_WATCHER_OBJECTS.addAll(HologramPackets.getDataWatcherObjects(c));
        }
    }

    public static class HologramPackets {
        private static final IReflection.MethodAccessor setInvisible;
        private static final IReflection.MethodAccessor setVisible;
        private static final IReflection.FieldAccessor<Boolean> invulnerableField;
        private static final Class<?> dataWatcherItemClass;
        private static final Class<?> dataWatcherBClass;
        private static final IReflection.MethodAccessor getDataWatcherItem;
        private static final IReflection.MethodAccessor serializeItem;
        private static final IReflection.MethodAccessor getDataWatcher;
        private static final IReflection.MethodAccessor setPosition;
        private static final IReflection.FieldAccessor<?> world;
        private static final IReflection.ConstructorAccessor SPAWN_PACKET_CONSTRUCTOR;
        private static final IReflection.ConstructorAccessor DESTROY_PACKET_CONSTRUCTOR;
        private static final IReflection.ConstructorAccessor TELEPORT_PACKET_CONSTRUCTOR;
        private static final IReflection.ConstructorAccessor ARMOR_STAND_CONSTRUCTOR;

        @NmsLoader
        private HologramPackets() {
        }

        @NotNull
        private static ArmorStand bukkit(@NotNull Object nms) {
            return (ArmorStand)PacketUtils.getBukkitEntity(nms);
        }

        public static void setGravity(Object armorStand, boolean gravity) {
            HologramPackets.bukkit(armorStand).setGravity(gravity);
        }

        public static void setInvisible(Object armorStand, boolean invisible) {
            ArmorStand as = HologramPackets.bukkit(armorStand);
            if (setInvisible != null) {
                setInvisible.invoke(as, invisible);
            } else if (setVisible != null) {
                setVisible.invoke(as, !invisible);
            } else {
                throw new IllegalStateException("Cannot find setInvisible nor setVisible for ArmorStands! Please contact the plugin author.");
            }
        }

        public static void setInvulnerable(Object armorStand, boolean invulnerable) {
            if (Version.atLeast(9.0)) {
                HologramPackets.bukkit(armorStand).setInvulnerable(invulnerable);
            } else {
                invulnerableField.set(armorStand, invulnerable);
            }
        }

        public static void setMarker(Object armorStand, boolean invulnerable) {
            HologramPackets.bukkit(armorStand).setMarker(invulnerable);
        }

        public static void setCustomName(Object armorStand, String text) {
            HologramPackets.bukkit(armorStand).setCustomName(text);
        }

        public static void setCustomNameVisible(Object armorStand, boolean visible) {
            HologramPackets.bukkit(armorStand).setCustomNameVisible(visible);
        }

        public static void update(Player player, Object armorStand, String text) {
            HologramPackets.setCustomName(armorStand, text);
            HologramPackets.sendDataWatcher(player, armorStand);
        }

        public static void sendDataWatcher(Player player, Object armorStand) {
            if (Version.atLeast(19.3)) {
                assert (PacketUtils.DataWatcherObjectClass != null);
                Object watcher = getDataWatcher.invoke(armorStand, new Object[0]);
                ArrayList<Object> items = new ArrayList<Object>();
                for (Object dataWatcherObject : DATA_WATCHER_OBJECTS) {
                    Object item = getDataWatcherItem.invoke(watcher, dataWatcherObject);
                    if (item == null) continue;
                    items.add(serializeItem.invoke(item, new Object[0]));
                }
                Packet packet = new Packet(PacketUtils.PacketPlayOutEntityMetadataClass, player);
                packet.initialize(new Class[]{Integer.TYPE, List.class}, new Object[]{PacketUtils.EntityPackets.getId(armorStand), items});
                packet.send();
            } else {
                Packet packet = new Packet(PacketUtils.PacketPlayOutEntityMetadataClass, player);
                packet.initialize(new Class[]{Integer.TYPE, PacketUtils.DataWatcherClass, Boolean.TYPE}, new Object[]{PacketUtils.EntityPackets.getId(armorStand), getDataWatcher.invoke(armorStand, new Object[0]), true});
                packet.send();
            }
        }

        public static void destroy(Player player, Object armorStand) {
            Object packet = Version.get() == Version.v1_17 ? DESTROY_PACKET_CONSTRUCTOR.newInstance(PacketUtils.EntityPackets.getId(armorStand)) : DESTROY_PACKET_CONSTRUCTOR.newInstance(new Object[]{new int[]{PacketUtils.EntityPackets.getId(armorStand)}});
            PacketUtils.sendPacket(packet, player);
        }

        public static void spawn(Player player, Object armorStand) {
            Object packet;
            if (Version.atLeast(21.0)) {
                Location l = HologramPackets.bukkit(armorStand).getLocation();
                packet = SPAWN_PACKET_CONSTRUCTOR.newInstance(armorStand, 0, PacketUtils.getBlockPosition(l));
                IReflection.getNonStaticField(packet.getClass(), Double.TYPE, 0).set(packet, l.getX());
                IReflection.getNonStaticField(packet.getClass(), Double.TYPE, 1).set(packet, l.getY());
                IReflection.getNonStaticField(packet.getClass(), Double.TYPE, 2).set(packet, l.getZ());
            } else {
                packet = SPAWN_PACKET_CONSTRUCTOR.newInstance(armorStand);
            }
            PacketUtils.sendPacket(packet, player);
            if (Version.get().isBiggerThan(Version.v1_14)) {
                HologramPackets.sendDataWatcher(player, armorStand);
            }
        }

        public static void setLocation(Object armorStand, Location location) {
            world.set(armorStand, PacketUtils.getWorldServer(location.getWorld()));
            setPosition.invoke(armorStand, location.getX(), location.getY(), location.getZ());
        }

        public static void teleport(Object armorStand, Location location, Player ... players) {
            if (Version.atLeast(17.0)) {
                Object packet = TELEPORT_PACKET_CONSTRUCTOR.newInstance(armorStand);
                PacketUtils.sendPacket(packet, players);
            } else {
                Object packet = PacketUtils.EntityPackets.getTeleportPacket(armorStand, location);
                PacketUtils.sendPacket(packet, players);
            }
        }

        public static Object createArmorStand(Location location) {
            return ARMOR_STAND_CONSTRUCTOR.newInstance(PacketUtils.getWorldServer(location.getWorld()), location.getX(), location.getY(), location.getZ());
        }

        @NotNull
        public static Class<?> getArmorStandClass() {
            return IReflection.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.world.entity.decoration"), "EntityArmorStand");
        }

        public static Set<Object> getDataWatcherObjects(Class<?> c) {
            HashSet<Object> objects = new HashSet<Object>();
            for (Field declaredField : c.getDeclaredFields()) {
                if (PacketUtils.DataWatcherObjectClass != declaredField.getType()) continue;
                declaredField.setAccessible(true);
                try {
                    objects.add(declaredField.get(null));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (c.getSuperclass() != null) {
                objects.addAll(HologramPackets.getDataWatcherObjects(c.getSuperclass()));
            }
            return objects;
        }

        static {
            Class<?> entity;
            setInvisible = IReflection.getSaveMethod(ArmorStand.class, "setInvisible", null, Boolean.TYPE);
            setVisible = IReflection.getSaveMethod(ArmorStand.class, "setVisible", null, Boolean.TYPE);
            setPosition = IReflection.getMethod(PacketUtils.EntityClass, Version.choose("setPosition", 18.0, "c", 19.3, "p", 20.5, "setPos"), new Class[]{Double.TYPE, Double.TYPE, Double.TYPE});
            world = IReflection.getField(PacketUtils.EntityClass, PacketUtils.WorldClass, 0);
            invulnerableField = Version.atMost(8.0) ? IReflection.getField(PacketUtils.EntityClass, "invulnerable") : null;
            if (Version.atLeast(19.3)) {
                dataWatcherItemClass = IReflection.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.network.syncher"), Version.choose("DataWatcher$Item", 20.5, "SynchedEntityData$DataItem"));
                dataWatcherBClass = IReflection.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE("net.minecraft.network.syncher"), Version.choose("DataWatcher$b", 20.5, "SynchedEntityData$DataValue"));
                getDataWatcherItem = IReflection.getMethod(PacketUtils.DataWatcherClass, dataWatcherItemClass, new Class[]{PacketUtils.DataWatcherObjectClass});
                serializeItem = IReflection.getMethod(dataWatcherItemClass, dataWatcherBClass, new Class[0]);
            } else {
                dataWatcherItemClass = null;
                dataWatcherBClass = null;
                getDataWatcherItem = null;
                serializeItem = null;
            }
            getDataWatcher = IReflection.getMethod(PacketUtils.EntityClass, PacketUtils.DataWatcherClass, new Class[0]);
            SPAWN_PACKET_CONSTRUCTOR = Version.atLeast(21.0) ? IReflection.getConstructor(PacketUtils.PacketPlayOutSpawnEntityClass, PacketUtils.EntityLivingClass, Integer.TYPE, PacketUtils.BlockPositionClass) : (Version.atLeast(19.0) ? IReflection.getConstructor(PacketUtils.PacketPlayOutSpawnEntityClass, PacketUtils.EntityLivingClass) : IReflection.getConstructor(PacketUtils.PacketPlayOutSpawnEntityLivingClass, PacketUtils.EntityLivingClass));
            if (SPAWN_PACKET_CONSTRUCTOR == null) {
                throw new NullPointerException("Constructor could not be found.");
            }
            DESTROY_PACKET_CONSTRUCTOR = Version.get() == Version.v1_17 ? IReflection.getConstructor(PacketUtils.PacketPlayOutEntityDestroyClass, Integer.TYPE) : IReflection.getConstructor(PacketUtils.PacketPlayOutEntityDestroyClass, int[].class);
            if (DESTROY_PACKET_CONSTRUCTOR == null) {
                throw new NullPointerException("Constructor could not be found.");
            }
            if (Version.atLeast(17.0)) {
                TELEPORT_PACKET_CONSTRUCTOR = IReflection.getConstructor(PacketUtils.PacketPlayOutEntityTeleportClass, PacketUtils.EntityClass);
                if (TELEPORT_PACKET_CONSTRUCTOR == null) {
                    throw new NullPointerException("Constructor could not be found.");
                }
            } else {
                TELEPORT_PACKET_CONSTRUCTOR = null;
            }
            if ((ARMOR_STAND_CONSTRUCTOR = IReflection.getConstructor(entity = HologramPackets.getArmorStandClass(), PacketUtils.WorldServerClass, Double.TYPE, Double.TYPE, Double.TYPE)) == null) {
                throw new NullPointerException("Constructor could not be found.");
            }
        }
    }
}

