/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.standalone;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.Animation;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class VectorAnimation
extends Animation {
    private final Location start;
    private final Vector direction;
    private int pos = 0;
    private final int length;
    private int repetitions = -1;
    private int runs = 0;
    private int ticksBetweenParticles = 0;
    private int skippedTicks = 0;

    public VectorAnimation(Particle particle, Location start, Vector direction, int length) {
        super(particle);
        this.start = start;
        this.direction = direction;
        this.length = length;
    }

    public VectorAnimation(Particle particle, Location start, Vector direction, int length, int ticksBetweenParticles) {
        super(particle);
        this.start = start;
        this.direction = direction;
        this.length = length;
        this.ticksBetweenParticles = ticksBetweenParticles;
    }

    public VectorAnimation(Particle particle, Location start, Vector direction, int pos, int length, int repetitions, int ticksBetweenParticles) {
        super(particle);
        this.start = start;
        this.direction = direction;
        this.pos = pos;
        this.length = length;
        this.repetitions = repetitions;
        this.ticksBetweenParticles = ticksBetweenParticles;
    }

    @Override
    public void onTick() {
        if (this.ticksBetweenParticles > 0 && this.skippedTicks < this.ticksBetweenParticles) {
            ++this.skippedTicks;
            return;
        }
        if (this.ticksBetweenParticles > 0 && this.skippedTicks == this.ticksBetweenParticles) {
            this.skippedTicks = 0;
        }
        if (this.pos > this.length) {
            ++this.runs;
            if (this.repetitions < 0 || this.runs < this.repetitions) {
                this.pos = 0;
            } else if (this.runs >= this.repetitions) {
                this.pos = 0;
                this.runs = 0;
                this.setRunning(false);
                return;
            }
        }
        Location loc = this.start.clone().add(this.direction.clone().multiply(this.pos));
        this.sendParticle(loc);
        ++this.pos;
    }

    public Location getStart() {
        return this.start;
    }

    public Vector getDirection() {
        return this.direction;
    }

    public int getLength() {
        return this.length;
    }
}

