/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.standalone;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.Animation;
import org.bukkit.Location;

public class SinusAnimation
extends Animation {
    private final Location location;
    private boolean minimize = true;
    private final double radius;
    private final double fixedHeight;
    private double height;
    private double degrees = 0.0;
    private Location circleLocation;

    public SinusAnimation(Particle particle, Location location, double radius, double height) {
        super(particle);
        this.location = location;
        this.radius = radius;
        this.height = this.fixedHeight = height;
        this.calculateStep();
    }

    private void calculateStep() {
        double dif = 0.25;
        double step = 0.1;
        if (this.minimize) {
            this.height -= step;
            if (this.height < this.fixedHeight - dif) {
                this.minimize = false;
            }
        } else {
            this.height += step;
            if (this.height > this.fixedHeight + dif) {
                this.minimize = true;
            }
        }
        this.circleLocation = this.location.clone().add(this.radius * Math.cos(this.degrees * Math.PI / 180.0), this.height, this.radius * Math.sin(this.degrees * Math.PI / 180.0));
        this.degrees += 12.0 - this.radius * 0.2;
        if (this.degrees >= 360.0) {
            this.degrees -= 360.0;
        }
        if (this.degrees < 0.0) {
            this.degrees += 360.0;
        }
    }

    @Override
    public void onTick() {
        this.sendParticle(this.circleLocation);
        this.calculateStep();
    }

    public Location getLocation() {
        return this.location;
    }

    public double getFixedHeight() {
        return this.fixedHeight;
    }

    public double getRadius() {
        return this.radius;
    }
}

