/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.standalone;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.Animation;
import java.util.ArrayList;
import org.bukkit.Location;

public class PulsingCircleAnimation
extends Animation {
    private double radius;
    private double height;
    private final Location location;
    private int ticksBetweenParticles = 0;
    private int skippedTicks = 0;

    public PulsingCircleAnimation(Particle particle, double radius, double height, Location location) {
        super(particle);
        this.radius = radius;
        this.height = height;
        this.location = location;
    }

    public PulsingCircleAnimation(Particle particle, double radius, double height, Location location, int ticksBetweenParticles) {
        super(particle);
        this.radius = radius;
        this.height = height;
        this.location = location;
        this.ticksBetweenParticles = ticksBetweenParticles;
    }

    @Override
    public void onTick() {
        if (this.ticksBetweenParticles > 0 && this.skippedTicks < this.ticksBetweenParticles) {
            ++this.skippedTicks;
            return;
        }
        if (this.ticksBetweenParticles > 0 && this.skippedTicks == this.ticksBetweenParticles) {
            this.skippedTicks = 0;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        double diff = 12.0 - this.radius * 0.2;
        int i = 0;
        while ((double)i < 360.0 / diff) {
            double degrees = diff * (double)i;
            if (degrees >= 360.0) {
                degrees -= 360.0;
            }
            if (degrees < 0.0) {
                degrees += 360.0;
            }
            double x = this.radius * Math.cos(degrees * Math.PI / 180.0);
            double y = this.height;
            double z = this.radius * Math.sin(degrees * Math.PI / 180.0);
            Location loc = this.location.clone();
            loc.add(x, y, z);
            locations.add(loc);
            ++i;
        }
        for (Location loc : locations) {
            this.sendParticle(loc);
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getTicksBetweenParticles() {
        return this.ticksBetweenParticles;
    }
}

