/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.standalone;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.Animation;
import org.bukkit.Location;

public class CircleAnimation
extends Animation {
    private double radius;
    private double degrees;
    private double height;
    private final Location location;
    private int ticksBetweenParticles = 0;
    private int skippedTicks = 0;

    public CircleAnimation(Particle particle, double radius, double height, Location location) {
        super(particle);
        this.radius = radius;
        this.height = height;
        this.location = location;
    }

    public CircleAnimation(Particle particle, double radius, double height, Location location, int ticksBetweenParticles) {
        super(particle);
        this.radius = radius;
        this.height = height;
        this.location = location;
        this.ticksBetweenParticles = ticksBetweenParticles;
    }

    @Override
    public void onTick() {
        if (this.ticksBetweenParticles > 0 && this.skippedTicks < this.ticksBetweenParticles) {
            ++this.skippedTicks;
            return;
        }
        if (this.ticksBetweenParticles > 0 && this.skippedTicks == this.ticksBetweenParticles) {
            this.skippedTicks = 0;
        }
        Location loc = this.location.clone();
        this.degrees += 12.0 - this.radius * 0.2;
        if (this.degrees >= 360.0) {
            this.degrees -= 360.0;
        }
        if (this.degrees < 0.0) {
            this.degrees += 360.0;
        }
        double x = this.radius * Math.cos(this.degrees * Math.PI / 180.0);
        double y = this.height;
        double z = this.radius * Math.sin(this.degrees * Math.PI / 180.0);
        loc.add(x, y, z);
        this.sendParticle(loc);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getTicksBetweenParticles() {
        return this.ticksBetweenParticles;
    }
}

