/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.CustomAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.movables.MovableMid;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;

public class SinusAnimation
extends CustomAnimation {
    private static final List<List<Location>> CACHE = new ArrayList<List<Location>>();

    public SinusAnimation(Particle particle, MovableMid mid, double radius, double height, int delay) {
        super(particle, mid, radius, height, delay);
    }

    public SinusAnimation(Particle particle, Location mid, double radius, double height, int delay) {
        super(particle, mid, radius, height, delay);
    }

    @Override
    public List<List<Location>> calculate(boolean cached) {
        double r = cached ? 2.0 : this.getRadius();
        ArrayList<List<Location>> locations = cached ? CACHE : new ArrayList<List<Location>>();
        this.clear(CACHE);
        double dif = 0.25;
        double step = 8.0 * (2.0 * dif) / (360.0 / (12.0 - r * 0.2));
        boolean minimize = false;
        double height = -dif;
        for (double degrees = 0.0; degrees < 360.0; degrees += 12.0 - r * 0.2) {
            if (minimize) {
                if ((height -= step) < -dif) {
                    minimize = false;
                }
            } else if ((height += step) > dif) {
                minimize = true;
            }
            final Location circleLocation = this.getZero().add(r * Math.cos(degrees * Math.PI / 180.0), height, r * Math.sin(degrees * Math.PI / 180.0));
            locations.add((List<Location>)new ArrayList<Location>(){
                {
                    this.add(circleLocation);
                }
            });
        }
        return locations;
    }

    @Override
    public boolean isMotionAnimation() {
        return true;
    }

    @Override
    List<List<Location>> getAnimCache() {
        return CACHE;
    }
}

