/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.CustomAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.movables.MovableMid;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;

public class RotatingCircleAnimation
extends CustomAnimation {
    private static final List<List<Location>> CACHE = new ArrayList<List<Location>>();

    public RotatingCircleAnimation(Particle particle, MovableMid mid, double radius, double height, int delay) {
        super(particle, mid, radius, height, delay);
    }

    public RotatingCircleAnimation(Particle particle, Location mid, double radius, double height, int delay) {
        super(particle, mid, radius, height, delay);
    }

    @Override
    public List<List<Location>> calculate(boolean cached) {
        double r = cached ? 2.0 : this.getRadius();
        ArrayList<List<Location>> locations = cached ? CACHE : new ArrayList<List<Location>>();
        this.clear(CACHE);
        double d = 0.0;
        while (d < 36.0) {
            ArrayList<Location> l = new ArrayList<Location>();
            d += 2.0;
            for (int i = 0; i < 360; i += 36) {
                double degrees = (double)i + d;
                if (degrees >= 360.0) {
                    degrees -= 360.0;
                }
                if (degrees < 0.0) {
                    degrees += 360.0;
                }
                double x = r * Math.cos(degrees * Math.PI / 180.0);
                double z = r * Math.sin(degrees * Math.PI / 180.0);
                l.add(this.getZero().add(x, 0.0, z));
            }
            locations.add(l);
        }
        return locations;
    }

    @Override
    public boolean isMotionAnimation() {
        return true;
    }

    @Override
    List<List<Location>> getAnimCache() {
        return CACHE;
    }
}

