/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.CustomAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.movables.MovableMid;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;

public class PulsingCircleAnimation
extends CustomAnimation {
    private static final List<List<Location>> CACHE = new ArrayList<List<Location>>();

    public PulsingCircleAnimation(Particle particle, MovableMid mid, double radius, double height, int delay) {
        super(particle, mid, radius, height, delay);
    }

    public PulsingCircleAnimation(Particle particle, Location mid, double radius, double height, int delay) {
        super(particle, mid, radius, height, delay);
    }

    @Override
    public List<List<Location>> calculate(boolean cached) {
        double r = cached ? 2.0 : this.getRadius();
        ArrayList<List<Location>> locations = cached ? CACHE : new ArrayList<List<Location>>();
        this.clear(CACHE);
        ArrayList<Location> l = new ArrayList<Location>();
        double diff = 12.0 - r * 0.2;
        int i = 0;
        while ((double)i < 360.0 / diff) {
            double degrees = diff * (double)i;
            if (degrees >= 360.0) {
                degrees -= 360.0;
            }
            if (degrees < 0.0) {
                degrees += 360.0;
            }
            double x = r * Math.cos(degrees * Math.PI / 180.0);
            double z = r * Math.sin(degrees * Math.PI / 180.0);
            l.add(this.getZero().add(x, 0.0, z));
            ++i;
        }
        locations.add(l);
        return locations;
    }

    @Override
    public boolean isMotionAnimation() {
        return false;
    }

    @Override
    List<List<Location>> getAnimCache() {
        return CACHE;
    }
}

